/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smiles.SmilesGenerator;
import uk.ac.ebi.reactionblast.containers.FingerPrintContainer;
import uk.ac.ebi.reactionblast.containers.MolContainer;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.tools.BasicDebugger;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.rxnfile.RXNFileImporter;

public class RXNFileManipulator
extends BasicDebugger {
    private static FingerPrintContainer FPC = FingerPrintContainer.getInstance();
    private static final Logger LOG = Logger.getLogger(RXNFileManipulator.class.getName());
    private MolContainer atomContainer = MolContainer.getInstance();
    private Integer moleculeCounter = 0;

    public RXNFileManipulator() {
        FPC = FingerPrintContainer.getInstance();
        this.atomContainer = MolContainer.getInstance();
        this.moleculeCounter = 0;
        try {
            FPC.Clear();
        }
        catch (IOException ex) {
            Logger.getLogger(RXNFileManipulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.atomContainer.Clear();
        }
        catch (IOException ex) {
            Logger.getLogger(RXNFileManipulator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public IReaction process(File rxnFile) throws Exception {
        IReaction cleanedReaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        HashMap<String, Double> _Stoichiometry = new HashMap<String, Double>();
        HashSet<IAtomContainer> _Metabolites = new HashSet<IAtomContainer>();
        String FileName = rxnFile.getName();
        try {
            if (FileName.endsWith(".rxn")) {
                String ID;
                IAtomContainer ac;
                IAtomContainer mol;
                int i;
                System.out.println("Reading the input RXN File");
                String RXNFileName = rxnFile.getCanonicalPath();
                RXNFileImporter rxn = new RXNFileImporter();
                rxn.readFile(RXNFileName);
                String REGEX = "\\.";
                String ReactionID = "";
                Pattern p = Pattern.compile(REGEX);
                String[] fields = p.split(FileName);
                ReactionID = ReactionID + fields[0];
                IAtomContainerSet _imoledu = rxn.getReactants();
                IAtomContainerSet _imolpro = rxn.getProducts();
                System.out.println("Number of Reactant " + _imoledu.getAtomContainerCount());
                System.out.println("Number of Product " + _imolpro.getAtomContainerCount());
                cleanedReaction.setID(ReactionID);
                _Stoichiometry.clear();
                Double _TempStoic = 0.0;
                for (i = 0; i < _imoledu.getAtomContainerCount(); ++i) {
                    mol = _imoledu.getAtomContainer(i);
                    _TempStoic = 0.0;
                    ac = this.setProperty(mol);
                    ID = ac.getID();
                    mol = mol.getBuilder().newInstance(IAtomContainer.class, ac);
                    mol.setID(ID);
                    if (_Stoichiometry.containsKey(mol.getID())) {
                        _TempStoic = (Double)_Stoichiometry.get(mol.getID()) + 1.0;
                        _Stoichiometry.put(mol.getID(), _TempStoic);
                        continue;
                    }
                    _Stoichiometry.put(mol.getID(), 1.0);
                    _Metabolites.add(mol);
                }
                this.setReactantMolecule(cleanedReaction, _Stoichiometry, _Metabolites);
                for (i = 0; i < _imolpro.getAtomContainerCount(); ++i) {
                    mol = _imolpro.getAtomContainer(i);
                    ac = this.setProperty(mol);
                    ID = ac.getID();
                    mol = mol.getBuilder().newInstance(IAtomContainer.class, ac);
                    mol.setID(ID);
                    _TempStoic = 0.0;
                    if (_Stoichiometry.containsKey(mol.getID())) {
                        _TempStoic = (Double)_Stoichiometry.get(mol.getID()) + 1.0;
                        _Stoichiometry.put(mol.getID(), _TempStoic);
                        continue;
                    }
                    _Stoichiometry.put(mol.getID(), 1.0);
                    _Metabolites.add(mol);
                }
                this.setProductMolecule(cleanedReaction, _Stoichiometry, _Metabolites);
                cleanedReaction.setDirection(IReaction.Direction.BIDIRECTIONAL);
            }
        }
        catch (IOException ex) {
            System.err.println("Error: Generation of FingerPrint Failed the AtomContainer: ");
            ex.printStackTrace();
        }
        FPC.Clear();
        this.atomContainer.Clear();
        System.out.println("Reaction is read and initialized");
        return cleanedReaction;
    }

    public IReaction processMACiE(File rxnFile) throws Exception {
        IReaction IR = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        HashMap<String, Double> _Stoichiometry = new HashMap<String, Double>();
        HashSet<IAtomContainer> _Metabolites = new HashSet<IAtomContainer>();
        String FileName = rxnFile.getName();
        if (FileName.endsWith(".rxn")) {
            try {
                String ID;
                IAtomContainer ac;
                IAtomContainer mol;
                int i;
                String RXNFileName = rxnFile.getCanonicalPath();
                RXNFileImporter rxn = new RXNFileImporter();
                rxn.readFile(RXNFileName);
                String REGEX = "\\.";
                String ReactionID = "R";
                Pattern p = Pattern.compile(REGEX);
                String[] fields = p.split(FileName);
                if (!FileName.endsWith(".ov.rxn")) {
                    System.out.println("Reading the input MACiE rxn (stage reaction) File");
                    ReactionID = ReactionID + fields[0] + fields[1].replace("stg", ".");
                } else {
                    System.out.println("Reading the input MACiE rxn (overall reaction) File");
                    ReactionID = fields[0] + fields[1].replace("ov", "");
                }
                IAtomContainerSet _imoledu = rxn.getReactants();
                IAtomContainerSet _imolpro = rxn.getProducts();
                IR.setID(ReactionID);
                Double _TempStoic = 0.0;
                for (i = 0; i < _imoledu.getAtomContainerCount(); ++i) {
                    mol = _imoledu.getAtomContainer(i);
                    _TempStoic = 0.0;
                    ac = this.setProperty(mol);
                    ID = ac.getID();
                    mol = mol.getBuilder().newInstance(IAtomContainer.class, ac);
                    mol.setID(ID);
                    if (_Stoichiometry.containsKey(mol.getID())) {
                        _TempStoic = (Double)_Stoichiometry.get(mol.getID()) + 1.0;
                        _Stoichiometry.put(mol.getID(), _TempStoic);
                        continue;
                    }
                    _Stoichiometry.put(mol.getID(), 1.0);
                    _Metabolites.add(mol);
                }
                this.setReactantMolecule(IR, _Stoichiometry, _Metabolites);
                for (i = 0; i < _imolpro.getAtomContainerCount(); ++i) {
                    mol = _imolpro.getAtomContainer(i);
                    ac = this.setProperty(mol);
                    ID = ac.getID();
                    mol = mol.getBuilder().newInstance(IAtomContainer.class, ac);
                    mol.setID(ID);
                    _TempStoic = 0.0;
                    if (_Stoichiometry.containsKey(mol.getID())) {
                        _TempStoic = (Double)_Stoichiometry.get(mol.getID()) + 1.0;
                        _Stoichiometry.put(mol.getID(), _TempStoic);
                        continue;
                    }
                    _Stoichiometry.put(mol.getID(), 1.0);
                    _Metabolites.add(mol);
                }
                this.setProductMolecule(IR, _Stoichiometry, _Metabolites);
                IR.setDirection(IReaction.Direction.BIDIRECTIONAL);
            }
            catch (IOException ex) {
                Logger.getLogger(RXNFileManipulator.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        FPC.Clear();
        this.atomContainer.Clear();
        System.out.println("Reaction is read and initialized");
        return IR;
    }

    public IReaction processIntEnz(File rxnFile) throws Exception {
        IReaction IR = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        HashMap<String, Double> _Stoichiometry = new HashMap<String, Double>();
        HashSet<IAtomContainer> _Metabolites = new HashSet<IAtomContainer>();
        String FileName = rxnFile.getName();
        try {
            if (FileName.endsWith(".rxn")) {
                String ID;
                IAtomContainer ac;
                IAtomContainer mol;
                int i;
                System.out.println("Reading the input RehA rxn File");
                String RXNFileName = rxnFile.getCanonicalPath();
                RXNFileImporter rxn = new RXNFileImporter();
                rxn.readFile(RXNFileName);
                String REGEX = "\\.";
                String ReactionID = "";
                Pattern p = Pattern.compile(REGEX);
                String[] fields = p.split(FileName);
                ReactionID = ReactionID + fields[0];
                int direction = Integer.parseInt(fields[1]);
                IAtomContainerSet _imoledu = rxn.getReactants();
                IAtomContainerSet _imolpro = rxn.getProducts();
                IR.setID(ReactionID);
                _Stoichiometry.clear();
                Double _TempStoic = 0.0;
                for (i = 0; i < _imoledu.getAtomContainerCount(); ++i) {
                    mol = _imoledu.getAtomContainer(i);
                    _TempStoic = 0.0;
                    ac = this.setProperty(mol);
                    ID = ac.getID();
                    mol = mol.getBuilder().newInstance(IAtomContainer.class, ac);
                    mol.setID(ID);
                    if (_Stoichiometry.containsKey(mol.getID())) {
                        _TempStoic = (Double)_Stoichiometry.get(mol.getID()) + 1.0;
                        _Stoichiometry.put(mol.getID(), _TempStoic);
                        continue;
                    }
                    _Stoichiometry.put(mol.getID(), 1.0);
                    _Metabolites.add(mol);
                }
                this.setReactantMolecule(IR, _Stoichiometry, _Metabolites);
                for (i = 0; i < _imolpro.getAtomContainerCount(); ++i) {
                    mol = _imolpro.getAtomContainer(i);
                    ac = this.setProperty(mol);
                    ID = ac.getID();
                    mol = mol.getBuilder().newInstance(IAtomContainer.class, ac);
                    mol.setID(ID);
                    _TempStoic = 0.0;
                    if (_Stoichiometry.containsKey(mol.getID())) {
                        _TempStoic = (Double)_Stoichiometry.get(mol.getID()) + 1.0;
                        _Stoichiometry.put(mol.getID(), _TempStoic);
                        continue;
                    }
                    _Stoichiometry.put(mol.getID(), 1.0);
                    _Metabolites.add(mol);
                }
                this.setProductMolecule(IR, _Stoichiometry, _Metabolites);
                if (direction == 1) {
                    IR.setDirection(IReaction.Direction.FORWARD);
                } else if (direction == 2) {
                    IR.setDirection(IReaction.Direction.BACKWARD);
                } else if (direction == 3 || direction == 0) {
                    IR.setDirection(IReaction.Direction.BIDIRECTIONAL);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(RXNFileManipulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        FPC.Clear();
        this.atomContainer.Clear();
        System.out.println("Reaction is read and initialized");
        return IR;
    }

    private void setReactantMolecule(IReaction IR, Map<String, Double> _Stoichiometry, Set<IAtomContainer> _Metabolites) {
        for (IAtomContainer mol : _Metabolites) {
            IR.addReactant(mol, _Stoichiometry.get(mol.getID()));
        }
        _Metabolites.clear();
        _Stoichiometry.clear();
    }

    private void setProductMolecule(IReaction IR, Map<String, Double> _Stoichiometry, Set<IAtomContainer> _Metabolites) {
        for (IAtomContainer mol : _Metabolites) {
            IR.addProduct(mol, _Stoichiometry.get(mol.getID()));
        }
        _Metabolites.clear();
        _Stoichiometry.clear();
    }

    private IAtomContainer setProperty(IAtomContainer mol) throws Exception {
        String molID = mol.getID();
        AtomContainer molecule = new AtomContainer(mol);
        ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
        ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(molecule);
        ExtAtomContainerManipulator.aromatizeMolecule(molecule);
        molecule.setID(molID);
        try {
            try {
                if (molecule.getAtomCount() > 0) {
                    FingerprintGenerator fpr = new FingerprintGenerator();
                    BitSet fingerprint_Present_Mol = fpr.getFingerprint(molecule);
                    if (fingerprint_Present_Mol.isEmpty()) {
                        Fingerprinter fingerprinter = new Fingerprinter();
                        fingerprint_Present_Mol = fingerprinter.getBitFingerprint(molecule).asBitSet();
                    }
                    if (!fingerprint_Present_Mol.isEmpty()) {
                        if (!FPC.isValuePresent(fingerprint_Present_Mol)) {
                            if (molID == null) {
                                this.moleculeCounter = this.moleculeCounter + 1;
                                int val = this.moleculeCounter + 100000;
                                String Temp = Integer.toString(val);
                                molID = Temp.replaceFirst("1", "M");
                                molecule.setID(molID);
                            }
                            FPC.setValue(molID, fingerprint_Present_Mol);
                            this.atomContainer.add(molID, molecule);
                        } else if (FPC.isValuePresent(fingerprint_Present_Mol) && this.atomContainer.compareAtomContainer(FPC.getMoleculeID(fingerprint_Present_Mol), molecule)) {
                            if (molID == null) {
                                molID = FPC.getMoleculeID(fingerprint_Present_Mol);
                                molecule.setID(molID);
                            }
                        } else {
                            if (molID == null) {
                                this.moleculeCounter = this.moleculeCounter + 1;
                                int val = this.moleculeCounter + 100000;
                                String Temp = Integer.toString(val);
                                molID = Temp.replaceFirst("1", "M");
                                molecule.setID(molID);
                            }
                            FPC.setValue(molID, fingerprint_Present_Mol);
                            this.atomContainer.add(molID, molecule);
                        }
                    } else {
                        System.err.println("error: Fingerprint can't be generated for this molecule " + SmilesGenerator.generic().create(molecule));
                    }
                } else {
                    System.err.println("error: Mol file should contain atleast one atom! " + SmilesGenerator.generic().create(molecule));
                }
            }
            catch (CDKException ex) {
                ex.printStackTrace();
                ex.getCause();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ex.getCause();
            }
            if (molecule.getID() == null) {
                try {
                    throw new CDKException("Mol ID is NULL");
                }
                catch (CDKException ex) {
                    Logger.getLogger(RXNFileManipulator.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(RXNFileManipulator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return molecule;
    }
}

