/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import uk.ac.ebi.reactionblast.tools.rxnfile.Substructure;
import uk.ac.ebi.reactionblast.tools.rxnfile.SuperAtomContainer;

public abstract class MDLWriterBase
extends DefaultChemObjectWriter {
    private static final String M = "M  ";
    protected SuperAtomContainer superAtomContainer;

    protected static String formatMDLInt(int i, int l) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setParseIntegerOnly(true);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(l);
        nf.setGroupingUsed(false);
        s = nf.format(i);
        l -= s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLFloat(float fl) {
        String s = "";
        String fs = "";
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nf.setMinimumIntegerDigits(1);
        nf.setMaximumIntegerDigits(4);
        nf.setMinimumFractionDigits(4);
        nf.setMaximumFractionDigits(4);
        nf.setGroupingUsed(false);
        s = nf.format(fl);
        int l = 10 - s.length();
        for (int f = 0; f < l; ++f) {
            fs = fs + " ";
        }
        fs = fs + s;
        return fs;
    }

    protected static String formatMDLString(String s, int le) {
        if ((s = s.trim()).length() > le) {
            return s.substring(0, le);
        }
        int l = le - s.length();
        for (int f = 0; f < l; ++f) {
            s = s + " ";
        }
        return s;
    }

    public String padRight(String string, int length) {
        String result = string;
        int spaceCount = length - string.length();
        for (int i = 0; i < spaceCount; ++i) {
            result = result + ' ';
        }
        return result;
    }

    public String padLeft(String string, int length) {
        String result = string;
        int spaceCount = length - string.length();
        for (int i = 0; i < spaceCount; ++i) {
            result = ' ' + result;
        }
        return result;
    }

    protected void writeAtomValue(BufferedWriter writer, IAtomContainer container) throws IOException {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            if (atom.getProperty("cdk:Comment") == null || !(atom.getProperty("cdk:Comment") instanceof String) || ((String)atom.getProperty("cdk:Comment")).trim().isEmpty()) continue;
            writer.write("V  ");
            writer.write(MDLWriterBase.formatMDLInt(i + 1, 3));
            writer.write(" ");
            writer.write((String)atom.getProperty("cdk:Comment"));
            writer.newLine();
        }
    }

    protected void writeFormalAtomicCharges(BufferedWriter writer, IAtomContainer container) throws IOException {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            Integer charge = atom.getFormalCharge();
            if (charge == null || charge == 0) continue;
            writer.write("M  CHG  1 ");
            writer.write(MDLWriterBase.formatMDLInt(i + 1, 3));
            writer.write(" ");
            writer.write(MDLWriterBase.formatMDLInt(charge, 3));
            writer.newLine();
        }
    }

    protected void writeFormalIsotope(BufferedWriter writer, IAtomContainer container) throws IOException {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            Integer atomicMass;
            IAtom atom = container.getAtom(i);
            if (atom instanceof IPseudoAtom || (atomicMass = atom.getMassNumber()) == null) continue;
            int majorMass = Isotopes.getInstance().getMajorIsotope(atom.getSymbol()).getMassNumber();
            if (atomicMass == majorMass) continue;
            writer.write("M  ISO  1 ");
            writer.write(MDLWriterBase.formatMDLInt(i + 1, 3));
            writer.write(" ");
            writer.write(MDLWriterBase.formatMDLInt(atomicMass, 3));
            writer.newLine();
        }
    }

    protected void writeRGroups(BufferedWriter writer, List<Integer> rgroupList) throws IOException {
        if (rgroupList != null) {
            StringBuffer rgpLine = new StringBuffer();
            int cnt = 0;
            for (int i = 1; i <= rgroupList.size(); ++i) {
                rgpLine.append(MDLWriterBase.formatMDLInt(rgroupList.get(i - 1), 4));
                rgpLine.append(MDLWriterBase.formatMDLInt(rgroupList.get(++i - 1), 4));
                ++cnt;
                if (i != rgroupList.size() && i != 16) continue;
                rgpLine.insert(0, "M  RGP" + MDLWriterBase.formatMDLInt(cnt, 3));
                writer.write(rgpLine.toString());
                writer.newLine();
                rgpLine = new StringBuffer();
                cnt = 0;
            }
        }
    }

    private void writeSgroupCount(IAtomContainer molecule, BufferedWriter writer) throws IOException {
        int i;
        int substructureCount = this.superAtomContainer.countSuperatoms();
        writer.write("M  STY" + this.padLeft(String.valueOf(substructureCount), 3));
        for (i = 0; i < substructureCount; ++i) {
            writer.write(this.padLeft(String.valueOf(i + 1), 4));
            writer.write(this.padLeft("SUP", 4));
        }
        writer.newLine();
        writer.write("M  SLB" + this.padLeft(String.valueOf(substructureCount), 3));
        for (i = 0; i < substructureCount; ++i) {
            writer.write(this.padLeft(String.valueOf(i + 1), 4));
            writer.write(this.padLeft(String.valueOf(i + 1), 4));
        }
        writer.newLine();
    }

    protected void writeSgroupProperty(IAtomContainer molecule, BufferedWriter writer) throws IOException {
        if (this.superAtomContainer.countSuperatoms() > 0) {
            this.writeSgroupCount(molecule, writer);
            for (int i = 0; i < this.superAtomContainer.countSuperatoms(); ++i) {
                this.writeSingleSgroup(this.superAtomContainer.getSubstructures(i), writer);
            }
        }
    }

    private void writeSingleSgroup(Substructure substructure, BufferedWriter writer) throws IOException {
        int i;
        writer.write("M  SAL" + this.padLeft(String.valueOf(substructure.getIndex() + 1), 4) + this.padLeft(String.valueOf(substructure.getSuperAtomCount()), 3));
        for (i = 0; i < substructure.getSuperAtomCount(); ++i) {
            writer.write(this.padLeft(String.valueOf(substructure.getSuperAtom(i).getIndex() + 1), 4));
        }
        writer.newLine();
        writer.write("M  SBL" + this.padLeft(String.valueOf(substructure.getIndex() + 1), 4) + this.padLeft(String.valueOf(substructure.getSuperBondCount()), 3));
        for (i = 0; i < substructure.getSuperBondCount(); ++i) {
            writer.write(this.padLeft(String.valueOf(substructure.getSuperBond(i).getBondIndex() + 1), 4));
        }
        writer.newLine();
        for (i = 0; i < substructure.getSuperAtomCount(); ++i) {
            writer.write("M  SMT" + this.padLeft(String.valueOf(substructure.getIndex() + 1), 4) + " " + substructure.getSuperAtom(i).getPseudoAtom().getLabel());
        }
        writer.newLine();
    }
}

