/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.labelling;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.graph.invariant.InChINumbersTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.tools.labelling.AtomContainerAtomPermutor;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class InChiMoleculeLabeller
implements ICanonicalMoleculeLabeller {
    private static final Logger LOG = Logger.getLogger(InChiMoleculeLabeller.class.getName());

    @Override
    public IAtomContainer getCanonicalMolecule(IAtomContainer container) {
        int[] canonicalPermutation = this.getCanonicalPermutation(container);
        IAtomContainer permute = AtomContainerAtomPermutor.permute(canonicalPermutation, container);
        if (container.getID() != null) {
            permute.setID(container.getID());
        }
        for (int i : canonicalPermutation) {
            if (container.getAtom(i).getID() == null) continue;
            permute.getAtom(i).setID(container.getAtom(i).getID());
        }
        return permute;
    }

    @Override
    public int[] getCanonicalPermutation(IAtomContainer container) {
        long[] labels;
        try {
            labels = InChINumbersTools.getUSmilesNumbers(container);
        }
        catch (CDKException ex) {
            labels = Canon.label(container, GraphUtil.toAdjList(container));
            Logger.getLogger(InChiMoleculeLabeller.class.getName()).log(Level.SEVERE, null, ex);
        }
        int[] permute = new int[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            permute[i] = (int)labels[i] - 1;
        }
        return permute;
    }

    public void getCanonicalPermutation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

