/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.labelling;

import java.util.Iterator;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import uk.ac.ebi.reactionblast.tools.labelling.Permutor;

public class AtomContainerAtomPermutor
extends Permutor
implements Iterator<IAtomContainer> {
    private static boolean useA = false;
    private static boolean clone = false;
    private static final Logger LOG = Logger.getLogger(AtomContainerAtomPermutor.class.getName());
    private IAtomContainer original;

    public static IAtomContainer permute(int[] p, IAtomContainer atomContainer) {
        return AtomContainerAtomPermutor.permuteB(p, atomContainer);
    }

    private static IAtomContainer permuteA(int[] p, IAtomContainer atomContainer) {
        IAtomContainer permutedContainer = null;
        try {
            permutedContainer = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            for (int i = 0; i < p.length; ++i) {
                IAtom atom = atomContainer.getAtom(p[i]);
                permutedContainer.addAtom(atom.clone());
            }
            for (IBond bond : atomContainer.bonds()) {
                IBond clonedBond = bond.clone();
                clonedBond.setAtoms(new IAtom[clonedBond.getAtomCount()]);
                int i = 0;
                for (IAtom atom : bond.atoms()) {
                    int index = atomContainer.getAtomNumber(atom);
                    IAtom permutedAtom = permutedContainer.getAtom(p[index]);
                    clonedBond.setAtom(permutedAtom, i++);
                }
                permutedContainer.addBond(clonedBond);
            }
        }
        catch (CloneNotSupportedException cne) {
            System.out.println(cne);
        }
        return permutedContainer;
    }

    private static IAtomContainer permuteB(int[] p, IAtomContainer atomContainer) {
        IAtomContainer permutedContainer = null;
        try {
            permutedContainer = atomContainer.clone();
            int n = atomContainer.getAtomCount();
            IAtom[] permutedAtoms = new IAtom[n];
            for (int originalIndex = 0; originalIndex < n; ++originalIndex) {
                IAtom atom = permutedContainer.getAtom(originalIndex);
                int newIndex = p[originalIndex];
                permutedAtoms[newIndex] = atom;
            }
            permutedContainer.setAtoms(permutedAtoms);
        }
        catch (CloneNotSupportedException cne) {
            System.out.println(cne);
        }
        return permutedContainer;
    }

    private static void permuteWithoutClone(int[] p, IAtomContainer atomContainer) {
        int n = atomContainer.getAtomCount();
        IAtom[] permutedAtoms = new IAtom[n];
        for (int originalIndex = 0; originalIndex < n; ++originalIndex) {
            IAtom atom = atomContainer.getAtom(originalIndex);
            int newIndex = p[originalIndex];
            permutedAtoms[newIndex] = atom;
        }
        atomContainer.setAtoms(permutedAtoms);
    }

    public AtomContainerAtomPermutor(IAtomContainer atomContainer) {
        super(atomContainer.getAtomCount());
        this.original = atomContainer;
    }

    public AtomContainerAtomPermutor(IAtomContainer atomContainer, boolean useA, boolean clone) {
        this(atomContainer);
    }

    @Override
    public IAtomContainer next() {
        int[] p = super.getNextPermutation();
        return AtomContainerAtomPermutor.permute(p, this.original);
    }

    @Override
    public void remove() {
    }
}

