/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.labelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class AbstractReactionLabeller {
    private static final Logger LOG = Logger.getLogger(AbstractReactionLabeller.class.getName());
    private final boolean fixAtomMappingCastType = false;

    private void fixAtomMapping(IAtomContainer canonicalForm) {
        for (IAtom a : canonicalForm.atoms()) {
            String v = (String)a.getProperty("cdk:AtomAtomMapping");
            if (v == null) continue;
            a.setProperty("cdk:AtomAtomMapping", Integer.valueOf(v));
        }
    }

    protected void atomAtomMap(IAtomContainerSet original, IAtomContainerSet clone, Map<IAtomContainer, int[]> permutationMap, Map<IAtom, IAtom> atomAtom) {
        for (int i = 0; i < original.getAtomContainerCount(); ++i) {
            IAtomContainer mol = original.getAtomContainer(i);
            IAtomContainer mol2 = clone.getAtomContainer(i);
            int[] permutation = permutationMap.get(mol2);
            for (int j = 0; j < mol.getAtomCount(); ++j) {
                atomAtom.put(mol.getAtom(j), mol2.getAtom(permutation[j]));
            }
        }
    }

    protected Map<IAtom, IAtom> atomAtomMap(IReaction reaction, IReaction clone, Map<IAtomContainer, int[]> permutationMap) {
        Hashtable<IAtom, IAtom> atomAtom = new Hashtable<IAtom, IAtom>();
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet clonedReactants = clone.getReactants();
        this.atomAtomMap(reactants, clonedReactants, permutationMap, atomAtom);
        IAtomContainerSet products = reaction.getProducts();
        IAtomContainerSet clonedProducts = clone.getProducts();
        this.atomAtomMap(products, clonedProducts, permutationMap, atomAtom);
        return atomAtom;
    }

    protected List<IMapping> cloneMappings(IReaction reaction, Map<IAtom, IAtom> atomAtomMap) {
        int numberOfMappings = reaction.getMappingCount();
        ArrayList<IMapping> map = new ArrayList<IMapping>();
        for (int mappingIndex = 0; mappingIndex < numberOfMappings; ++mappingIndex) {
            IMapping mapping = reaction.getMapping(mappingIndex);
            map.add(this.cloneMapping(mapping, atomAtomMap));
        }
        return map;
    }

    protected IMapping cloneMapping(IMapping mapping, Map<IAtom, IAtom> atomAtomMap) {
        IChemObject keyChemObj0 = mapping.getChemObject(0);
        IChemObject keyChemObj1 = mapping.getChemObject(1);
        IChemObject co0 = atomAtomMap.get(keyChemObj0);
        IChemObject co1 = atomAtomMap.get(keyChemObj1);
        if (co0 == null) {
            co0 = new ChemObject();
        }
        if (co1 == null) {
            co1 = new ChemObject();
        }
        return new Mapping(co0, co1);
    }

    protected Map<IChemObject, Integer> makeIndexMap(IReaction reaction) {
        HashMap<IChemObject, Integer> indexMap = new HashMap<IChemObject, Integer>();
        List<IAtomContainer> all = ReactionManipulator.getAllAtomContainers(reaction);
        int globalIndex = 0;
        for (IAtomContainer ac : all) {
            for (IAtom atom : ac.atoms()) {
                indexMap.put(atom, globalIndex);
                ++globalIndex;
            }
        }
        return indexMap;
    }

    protected void cloneAndSortMappings(IReaction reaction, IReaction copyOfReaction, Map<IAtomContainer, int[]> permutationMap) {
        Map<IAtom, IAtom> atomAtomMap = this.atomAtomMap(reaction, copyOfReaction, permutationMap);
        List<IMapping> map = this.cloneMappings(reaction, atomAtomMap);
        this.sortMappings(copyOfReaction, map);
    }

    protected void sortMappings(IReaction reaction, List<IMapping> map) {
        final Map<IChemObject, Integer> indexMap = this.makeIndexMap(reaction);
        Comparator<IMapping> mappingSorter = new Comparator<IMapping>(){

            @Override
            public int compare(IMapping o1, IMapping o2) {
                IChemObject o10 = o1.getChemObject(0);
                IChemObject o20 = o2.getChemObject(0);
                if (o20 == null || o10 == null) {
                    return 0;
                }
                Integer o10i = (Integer)indexMap.get(o10);
                Integer o20i = (Integer)indexMap.get(o20);
                if (o10i == null || o20i == null) {
                    return 0;
                }
                return o10i.compareTo(o20i);
            }
        };
        Collections.sort(map, mappingSorter);
        int mappingIndex = 0;
        for (IMapping mapping : map) {
            IChemObject o1;
            IChemObject o0 = mapping.getChemObject(0);
            if (o0 != null) {
                o0.setProperty("cdk:AtomAtomMapping", mappingIndex);
            }
            if ((o1 = mapping.getChemObject(1)) != null) {
                o1.setProperty("cdk:AtomAtomMapping", mappingIndex);
            }
            reaction.addMapping(mapping);
            ++mappingIndex;
        }
    }

    protected IAtomContainerSet canoniseAtomContainerSet(IAtomContainerSet moleculeSet, ICanonicalMoleculeLabeller labeller, Map<IAtomContainer, int[]> permutationMap) {
        AtomContainerSet canonicalMolecules = new AtomContainerSet();
        for (IAtomContainer atomContainer : moleculeSet.atomContainers()) {
            IAtomContainer canonicalForm = labeller.getCanonicalMolecule(atomContainer);
            canonicalForm.setID(atomContainer.getID());
            permutationMap.put(canonicalForm, labeller.getCanonicalPermutation(atomContainer));
            canonicalMolecules.addAtomContainer(canonicalForm);
        }
        return canonicalMolecules;
    }

    public IReaction labelReaction(IReaction reaction, ICanonicalMoleculeLabeller labeller) {
        System.out.println("labelling " + reaction.getID());
        Reaction canonReaction = new Reaction();
        HashMap<IAtomContainer, int[]> permutationMap = new HashMap<IAtomContainer, int[]>();
        canonReaction.setProducts(this.canoniseAtomContainerSet(reaction.getProducts(), labeller, permutationMap));
        canonReaction.setReactants(this.canoniseAtomContainerSet(reaction.getReactants(), labeller, permutationMap));
        this.cloneAndSortMappings(reaction, canonReaction, permutationMap);
        canonReaction.setID(reaction.getID());
        return canonReaction;
    }
}

