/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public class ReactionImplicitHydrogenTransformation
implements ITransformation<IReaction> {
    private static final Logger LOG = Logger.getLogger(ReactionImplicitHydrogenTransformation.class.getName());

    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance());
        for (IAtomContainer atomContainer : ReactionManipulator.getAllAtomContainers(reaction)) {
            try {
                ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                adder.addImplicitHydrogens(atomContainer);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
        return reaction;
    }
}

