/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.smiles.CanonSmiAdapter;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public class CDKSMILES {
    private static final Logger LOG = Logger.getLogger(CDKSMILES.class.getName());
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CDKSMILES.class);
    private final IAtomContainer molecule;

    public CDKSMILES(IAtomContainer mol, boolean removeH, boolean remove_AAM) throws CloneNotSupportedException {
        this.molecule = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ExtAtomContainerManipulator.cloneWithIDs(mol));
        if (remove_AAM) {
            for (IAtom a : this.molecule.atoms()) {
                a.removeProperty("cdk:AtomAtomMapping");
            }
        }
    }

    public String getCanonicalSMILES() {
        String smiles = "NA";
        if (this.molecule.getAtomCount() == 0) {
            return smiles;
        }
        try {
            ExtAtomContainerManipulator.aromatizeDayLight(this.molecule);
            return CanonSmiAdapter.create(this.molecule);
        }
        catch (CDKException ex) {
            this.logger.error("ERROR : in generating CDK SMILES" + this.molecule.getID());
        }
        catch (IOException ex) {
            Logger.getLogger(CDKSMILES.class.getName()).log(Level.SEVERE, null, ex);
        }
        return smiles;
    }

    public String getGenericSMILES() {
        String smiles = "NA";
        if (this.molecule.getAtomCount() == 0) {
            return smiles;
        }
        try {
            SmilesGenerator g = SmilesGenerator.generic();
            return g.create(this.molecule);
        }
        catch (CDKException ex) {
            this.logger.error("ERROR : in generating CDK SMILES" + this.molecule.getID());
            return smiles;
        }
    }

    public String getGenericAromaticSMILES() {
        String smiles = "NA";
        if (this.molecule.getAtomCount() == 0) {
            return smiles;
        }
        try {
            SmilesGenerator g = SmilesGenerator.generic().aromatic();
            return g.create(this.molecule);
        }
        catch (CDKException ex) {
            this.logger.error("ERROR : in generating CDK SMILES" + this.molecule.getID());
            return smiles;
        }
    }

    private boolean isPseudoAtoms() {
        for (IAtom atoms : this.molecule.atoms()) {
            if (!(atoms instanceof IPseudoAtom) && !(atoms instanceof PseudoAtom)) continue;
            return true;
        }
        return false;
    }
}

