/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.io.IOException;
import java.util.Comparator;
import java.util.logging.Logger;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class AtomContainerSetComparator
implements Comparator<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(AtomContainerSetComparator.class.getName());
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomContainerSetComparator.class);

    @Override
    public int compare(IAtomContainer o1, IAtomContainer o2) {
        double bondOrderSum2;
        double mw2;
        double mw1;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (!(o1 instanceof IAtomContainer) && !(o2 instanceof IAtomContainer)) {
            return 0;
        }
        if (!(o1 instanceof IAtomContainer)) {
            return -1;
        }
        if (!(o2 instanceof IAtomContainer)) {
            return 1;
        }
        if (!(o1 instanceof IAtomContainer) && !(o2 instanceof IAtomContainer)) {
            return 0;
        }
        if (!(o1 instanceof IAtomContainer)) {
            return -1;
        }
        if (!(o2 instanceof IAtomContainer)) {
            return 1;
        }
        IAtomContainer atomContainer1 = o1;
        IAtomContainer atomContainer2 = o2;
        if (atomContainer1.getAtomCount() > atomContainer2.getAtomCount()) {
            return -1;
        }
        if (atomContainer1.getAtomCount() < atomContainer2.getAtomCount()) {
            return 1;
        }
        try {
            mw1 = this.getMolecularWeight(atomContainer1);
            mw2 = this.getMolecularWeight(atomContainer2);
        }
        catch (CDKException e) {
            this.logger.warn("Exception in molecular mass calculation.");
            return 0;
        }
        if (mw1 > mw2) {
            return -1;
        }
        if (mw1 < mw2) {
            return 1;
        }
        if (atomContainer1.getBondCount() > atomContainer2.getBondCount()) {
            return -1;
        }
        if (atomContainer1.getBondCount() < atomContainer2.getBondCount()) {
            return 1;
        }
        double bondOrderSum1 = AtomContainerManipulator.getSingleBondEquivalentSum(atomContainer1);
        if (bondOrderSum1 > (bondOrderSum2 = (double)AtomContainerManipulator.getSingleBondEquivalentSum(atomContainer2))) {
            return -1;
        }
        if (bondOrderSum1 < bondOrderSum2) {
            return 1;
        }
        return 0;
    }

    private double getMolecularWeight(IAtomContainer atomContainer) throws CDKException {
        double mw = 0.0;
        try {
            for (IAtom atom : atomContainer.atoms()) {
                if (!atom.getSymbol().equals("H") && !atom.getSymbol().equals("R")) {
                    try {
                        try {
                            IIsotope majorIsotope = Isotopes.getInstance().getMajorIsotope(atom.getSymbol());
                            mw += majorIsotope.getExactMass().doubleValue();
                        }
                        catch (NullPointerException e) {
                            mw += Isotopes.getInstance().getMajorIsotope("Ra").getExactMass().doubleValue();
                            this.logger.warn("Isotopes not defined in the CDK " + atom.getSymbol());
                        }
                    }
                    catch (IOException e) {
                        this.logger.warn("Molecular weight calculation failed for atom " + atom.getSymbol());
                    }
                    continue;
                }
                if (!atom.getSymbol().equals("R")) continue;
                mw += Isotopes.getInstance().getMajorIsotope("C").getExactMass().doubleValue();
            }
        }
        catch (IOException e) {
            this.logger.warn("Molecular weight calculation failed for atleast one atom ");
        }
        return mw;
    }
}

