/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.wedge;

import java.util.ArrayList;
import java.util.SortedMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.TetrahedralChirality;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeRule;

public abstract class AbstractTetrahedralWedgeRule
extends WedgeRule {
    @Override
    public IStereoElement execute(IAtom centralAtom, IAtomContainer atomContainer, SortedMap<Double, IBond> angleMap) {
        int[] permutation = this.getMatchPermutation();
        ArrayList<IBond> bonds = new ArrayList<IBond>(angleMap.values());
        IAtom[] ligandAtoms = new IAtom[4];
        for (int index = 0; index < 4; ++index) {
            IBond bond = (IBond)bonds.get(permutation[index]);
            ligandAtoms[index] = bond.getConnectedAtom(centralAtom);
        }
        return new TetrahedralChirality(centralAtom, ligandAtoms, this.getStereo());
    }

    public abstract ITetrahedralChirality.Stereo getStereo();
}

