/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.ebi;

import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.centres.cdk.CDKPerceptor;
import uk.ac.ebi.centres.descriptor.Planar;
import uk.ac.ebi.centres.descriptor.Tetrahedral;
import uk.ac.ebi.centres.descriptor.Trigonal;
import uk.ac.ebi.reactionblast.mechanism.helper.Utility;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public abstract class StereoCenteralityTool
extends Utility {
    private static final long serialVersionUID = 17867606807697859L;

    private static IAtom getAtomByID(String id, IAtomContainer ac) {
        for (IAtom a : ac.atoms()) {
            if (!a.getID().equals(id)) continue;
            return a;
        }
        return null;
    }

    public static Map<IAtom, IStereoAndConformation> getChirality2D(IReaction reaction) throws CDKException, CloneNotSupportedException {
        IAtom atomByID;
        Map<IAtom, IStereoAndConformation> chirality2D;
        IAtomContainer containerWithoutH;
        HashMap<IAtom, IStereoAndConformation> chiralityMap = new HashMap<IAtom, IStereoAndConformation>();
        CDKPerceptor perceptor = new CDKPerceptor();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            containerWithoutH = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ac);
            chirality2D = StereoCenteralityTool.getChirality2D(containerWithoutH, perceptor);
            if (chirality2D.isEmpty()) continue;
            for (Map.Entry<IAtom, IStereoAndConformation> m : chirality2D.entrySet()) {
                atomByID = StereoCenteralityTool.getAtomByID(m.getKey().getID(), ac);
                if (atomByID == null) continue;
                atomByID.setProperty("Stereo", m.getValue());
                chiralityMap.put(atomByID, m.getValue());
            }
        }
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            containerWithoutH = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(ac);
            chirality2D = StereoCenteralityTool.getChirality2D(containerWithoutH, perceptor);
            if (chirality2D.isEmpty()) continue;
            for (Map.Entry<IAtom, IStereoAndConformation> m : chirality2D.entrySet()) {
                atomByID = StereoCenteralityTool.getAtomByID(m.getKey().getID(), ac);
                if (atomByID == null) continue;
                atomByID.setProperty("Stereo", m.getValue());
                chiralityMap.put(atomByID, m.getValue());
            }
        }
        return chiralityMap;
    }

    public static Map<IAtom, IStereoAndConformation> getChirality2D(IAtomContainer ac, CDKPerceptor perceptor) {
        HashMap<IAtom, IStereoAndConformation> chiralityMap = new HashMap<IAtom, IStereoAndConformation>();
        perceptor.perceive(ac);
        for (IAtom atom : ac.atoms()) {
            if (Tetrahedral.R.equals(atom.getProperty("descriptor"))) {
                chiralityMap.put(atom, IStereoAndConformation.R);
                continue;
            }
            if (Tetrahedral.S.equals(atom.getProperty("descriptor"))) {
                chiralityMap.put(atom, IStereoAndConformation.S);
                continue;
            }
            if (Planar.E.equals(atom.getProperty("descriptor"))) {
                chiralityMap.put(atom, IStereoAndConformation.E);
                continue;
            }
            if (Planar.Z.equals(atom.getProperty("descriptor"))) {
                chiralityMap.put(atom, IStereoAndConformation.Z);
                continue;
            }
            if (Trigonal.Re.equals(atom.getProperty("descriptor"))) {
                chiralityMap.put(atom, IStereoAndConformation.P);
                continue;
            }
            if (Trigonal.Si.equals(atom.getProperty("descriptor"))) {
                chiralityMap.put(atom, IStereoAndConformation.M);
                continue;
            }
            chiralityMap.put(atom, IStereoAndConformation.NONE);
        }
        for (IBond bond : ac.bonds()) {
            if (Planar.E.equals(bond.getProperty("descriptor"))) {
                chiralityMap.put(bond.getAtom(0), IStereoAndConformation.E);
                chiralityMap.put(bond.getAtom(1), IStereoAndConformation.E);
                continue;
            }
            if (Planar.Z.equals(bond.getProperty("descriptor"))) {
                chiralityMap.put(bond.getAtom(0), IStereoAndConformation.Z);
                chiralityMap.put(bond.getAtom(1), IStereoAndConformation.Z);
                continue;
            }
            if (Trigonal.Re.equals(bond.getProperty("descriptor"))) {
                chiralityMap.put(bond.getAtom(0), IStereoAndConformation.P);
                chiralityMap.put(bond.getAtom(1), IStereoAndConformation.P);
                continue;
            }
            if (!Trigonal.Si.equals(bond.getProperty("descriptor"))) continue;
            chiralityMap.put(bond.getAtom(0), IStereoAndConformation.M);
            chiralityMap.put(bond.getAtom(1), IStereoAndConformation.M);
        }
        for (IAtom atom : chiralityMap.keySet()) {
            atom.setProperty("Stereo", chiralityMap.get(atom));
        }
        return chiralityMap;
    }
}

