/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import uk.ac.ebi.reactionblast.stereo.compare.WedgeStereoComparisonResult;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoAnalyser;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoAnalysisResult;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoLifter;

public class WedgeStereoComparisonTool {
    private static final Logger LOG = Logger.getLogger(WedgeStereoComparisonTool.class.getName());

    public static List<WedgeStereoComparisonResult> compare(IReaction reaction) {
        ArrayList<WedgeStereoComparisonResult> results = new ArrayList<WedgeStereoComparisonResult>();
        WedgeStereoLifter lifter = new WedgeStereoLifter();
        IAtomContainerSet reactants = reaction.getReactants();
        IAtomContainerSet products = reaction.getProducts();
        for (IMapping mapping : reaction.mappings()) {
            IAtom atomA = (IAtom)mapping.getChemObject(0);
            IAtom atomB = (IAtom)mapping.getChemObject(1);
            IAtomContainer atomContainerA = MoleculeSetManipulator.getRelevantAtomContainer(reactants, atomA);
            IAtomContainer atomContainerB = MoleculeSetManipulator.getRelevantAtomContainer(products, atomB);
            results.add(WedgeStereoComparisonTool.compare(atomA, atomContainerA, atomB, atomContainerB, lifter));
        }
        return results;
    }

    public static List<WedgeStereoComparisonResult> compare(IAtomContainer atomContainerA, IAtomContainer atomContainerB, Map<Integer, Integer> equivMap) {
        ArrayList<WedgeStereoComparisonResult> results = new ArrayList<WedgeStereoComparisonResult>();
        WedgeStereoLifter lifter = new WedgeStereoLifter();
        for (int indexA = 0; indexA < atomContainerA.getAtomCount(); ++indexA) {
            int indexB = equivMap.get(indexA);
            IAtom atomA = atomContainerA.getAtom(indexA);
            IAtom atomB = atomContainerB.getAtom(indexB);
            results.add(WedgeStereoComparisonTool.compare(atomA, atomContainerA, atomB, atomContainerB, lifter));
        }
        return results;
    }

    public static WedgeStereoComparisonResult compare(IAtom atomA, IAtomContainer atomContainerA, IAtom atomB, IAtomContainer atomContainerB, WedgeStereoLifter lifter) {
        WedgeStereoAnalysisResult resultForA = WedgeStereoAnalyser.getResult(atomA, atomContainerA, lifter);
        WedgeStereoAnalysisResult resultForB = WedgeStereoAnalyser.getResult(atomB, atomContainerB, lifter);
        return new WedgeStereoComparisonResult(atomA, atomContainerA, resultForA, atomB, atomContainerB, resultForB);
    }

    private WedgeStereoComparisonTool() {
    }
}

