/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.signature;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import signature.AbstractGraphSignature;
import signature.AbstractVertexSignature;
import uk.ac.ebi.reactionblast.signature.RBlastAtomSignature;

public class BaseMoleculeSignature
extends AbstractGraphSignature {
    private static final Logger LOG = Logger.getLogger(BaseMoleculeSignature.class.getName());
    protected IAtomContainer atomContainer;

    public BaseMoleculeSignature(IAtomContainer atomContainer) {
        this.atomContainer = atomContainer;
    }

    @Override
    public AbstractVertexSignature signatureForVertex(int atomIndex) {
        return new RBlastAtomSignature(atomIndex, this.atomContainer);
    }

    @Override
    public String signatureStringForVertex(int atomIndex) {
        return new RBlastAtomSignature(atomIndex, this.atomContainer).toCanonicalString();
    }

    @Override
    public String signatureStringForVertex(int atomIndex, int height) {
        return new RBlastAtomSignature(atomIndex, this.atomContainer, height).toCanonicalString();
    }

    @Override
    protected int getVertexCount() {
        return this.atomContainer.getAtomCount();
    }
}

