/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.smsd.helper.MoleculeInitializer;
import uk.ac.ebi.reactionblast.mechanism.BEMatrix;
import uk.ac.ebi.reactionblast.mechanism.RMatrix;
import uk.ac.ebi.reactionblast.mechanism.StereoChange;
import uk.ac.ebi.reactionblast.mechanism.StereogenicCenterCalculator;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomAtomMappingContainer;
import uk.ac.ebi.reactionblast.mechanism.helper.AtomStereoChangeInformation;
import uk.ac.ebi.reactionblast.mechanism.helper.BondChange;
import uk.ac.ebi.reactionblast.mechanism.interfaces.IChangeCalculator;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;
import uk.ac.ebi.reactionblast.stereo.ebi.StereoCenteralityTool;

abstract class DUModel
extends StereoCenteralityTool
implements IChangeCalculator,
Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 179876660968690L;
    final IAtomContainerSet reactantSet;
    final IAtomContainerSet productSet;
    final Map<IAtom, IAtom> mappingMap;
    final List<BondChange> bondChangeList;
    final Set<IAtom> reactionCenterList;
    final List<AtomStereoChangeInformation> stereoChangeList;
    final List<AtomStereoChangeInformation> conformationChangeList;
    final List<StereoChange> stereogenicCenters;
    protected final boolean generate3DCoordinates;
    protected final boolean generate2DCoordinates;
    protected final AtomAtomMappingContainer mapping;
    protected final BEMatrix reactantBE;
    protected final BEMatrix productBE;
    protected final RMatrix reactionMatrix;
    protected final IRingSet queryRingSet;
    protected final IRingSet targetRingSet;

    /*
     * WARNING - void declaration
     */
    DUModel(IReaction reaction, boolean withoutHydrogen, boolean generate2D, boolean generate3D) throws CDKException, Exception {
        void var7_11;
        this.reactantSet = reaction.getReactants();
        this.productSet = reaction.getProducts();
        this.bondChangeList = Collections.synchronizedList(new ArrayList());
        this.reactionCenterList = Collections.synchronizedSet(new LinkedHashSet());
        this.stereoChangeList = Collections.synchronizedList(new ArrayList());
        this.conformationChangeList = Collections.synchronizedList(new ArrayList());
        this.mappingMap = Collections.synchronizedMap(new HashMap());
        this.generate3DCoordinates = generate3D;
        this.generate2DCoordinates = generate2D;
        this.queryRingSet = new RingSet();
        this.targetRingSet = new RingSet();
        this.setMappingMap(reaction.mappings());
        ArrayList<IBond> rBonds = new ArrayList<IBond>();
        for (IAtomContainer iAtomContainer : reaction.getReactants().atomContainers()) {
            MoleculeInitializer.initializeMolecule(iAtomContainer);
            for (IBond bond : iAtomContainer.bonds()) {
                rBonds.add(bond);
            }
        }
        ArrayList<IBond> pBonds = new ArrayList<IBond>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            MoleculeInitializer.initializeMolecule(ac);
            for (IBond bond : ac.bonds()) {
                pBonds.add(bond);
            }
        }
        this.reactantBE = this.createBEMatrix(this.reactantSet, rBonds, withoutHydrogen, this.mappingMap);
        this.productBE = this.createBEMatrix(this.productSet, pBonds, withoutHydrogen, this.mappingMap);
        this.mapping = new AtomAtomMappingContainer(reaction, withoutHydrogen);
        this.reactionMatrix = this.createRMatrix(this.reactantBE, this.productBE, this.mapping);
        HashMap hashMap = new HashMap();
        try {
            Map<IAtom, IStereoAndConformation> map = DUModel.getChirality2D(reaction);
        }
        catch (CloneNotSupportedException | CDKException ex) {
            System.err.println("WARNING: 2D CDK based stereo perception failed");
        }
        this.stereogenicCenters = new StereogenicCenterCalculator().compare(reaction, (Map<IAtom, IStereoAndConformation>)var7_11);
    }

    private void setMappingMap(Iterable<IMapping> mappings) {
        for (IMapping mappingObject : mappings) {
            IAtom atomEduct = (IAtom)mappingObject.getChemObject(0);
            IAtom atomProduct = (IAtom)mappingObject.getChemObject(1);
            this.mappingMap.put(atomEduct, atomProduct);
        }
    }

    private synchronized BEMatrix createBEMatrix(IAtomContainerSet molset, List<IBond> bonds, boolean withoutH, Map<IAtom, IAtom> mappings) throws CDKException {
        BEMatrix res = new BEMatrix(withoutH, molset, bonds, mappings);
        res.setMatrixAtoms();
        return res;
    }

    private synchronized RMatrix createRMatrix(BEMatrix reactantBE, BEMatrix productBE, AtomAtomMappingContainer mapping) throws CDKException {
        return new RMatrix(reactantBE, productBE, mapping);
    }

    public String toString() {
        return "DUModel{reactantSet=" + this.reactantSet + ", productSet=" + this.productSet + ", mappingMap=" + this.mappingMap + ", bondChangeList=" + this.bondChangeList + ", reactionCenterList=" + this.reactionCenterList + ", stereoChangeList=" + this.stereoChangeList + ", conformationChangeList=" + this.conformationChangeList + '}';
    }
}

