/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.helper;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.tools.BasicDebugger;

public class MappingHandler
extends BasicDebugger {
    private static final Logger LOG = Logger.getLogger(MappingHandler.class.getName());

    public static void cleanMapping(IReaction MappedReaction) {
        String atomLabel;
        int count;
        for (int i = count = MappedReaction.getMappingCount(); i > 0; --i) {
            MappedReaction.removeMapping(i);
        }
        for (int eMol = 0; eMol < MappedReaction.getReactantCount(); ++eMol) {
            IAtomContainer eMolecule = MappedReaction.getReactants().getAtomContainer(eMol);
            for (int eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                IAtom atomEMap = MappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                atomLabel = Integer.toString(-1);
                atomEMap.setFlag(128, false);
                atomEMap.setID(atomLabel);
            }
        }
        for (int pMol = 0; pMol < MappedReaction.getProductCount(); ++pMol) {
            IAtomContainer pMolecule = MappedReaction.getProducts().getAtomContainer(pMol);
            for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                IAtom atomPMap = MappedReaction.getProducts().getAtomContainer(pMol).getAtom(pAtom);
                atomLabel = Integer.toString(-1);
                atomPMap.setFlag(128, false);
                atomPMap.setID(atomLabel);
            }
        }
    }

    protected static synchronized int setMappingFlags(IReaction expLabReaction, IReaction MappedReaction, int counter) {
        IAtomContainerSet expEductSet = expLabReaction.getReactants();
        IAtomContainerSet expProductSet = expLabReaction.getProducts();
        block0: for (IMapping map : expLabReaction.mappings()) {
            IAtom I_Atom = (IAtom)map.getChemObject(0);
            IAtom J_Atom = (IAtom)map.getChemObject(1);
            if (I_Atom == null || J_Atom == null) continue;
            boolean eFlag = false;
            IAtom firstAtom = null;
            IAtom secondAtom = null;
            for (int eMol = 0; eMol < expEductSet.getAtomContainerCount(); ++eMol) {
                IAtomContainer eMolecule = expEductSet.getAtomContainer(eMol);
                for (int eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                    if (!I_Atom.getID().trim().equalsIgnoreCase(eMolecule.getAtom(eAtom).getID().trim())) continue;
                    String atomLabel = Integer.toString(counter);
                    firstAtom = MappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                    firstAtom.setID(atomLabel);
                    firstAtom.setFlag(128, true);
                    eFlag = true;
                    break;
                }
                if (eFlag) break;
            }
            boolean pFlag = false;
            for (int pMol = 0; pMol < expProductSet.getAtomContainerCount(); ++pMol) {
                IAtomContainer pMolecule = expProductSet.getAtomContainer(pMol);
                for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                    if (!J_Atom.getID().trim().equalsIgnoreCase(pMolecule.getAtom(pAtom).getID().trim())) continue;
                    String atomLabel = Integer.toString(counter);
                    secondAtom = MappedReaction.getProducts().getAtomContainer(pMol).getAtom(pAtom);
                    secondAtom.setID(atomLabel);
                    secondAtom.setFlag(128, true);
                    IMapping mappingObject = MappedReaction.getBuilder().newInstance(IMapping.class, firstAtom, secondAtom);
                    MappedReaction.addMapping(mappingObject);
                    ++counter;
                    pFlag = true;
                    break;
                }
                if (pFlag) continue block0;
            }
        }
        return counter;
    }

    protected static int setMappingFlags(IReaction MappedReaction, IReaction ReactionWithUniqueSTOICHIOMETRY, IReaction coreMappedReaction, int counter) {
        IAtomContainerSet expEductSet = ReactionWithUniqueSTOICHIOMETRY.getReactants();
        IAtomContainerSet expProductSet = ReactionWithUniqueSTOICHIOMETRY.getProducts();
        block0: for (IMapping map : coreMappedReaction.mappings()) {
            IAtom I_Atom = (IAtom)map.getChemObject(0);
            IAtom J_Atom = (IAtom)map.getChemObject(1);
            if (I_Atom == null || J_Atom == null) continue;
            boolean eFlag = false;
            IAtom firstAtom = null;
            IAtom secondAtom = null;
            for (int eMol = 0; eMol < expEductSet.getAtomContainerCount(); ++eMol) {
                IAtomContainer eMolecule = expEductSet.getAtomContainer(eMol);
                for (int eAtom = 0; eAtom < eMolecule.getAtomCount(); ++eAtom) {
                    if (!I_Atom.getID().trim().equalsIgnoreCase(eMolecule.getAtom(eAtom).getID().trim())) continue;
                    String atomLabel = Integer.toString(counter);
                    firstAtom = MappedReaction.getReactants().getAtomContainer(eMol).getAtom(eAtom);
                    firstAtom.setID(atomLabel);
                    firstAtom.setFlag(128, true);
                    eFlag = true;
                    break;
                }
                if (eFlag) break;
            }
            boolean pFlag = false;
            for (int pMol = 0; pMol < expProductSet.getAtomContainerCount(); ++pMol) {
                IAtomContainer pMolecule = expProductSet.getAtomContainer(pMol);
                for (int pAtom = 0; pAtom < pMolecule.getAtomCount(); ++pAtom) {
                    if (!J_Atom.getID().trim().equalsIgnoreCase(pMolecule.getAtom(pAtom).getID().trim())) continue;
                    String atomLabel = Integer.toString(counter);
                    secondAtom = MappedReaction.getProducts().getAtomContainer(pMol).getAtom(pAtom);
                    secondAtom.setID(atomLabel);
                    secondAtom.setFlag(128, true);
                    ++counter;
                    pFlag = true;
                    break;
                }
                if (pFlag) continue block0;
            }
        }
        return counter;
    }
}

