/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.interfaces.Algorithm;
import uk.ac.ebi.reactionblast.mapping.graph.MCSSolution;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;
import uk.ac.ebi.reactionblast.tools.labelling.SmilesMoleculeLabeller;

public class MCSThread
implements Callable<MCSSolution> {
    private static final boolean DEBUG1 = false;
    private static final boolean DEBUG2 = false;
    private static final Logger LOG = Logger.getLogger(MCSThread.class.getName());
    private boolean stereoFlag = true;
    private boolean fragmentFlag = true;
    private boolean energyFlag = true;
    private SmilesGenerator smiles;
    private Aromaticity aromaticity;
    protected final IAtomContainer compound1;
    protected final IAtomContainer compound2;
    protected final int queryPosition;
    protected final int targetPosition;
    protected final boolean bondMatcher;
    protected final boolean ringMatcher;
    protected final IMappingAlgorithm theory;
    protected final boolean atomMatcher;
    private final ICanonicalMoleculeLabeller labeller;
    final long startTime = System.currentTimeMillis();
    private boolean hasRings;
    private Integer eductCount;
    private Integer productCount;

    MCSThread(IMappingAlgorithm theory, int queryPosition, int targetPosition, IAtomContainer educt, IAtomContainer product, boolean bondMatcher, boolean ringMatcher, boolean atomMatcher) throws CloneNotSupportedException, CDKException {
        this.compound1 = this.getNewContainerWithIDs(educt);
        this.compound2 = this.getNewContainerWithIDs(product);
        this.queryPosition = queryPosition;
        this.targetPosition = targetPosition;
        this.bondMatcher = bondMatcher;
        this.ringMatcher = ringMatcher;
        this.theory = theory;
        this.atomMatcher = atomMatcher;
        this.labeller = new SmilesMoleculeLabeller();
    }

    synchronized void printMatch(BaseMapping isomorphism) {
        int overlap = isomorphism.getFirstAtomMapping().isEmpty() ? 0 : isomorphism.getFirstAtomMapping().getCount();
        System.out.println("Q: " + isomorphism.getQuery().getID() + " T: " + isomorphism.getTarget().getID() + " atoms: " + isomorphism.getQuery().getAtomCount() + " atoms: " + isomorphism.getTarget().getAtomCount() + " overlaps " + overlap);
    }

    @Override
    public synchronized MCSSolution call() throws Exception {
        try {
            if (!this.theory.equals((Object)IMappingAlgorithm.RINGS)) {
                IAtomContainer ac1;
                boolean possibleVFmatch12 = this.isPossibleSubgraphMatch(this.getCompound1(), this.getCompound2());
                boolean possibleVFmatch21 = this.isPossibleSubgraphMatch(this.getCompound2(), this.getCompound1());
                if (possibleVFmatch12 && this.getCompound1().getAtomCount() <= this.getCompound2().getAtomCount() && this.getCompound1().getBondCount() <= this.getCompound2().getBondCount()) {
                    IAtomContainer ac2;
                    ac1 = this.duplicate(this.getCompound1());
                    Substructure substructure = new Substructure(ac1, ac2 = this.duplicate(this.getCompound2()), true, false, this.isHasPerfectRings(), true);
                    if (!substructure.isSubgraph()) {
                        substructure = new Substructure(ac1, ac2, false, false, this.isHasPerfectRings(), true);
                    }
                    substructure.setChemFilters(this.stereoFlag, this.fragmentFlag, this.energyFlag);
                    if (substructure.isSubgraph() && substructure.getFirstAtomMapping().getCount() == ac1.getAtomCount()) {
                        MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), substructure.getQuery(), substructure.getTarget(), substructure.getFirstAtomMapping());
                        mcs.setEnergy(substructure.getEnergyScore(0));
                        mcs.setFragmentSize(substructure.getFragmentSize(0));
                        mcs.setStereoScore(substructure.getStereoScore(0));
                        return mcs;
                    }
                } else if (possibleVFmatch21) {
                    ac1 = this.duplicate(this.getCompound1());
                    IAtomContainer ac2 = this.duplicate(this.getCompound2());
                    Substructure substructure = new Substructure(ac2, ac1, true, false, this.isHasPerfectRings(), true);
                    if (!substructure.isSubgraph()) {
                        substructure = new Substructure(ac2, ac1, false, false, this.isHasPerfectRings(), true);
                    }
                    substructure.setChemFilters(this.stereoFlag, this.fragmentFlag, this.energyFlag);
                    if (substructure.isSubgraph() && substructure.getFirstAtomMapping().getCount() == ac2.getAtomCount()) {
                        AtomAtomMapping aam = new AtomAtomMapping(substructure.getTarget(), substructure.getQuery());
                        Map<IAtom, IAtom> mappings = substructure.getFirstAtomMapping().getMappingsByAtoms();
                        for (IAtom atom1 : mappings.keySet()) {
                            IAtom atom2 = mappings.get(atom1);
                            aam.put(atom2, atom1);
                        }
                        MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), substructure.getTarget(), substructure.getQuery(), aam);
                        mcs.setEnergy(substructure.getEnergyScore(0));
                        mcs.setFragmentSize(substructure.getFragmentSize(0));
                        mcs.setStereoScore(substructure.getStereoScore(0));
                        return mcs;
                    }
                }
                MCSSolution mcs = this.mcs();
                return mcs;
            }
            MCSSolution mcs = this.mcs();
            return mcs;
        }
        catch (CloneNotSupportedException | CDKException ex) {
            Logger.getLogger(MCSThread.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private IAtomContainer getNewContainerWithIDs(IAtomContainer mol) throws CDKException, CloneNotSupportedException {
        IAtomContainer ac = mol.clone();
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            String atomID = mol.getAtom(i).getID() == null ? String.valueOf(i) : mol.getAtom(i).getID();
            ac.getAtom(i).setID(atomID);
        }
        String containerID = mol.getID() == null ? String.valueOf(System.nanoTime()) : mol.getID();
        ac.setID(containerID);
        return ac;
    }

    synchronized void setStereoFlag(boolean b) {
        this.stereoFlag = b;
    }

    synchronized void setFragmentFilterFlag(boolean fragmentFilterFlag) {
        this.fragmentFlag = fragmentFilterFlag;
    }

    synchronized void setEnergyFlag(boolean energyFlag) {
        this.energyFlag = energyFlag;
    }

    private boolean isPossibleSubgraphMatch(IAtomContainer q, IAtomContainer t) {
        int counter;
        TreeMap<String, Integer> atomUniqueCounter1 = new TreeMap<String, Integer>();
        TreeMap<String, Integer> atomUniqueCounter2 = new TreeMap<String, Integer>();
        for (IAtom a : q.atoms()) {
            if (!atomUniqueCounter1.containsKey(a.getSymbol())) {
                atomUniqueCounter1.put(a.getSymbol(), 1);
                continue;
            }
            counter = (Integer)atomUniqueCounter1.get(a.getSymbol()) + 1;
            atomUniqueCounter1.put(a.getSymbol(), counter);
        }
        for (IAtom b : t.atoms()) {
            if (!atomUniqueCounter2.containsKey(b.getSymbol())) {
                atomUniqueCounter2.put(b.getSymbol(), 1);
                continue;
            }
            counter = (Integer)atomUniqueCounter2.get(b.getSymbol()) + 1;
            atomUniqueCounter2.put(b.getSymbol(), counter);
        }
        if (atomUniqueCounter1.size() > atomUniqueCounter2.size()) {
            return false;
        }
        LinkedList difference = new LinkedList(atomUniqueCounter1.keySet());
        difference.removeAll(atomUniqueCounter2.keySet());
        if (difference.isEmpty()) {
            for (String k : atomUniqueCounter1.keySet()) {
                if ((Integer)atomUniqueCounter1.get(k) <= (Integer)atomUniqueCounter2.get(k)) continue;
                return false;
            }
        }
        return difference.isEmpty();
    }

    private int expectedMaxGraphmatch(IAtomContainer q, IAtomContainer t) {
        String hyb;
        ArrayList<String> atomUniqueCounter1 = new ArrayList<String>();
        ArrayList<String> atomUniqueCounter2 = new ArrayList<String>();
        for (IAtom a : q.atoms()) {
            hyb = a.getHybridization() == CDKConstants.UNSET ? a.getSymbol() : a.getAtomTypeName();
            atomUniqueCounter1.add(hyb);
        }
        for (IAtom b : t.atoms()) {
            hyb = b.getHybridization() == CDKConstants.UNSET ? b.getSymbol() : b.getAtomTypeName();
            atomUniqueCounter2.add(hyb);
        }
        Collections.sort(atomUniqueCounter1);
        Collections.sort(atomUniqueCounter2);
        if (atomUniqueCounter1.isEmpty()) {
            return 0;
        }
        LinkedList common = new LinkedList(atomUniqueCounter1);
        common.retainAll(atomUniqueCounter2);
        atomUniqueCounter1.clear();
        atomUniqueCounter2.clear();
        return common.size();
    }

    synchronized MCSSolution mcs() {
        try {
            int expectedMaxGraphmatch = this.expectedMaxGraphmatch(this.getCompound1(), this.getCompound2());
            Isomorphism isomorphism = this.eductCount == 1 && this.productCount == 1 ? new Isomorphism(this.getCompound1(), this.getCompound2(), Algorithm.DEFAULT, false, this.isHasPerfectRings(), false) : (expectedMaxGraphmatch > 30 ? new Isomorphism(this.getCompound1(), this.getCompound2(), Algorithm.VFLibMCS, false, this.isHasPerfectRings(), !this.isHasPerfectRings()) : new Isomorphism(this.getCompound1(), this.getCompound2(), Algorithm.DEFAULT, false, this.isHasPerfectRings(), !this.isHasPerfectRings()));
            isomorphism.setChemFilters(this.stereoFlag, this.fragmentFlag, this.energyFlag);
            MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), isomorphism.getQuery(), isomorphism.getTarget(), isomorphism.getFirstAtomMapping());
            mcs.setEnergy(isomorphism.getEnergyScore(0));
            mcs.setFragmentSize(isomorphism.getFragmentSize(0));
            mcs.setStereoScore(isomorphism.getStereoScore(0));
            return mcs;
        }
        catch (CloneNotSupportedException | CDKException e) {
            Logger.getLogger(MCSThread.class.getName()).log(Level.SEVERE, "Error in computing MCS ", e);
            return null;
        }
    }

    synchronized MCSSolution combimcs(boolean stereoFlag, boolean fragmentFlag, boolean energyFlag) throws CloneNotSupportedException, CDKException {
        double energy = 0.0;
        int fragmentSize = 0;
        int stereoScore = 0;
        IAtomContainer ac1 = this.duplicate(this.getCompound1());
        IAtomContainer ac2 = this.duplicate(this.getCompound2());
        Isomorphism isomorphism = new Isomorphism(ac1, ac2, Algorithm.DEFAULT, true, this.ringMatcher, true);
        isomorphism.setChemFilters(stereoFlag, fragmentFlag, energyFlag);
        HashMap<IAtom, IAtom> acceptedSolution = new HashMap<IAtom, IAtom>();
        if (!isomorphism.getFirstAtomMapping().isEmpty()) {
            for (IAtom a : isomorphism.getFirstAtomMapping().getMappingsByAtoms().keySet()) {
                IAtom refA = this.getAtomByID(this.getCompound1(), a);
                IAtom iAtom = this.getAtomByID(this.getCompound2(), isomorphism.getFirstAtomMapping().getMappingsByAtoms().get(a));
                acceptedSolution.put(refA, iAtom);
            }
            ac1 = this.reduceAtomContainer(ac1, isomorphism.getFirstAtomMapping().getMappingsByAtoms().keySet());
            ac2 = this.reduceAtomContainer(ac2, isomorphism.getFirstAtomMapping().getMappingsByAtoms().values());
            energy += isomorphism.getEnergyScore(0).doubleValue();
            fragmentSize += isomorphism.getFragmentSize(0).intValue();
            stereoScore += isomorphism.getStereoScore(0).intValue();
        }
        if (ac1.getAtomCount() > 0 && ac2.getAtomCount() > 0) {
            isomorphism = new Isomorphism(ac1, ac2, Algorithm.VFLibMCS, false, this.ringMatcher, true);
            isomorphism.setChemFilters(stereoFlag, fragmentFlag, energyFlag);
            List<AtomAtomMapping> allAtomMapping = isomorphism.getAllAtomMapping();
            int solIndex = 0;
            for (AtomAtomMapping atomAtomMapping : allAtomMapping) {
                boolean stitchingFeasible = this.isStitchingFeasible(this.getCompound1(), this.getCompound2(), acceptedSolution, atomAtomMapping);
                if (stitchingFeasible) {
                    for (IAtom a : atomAtomMapping.getMappingsByAtoms().keySet()) {
                        IAtom refA = this.getAtomByID(this.getCompound1(), a);
                        IAtom refB = this.getAtomByID(this.getCompound2(), atomAtomMapping.getMappingsByAtoms().get(a));
                        acceptedSolution.put(refA, refB);
                    }
                    energy += isomorphism.getEnergyScore(solIndex).doubleValue();
                    fragmentSize += isomorphism.getFragmentSize(solIndex).intValue();
                    stereoScore += isomorphism.getStereoScore(solIndex).intValue();
                    ac1 = this.reduceAtomContainer(ac1, atomAtomMapping.getMappingsByAtoms().keySet());
                    ac2 = this.reduceAtomContainer(ac2, atomAtomMapping.getMappingsByAtoms().values());
                    break;
                }
                ++solIndex;
            }
            AtomAtomMapping combi = new AtomAtomMapping(this.getCompound1(), this.getCompound2());
            for (IAtom a : acceptedSolution.keySet()) {
                IAtom b = (IAtom)acceptedSolution.get(a);
                combi.put(a, b);
            }
            MCSSolution mCSSolution = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), isomorphism.getQuery(), isomorphism.getTarget(), combi);
            mCSSolution.setEnergy(energy);
            mCSSolution.setFragmentSize(fragmentSize);
            mCSSolution.setStereoScore(stereoScore);
        }
        MCSSolution mcs = new MCSSolution(this.getQueryPosition(), this.getTargetPosition(), isomorphism.getQuery(), isomorphism.getTarget(), isomorphism.getFirstAtomMapping());
        mcs.setEnergy(isomorphism.getEnergyScore(0));
        mcs.setFragmentSize(isomorphism.getFragmentSize(0));
        mcs.setStereoScore(isomorphism.getStereoScore(0));
        return mcs;
    }

    private IAtomContainer reduceAtomContainer(IAtomContainer ac, Collection<IAtom> keySet) throws CloneNotSupportedException {
        IAtomContainer ac_new = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        HashMap<IAtom, IAtom> ref_new_atom = new HashMap<IAtom, IAtom>();
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            IAtom ref = ac.getAtom(i);
            if (keySet.contains(ref)) continue;
            IAtom a = ref.clone();
            a.setID(ref.getID());
            ac_new.addAtom(a);
            ref_new_atom.put(ref, a);
        }
        for (IBond b : ac.bonds()) {
            if (keySet.contains(b.getAtom(0)) || keySet.contains(b.getAtom(1))) continue;
            IAtom a1 = (IAtom)ref_new_atom.get(b.getAtom(0));
            IAtom a2 = (IAtom)ref_new_atom.get(b.getAtom(1));
            IBond.Order order = b.getOrder();
            ac_new.addBond(ac_new.getAtomNumber(a1), ac_new.getAtomNumber(a2), order);
        }
        ac_new.setID(ac.getID());
        return ac_new;
    }

    private synchronized IAtom getAtomByID(IAtomContainer ac, IAtom atom) {
        if (atom.getID() == null) {
            return null;
        }
        for (IAtom a : ac.atoms()) {
            if (!a.getID().equals(atom.getID())) continue;
            return a;
        }
        return null;
    }

    private boolean isStitchingFeasible(IAtomContainer compound1, IAtomContainer compound2, Map<IAtom, IAtom> map, AtomAtomMapping mapping) {
        IBond bond;
        IAtom refAtomB;
        IAtom refAtomA;
        boolean t1 = false;
        boolean t2 = false;
        block0: for (IAtom a : map.keySet()) {
            refAtomA = this.getAtomByID(compound1, a);
            for (IAtom b : mapping.getMappingsByAtoms().keySet()) {
                refAtomB = this.getAtomByID(compound1, b);
                bond = compound1.getBond(refAtomA, refAtomB);
                if (bond == null) continue;
                t1 = true;
                continue block0;
            }
        }
        block2: for (IAtom a : map.values()) {
            refAtomA = this.getAtomByID(compound2, a);
            for (IAtom b : mapping.getMappingsByAtoms().values()) {
                refAtomB = this.getAtomByID(compound2, b);
                bond = compound2.getBond(refAtomA, refAtomB);
                if (bond == null) continue;
                t2 = true;
                continue block2;
            }
        }
        return t1 && t2;
    }

    private IAtomContainer duplicate(IAtomContainer ac) throws CloneNotSupportedException {
        IAtomContainer a = ac.clone();
        a.setID(ac.getID());
        for (int i = 0; i < a.getAtomCount(); ++i) {
            a.getAtom(i).setID(ac.getAtom(i).getID());
        }
        return a;
    }

    synchronized IAtomContainer getCompound1() {
        return this.compound1;
    }

    synchronized IAtomContainer getCompound2() {
        return this.compound2;
    }

    synchronized int getQueryPosition() {
        return this.queryPosition;
    }

    synchronized int getTargetPosition() {
        return this.targetPosition;
    }

    void setHasPerfectRings(boolean ring) {
        this.hasRings = ring;
    }

    boolean isHasPerfectRings() {
        return this.hasRings;
    }

    void setEductCount(Integer eductCount) {
        this.eductCount = eductCount;
    }

    void setProductCount(Integer productCount) {
        this.productCount = productCount;
    }
}

