/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.graph;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.interfaces.BestMatch;
import uk.ac.ebi.reactionblast.mapping.interfaces.IGraphMatching;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public class GraphMatching
extends IGraphMatching
implements Serializable {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(GraphMatching.class);
    private static final long serialVersionUID = 64536892921L;
    private static final Logger LOG = Logger.getLogger(GraphMatching.class.getName());
    private final IAtomContainer educt;
    private final IAtomContainer product;
    private IAtomContainer matchedPart = null;
    private Map<IAtom, IAtom> bestAtomMappingList;
    private int fragmentCount = 0;

    public GraphMatching(String reaction_ID, IAtomContainer eductOrg, IAtomContainer productOrg, String suffix, boolean removeHydrogen) throws Exception {
        try {
            this.educt = eductOrg;
            this.product = productOrg;
            this.educt.setID(eductOrg.getID());
            this.product.setID(productOrg.getID());
            if (this.educt.getAtomCount() > 0 && this.product.getAtomCount() > 0) {
                this.setMatchedPart(ExtAtomContainerManipulator.cloneWithIDs(this.educt));
            }
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Error: In GraphMatching Class" + e);
        }
    }

    @Override
    public synchronized boolean mcsMatch(Holder holder, boolean removeHydrogen, Integer substrateIndex, Integer productIndex, BitSet eductFP, BitSet prodFP) {
        if (this.educt.getAtomCount() <= 0 && this.product.getAtomCount() <= 0) {
            return false;
        }
        try {
            GraphMatching.setMCSUpdationFlags(holder, substrateIndex, productIndex);
            BestMatch initMcsAtom = holder.getBestMatchContainer();
            if (initMcsAtom.containsKey(substrateIndex, productIndex)) {
                this.bestAtomMappingList = initMcsAtom.getAtomMatch(substrateIndex, productIndex).getMappingsByAtoms();
                this.fragmentCount = initMcsAtom.getTotalFragmentCount(substrateIndex, productIndex);
                if (this.bestAtomMappingList != null && !this.bestAtomMappingList.isEmpty()) {
                    return true;
                }
            }
        }
        catch (IOException ex) {
            logger.debug("Files: " + this.educt.getID() + ", " + this.product.getID());
            logger.debug(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public synchronized int removeMatchedAtomsAndUpdateAAM(IReaction reaction) {
        int delta = 0;
        int beforeESize = this.educt.getAtomCount();
        if (this.bestAtomMappingList != null) {
            for (Map.Entry entry : this.bestAtomMappingList.entrySet()) {
                String eID = ((IAtom)entry.getKey()).getID();
                IAtom eAtom = this.getAtomByID(this.educt, eID);
                String pID = ((IAtom)entry.getValue()).getID();
                IAtom pAtom = this.getAtomByID(this.product, pID);
                if (eAtom != null && pAtom != null) {
                    IMapping im = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, eAtom, pAtom);
                    reaction.addMapping(im);
                }
                this.educt.removeAtomAndConnectedElectronContainers(eAtom);
                this.product.removeAtomAndConnectedElectronContainers(pAtom);
                delta = this.fragmentCount;
            }
        }
        for (IAtom iAtom : this.educt.atoms()) {
            IAtom matchedAtom = this.getAtomByID(this.matchedPart, iAtom.getID());
            this.matchedPart.removeAtomAndConnectedElectronContainers(matchedAtom);
        }
        if (beforeESize == this.educt.getAtomCount()) {
            try {
                throw new CDKException("Failed to remove matched parts between " + this.educt.getID() + ": " + this.educt.getAtomCount() + " , " + this.product.getID() + " : " + this.product.getAtomCount() + ", Mapping count: " + this.bestAtomMappingList.size() + "...atom ids did not matched!");
            }
            catch (CDKException ex) {
                Logger.getLogger(GraphMatching.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return delta;
    }

    private synchronized IAtom getAtomByID(IAtomContainer ac, String ID) {
        for (IAtom atom : ac.atoms()) {
            if (!atom.getID().equalsIgnoreCase(ID)) continue;
            return atom;
        }
        return null;
    }

    @Override
    public synchronized IAtomContainer getRemainingEduct() {
        return this.educt;
    }

    @Override
    public synchronized IAtomContainer getRemainingProduct() {
        return this.product;
    }

    protected synchronized Map<IAtom, IAtom> getFirstAtomMapping() {
        return Collections.unmodifiableMap(this.bestAtomMappingList);
    }

    @Override
    public synchronized IAtomContainer getMatchedPart() {
        return this.matchedPart;
    }

    private synchronized void setMatchedPart(IAtomContainer aMatchedPart) {
        this.matchedPart = aMatchedPart;
    }
}

