/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.smsd.Substructure;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public final class RuleBasedMappingHandler
implements Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 88765671L;
    private static final Logger LOG = Logger.getLogger(RuleBasedMappingHandler.class.getName());
    private boolean ruleMatched = false;
    private Holder matrixHolder;
    private Holder matrixHolderClone;
    private final Map<Integer, Integer> matchedRowColoumn;
    private IAtomContainer smartsWater;
    private IAtomContainer smartsPhosphate;
    private IAtomContainer smartsSulphate;
    private IAtomContainer smartsL_Glutamate;
    private IAtomContainer smartsL_Glutamine;
    private IAtomContainer smartsTwoOxoglutarate;
    private IAtomContainer smartsD_Glutamate;
    private IAtomContainer smartsAcetate;
    private IAtomContainer smartsATP;
    private IAtomContainer smartsADP;
    private IAtomContainer smartsCoA;
    private IAtomContainer smartsAcetyl_CoA;
    private IAtomContainer smartsC00003;
    private IAtomContainer smartsC00006;
    private IAtomContainer smartsC00004;
    private IAtomContainer smartsC00005;
    private IAtomContainer smartsPyruvate;
    private IAtomContainer smartsAlanine;

    public RuleBasedMappingHandler(Holder matrixHolder, List<String> EdMapOrignal, List<String> PdMapOrignal) throws CDKException, IOException {
        int i;
        this.setRulesSmiles();
        this.matrixHolder = matrixHolder;
        this.matchedRowColoumn = new HashMap<Integer, Integer>();
        this.setRuleMatched(false);
        int smallestMatchedReactant = Integer.MAX_VALUE;
        int smallestMatchedProduct = Integer.MAX_VALUE;
        for (i = 0; i < this.matrixHolder.getReactionContainer().getEductCount(); ++i) {
            IAtomContainer ac1 = new AtomContainer(this.matrixHolder.getReactionContainer().getEduct(i));
            if ((ac1 = ExtAtomContainerManipulator.removeHydrogens(ac1)).getAtomCount() < this.getSmartsPhosphate().getAtomCount() && ac1.getAtomCount() < this.getSmartsSulphate().getAtomCount() || !this.isMatch(this.getSmartsPhosphate(), ac1) && !this.isMatch(this.getSmartsSulphate(), ac1) || smallestMatchedReactant <= ac1.getAtomCount()) continue;
            smallestMatchedReactant = ac1.getAtomCount();
        }
        for (int j = 0; j < this.matrixHolder.getReactionContainer().getProductCount(); ++j) {
            IAtomContainer ac2 = new AtomContainer(this.matrixHolder.getReactionContainer().getProduct(j));
            if ((ac2 = ExtAtomContainerManipulator.removeHydrogens(ac2)).getAtomCount() < this.getSmartsPhosphate().getAtomCount() && ac2.getAtomCount() < this.getSmartsSulphate().getAtomCount() || !this.isMatch(this.getSmartsPhosphate(), ac2) && !this.isMatch(this.getSmartsSulphate(), ac2) || smallestMatchedProduct <= ac2.getAtomCount()) continue;
            smallestMatchedProduct = ac2.getAtomCount();
        }
        try {
            for (i = 0; i < this.matrixHolder.getReactionContainer().getEductCount(); ++i) {
                IAtomContainer educt = this.matrixHolder.getReactionContainer().getEduct(i);
                IAtomContainer ac1 = new AtomContainer(educt);
                ac1 = ExtAtomContainerManipulator.removeHydrogens(ac1);
                for (int j = 0; j < this.matrixHolder.getReactionContainer().getProductCount(); ++j) {
                    IAtomContainer product = this.matrixHolder.getReactionContainer().getProduct(j);
                    IAtomContainer ac2 = new AtomContainer(product);
                    ac2 = ExtAtomContainerManipulator.removeHydrogens(ac2);
                    if (this.matrixHolder.getCliqueMatrix().getValue(i, j) == 0.0) continue;
                    if (ac1.getAtomCount() == 1 && this.isMatch(this.getSmartsWater(), ac1) && this.isMatch(this.getSmartsPhosphate(), ac2) && ac2.getAtomCount() == smallestMatchedProduct) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                    } else if (ac2.getAtomCount() == 1 && this.isMatch(this.getSmartsWater(), ac2) && this.isMatch(this.getSmartsPhosphate(), ac1) && ac1.getAtomCount() == smallestMatchedReactant) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                    }
                    if (ac1.getAtomCount() == 1 && this.isMatch(this.getSmartsWater(), ac1) && this.isMatch(this.getSmartsSulphate(), ac2) && ac2.getAtomCount() == smallestMatchedProduct) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac2.getAtomCount() == 1 && this.isMatch(this.getSmartsWater(), ac2) && this.isMatch(this.getSmartsSulphate(), ac1) && ac1.getAtomCount() == smallestMatchedReactant) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && this.isMatch(this.getSmartsL_Glutamate(), ac1) && this.isMatch(this.getSmartsL_Glutamine(), ac2) || ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && this.isMatch(this.getSmartsL_Glutamine(), ac1) && this.isMatch(this.getSmartsL_Glutamate(), ac2)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac2.getAtomCount() == 10 && ac1.getAtomCount() == 10 && this.isMatch(this.getSmartsTwoOxoglutarate(), ac2) && this.isMatch(this.getSmartsD_Glutamate(), ac1) || ac1.getAtomCount() == 10 && ac2.getAtomCount() == 10 && this.isMatch(this.getSmartsTwoOxoglutarate(), ac1) && this.isMatch(this.getSmartsD_Glutamate(), ac2)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == 1 && this.isMatch(this.getSmartsWater(), ac1) && ac2.getAtomCount() >= this.getSmartsAcetate().getAtomCount() && this.isMatch(this.getSmartsAcetate(), ac2) || ac2.getAtomCount() == 1 && this.isMatch(this.getSmartsWater(), ac2) && ac1.getAtomCount() >= this.getSmartsAcetate().getAtomCount() && this.isMatch(this.getSmartsAcetate(), ac1)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsATP().getAtomCount() && this.isMatch(this.getSmartsATP(), ac1) && this.isMatch(this.getSmartsADP(), ac2) || ac1.getAtomCount() == this.getSmartsADP().getAtomCount() && this.isMatch(this.getSmartsADP(), ac1) && this.isMatch(this.getSmartsATP(), ac2)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsCoA().getAtomCount() && this.isMatch(this.getSmartsCoA(), ac1) && this.isMatch(this.getSmartsAcetyl_CoA(), ac2) || ac1.getAtomCount() == this.getSmartsAcetyl_CoA().getAtomCount() && this.isMatch(this.getSmartsAcetyl_CoA(), ac1) && this.isMatch(this.getSmartsCoA(), ac2)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsC00003().getAtomCount() && this.isMatch(this.getSmartsC00003(), ac1) && this.isMatch(this.getSmartsC00006(), ac2) || ac1.getAtomCount() == this.getSmartsC00006().getAtomCount() && this.isMatch(this.getSmartsC00006(), ac1) && this.isMatch(this.getSmartsC00003(), ac2)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if (ac1.getAtomCount() == this.getSmartsC00004().getAtomCount() && this.isMatch(this.getSmartsC00004(), ac1) && this.isMatch(this.getSmartsC00005(), ac2) || ac1.getAtomCount() == this.getSmartsC00005().getAtomCount() && this.isMatch(this.getSmartsC00005(), ac1) && this.isMatch(this.getSmartsC00004(), ac2)) {
                        this.setRuleMatched(true);
                        this.matchedRowColoumn.put(i, j);
                        continue;
                    }
                    if ((ac1.getAtomCount() != this.getSmartsPyruvate().getAtomCount() || !this.isMatch(this.getSmartsPyruvate(), ac1) || !this.isMatch(this.getSmartsAlanine(), ac2)) && (ac1.getAtomCount() != this.getSmartsAlanine().getAtomCount() || !this.isMatch(this.getSmartsAlanine(), ac1) || !this.isMatch(this.getSmartsPyruvate(), ac2))) continue;
                    this.setRuleMatched(true);
                    this.matchedRowColoumn.put(i, j);
                }
            }
        }
        catch (IOException | CDKException ex) {
            Logger.getLogger(RuleBasedMappingHandler.class.getName()).log(Level.WARNING, "Error in Matching Rules", ex);
        }
        if (this.isMatchFound()) {
            try {
                this.matrixHolderClone = (Holder)matrixHolder.clone();
            }
            catch (CloneNotSupportedException ex) {
                System.err.println("ERROR: Matrix Holder clone error");
                Logger.getLogger(RuleBasedMappingHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            for (int i2 = 0; i2 < this.matrixHolder.getReactionContainer().getEductCount(); ++i2) {
                for (int j = 0; j < this.matrixHolder.getReactionContainer().getProductCount(); ++j) {
                    if (this.matchedRowColoumn.containsKey(i2) && this.matchedRowColoumn.get(i2) == j) {
                        this.matrixHolderClone.getGraphSimilarityMatrix().setValue(i2, j, 1.0);
                        continue;
                    }
                    this.matrixHolderClone.getGraphSimilarityMatrix().setValue(i2, j, Double.MIN_VALUE);
                    this.matrixHolderClone.getCliqueMatrix().setValue(i2, j, Double.MIN_VALUE);
                    this.matrixHolderClone.getStereoMatrix().setValue(i2, j, -1.7976931348623157E308);
                    this.matrixHolderClone.getFragmentMatrix().setValue(i2, j, Double.MAX_VALUE);
                    this.matrixHolderClone.getEnergyMatrix().setValue(i2, j, Double.MAX_VALUE);
                    this.matrixHolderClone.getFPSimilarityMatrix().setValue(i2, j, Double.MIN_VALUE);
                }
            }
            this.matrixHolder = this.matrixHolderClone;
        }
    }

    public synchronized Holder getMatrixHolder() {
        return this.matrixHolder;
    }

    public synchronized boolean isMatchFound() {
        return this.ruleMatched;
    }

    private synchronized void setRuleMatched(boolean ruleMatched) {
        this.ruleMatched = ruleMatched;
    }

    private boolean isMatch(IAtomContainer ac1, IAtomContainer ac2) {
        if (ac1.getAtomCount() <= ac2.getAtomCount()) {
            try {
                Substructure s = new Substructure(ac1, ac2, true, true, false, false);
                return s.isSubgraph();
            }
            catch (CDKException ex) {
                Logger.getLogger(RuleBasedMappingHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                Substructure s = new Substructure(ac2, ac1, true, true, false, false);
                return s.isSubgraph();
            }
            catch (CDKException ex) {
                Logger.getLogger(RuleBasedMappingHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    private void setRulesSmiles() throws CDKException {
        String waterSMILES = "O";
        String phosphateSMILES = "OP(O)(O)=O";
        String sulphateSMILES = "O=S(=O)(O)O";
        String lGlutamate = "N[C@@H](CCC(O)=O)C(O)=O";
        String lGlutamine = "N[C@@H](CCC(N)=O)C(O)=O";
        String twoOxoglutarate = "OC(=O)CCC(=O)C(O)=O";
        String dGlutamate = "N[C@H](CCC(O)=O)C(O)=O";
        String acetate = "CC(O)=O";
        String ATP = "NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O";
        String ADP = "NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O";
        String CoA = "CC(C)(COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N)[C@@H](O)C(=O)NCCC(=O)NCCS";
        String Acetyl_CoA = "CC(=O)SCCNC(=O)CCNC(=O)[C@H](O)C(C)(C)COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N";
        String C00003 = "NC(=O)C1=CC=C[N+](=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C(N)N=CN=C23)[C@@H](O)[C@H]1O";
        String C00006 = "NC(=O)C1=C[N+](=CC=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O";
        String C00004 = "NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O";
        String C00005 = "NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O";
        String C00022 = "[CH3][C](=O)C(O)=O";
        String C00041 = "[CH3][C](N)C(O)=O";
        SmilesParser smilesParser = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        this.smartsWater = smilesParser.parseSmiles("O");
        this.smartsPhosphate = smilesParser.parseSmiles("OP(O)(O)=O");
        this.smartsSulphate = smilesParser.parseSmiles("O=S(=O)(O)O");
        this.smartsL_Glutamate = smilesParser.parseSmiles("N[C@@H](CCC(O)=O)C(O)=O");
        this.smartsL_Glutamine = smilesParser.parseSmiles("N[C@@H](CCC(N)=O)C(O)=O");
        this.smartsTwoOxoglutarate = smilesParser.parseSmiles("OC(=O)CCC(=O)C(O)=O");
        this.smartsD_Glutamate = smilesParser.parseSmiles("N[C@H](CCC(O)=O)C(O)=O");
        this.smartsAcetate = smilesParser.parseSmiles("CC(O)=O");
        this.smartsATP = smilesParser.parseSmiles("NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O");
        this.smartsADP = smilesParser.parseSmiles("NC1=NC=NC2=C1N=CN2[C@@H]1O[C@H](COP(O)(=O)OP(O)(O)=O)[C@@H](O)[C@H]1O");
        this.smartsCoA = smilesParser.parseSmiles("CC(C)(COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N)[C@@H](O)C(=O)NCCC(=O)NCCS");
        this.smartsAcetyl_CoA = smilesParser.parseSmiles("CC(=O)SCCNC(=O)CCNC(=O)[C@H](O)C(C)(C)COP(O)(=O)OP(O)(=O)OC[C@H]1O[C@H]([C@H](O)[C@@H]1OP(O)(O)=O)N1C=NC2=C1N=CN=C2N");
        this.smartsC00003 = smilesParser.parseSmiles("NC(=O)C1=CC=C[N+](=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C(N)N=CN=C23)[C@@H](O)[C@H]1O");
        this.smartsC00006 = smilesParser.parseSmiles("NC(=O)C1=C[N+](=CC=C1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O");
        this.smartsC00004 = smilesParser.parseSmiles("NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O");
        this.smartsC00005 = smilesParser.parseSmiles("NC(=O)C1=CN(C=CC1)[C@@H]1O[C@H](COP(O)(=O)OP(O)(=O)OC[C@H]2O[C@H]([C@H](OP(O)(O)=O)[C@@H]2O)N2C=NC3=C2N=CN=C3N)[C@@H](O)[C@H]1O");
        this.smartsAlanine = smilesParser.parseSmiles("[CH3][C](N)C(O)=O");
        this.smartsPyruvate = smilesParser.parseSmiles("[CH3][C](=O)C(O)=O");
    }

    private IAtomContainer getSmartsWater() {
        return this.smartsWater;
    }

    private IAtomContainer getSmartsPhosphate() {
        return this.smartsPhosphate;
    }

    private IAtomContainer getSmartsL_Glutamate() {
        return this.smartsL_Glutamate;
    }

    private IAtomContainer getSmartsL_Glutamine() {
        return this.smartsL_Glutamine;
    }

    private IAtomContainer getSmartsTwoOxoglutarate() {
        return this.smartsTwoOxoglutarate;
    }

    private IAtomContainer getSmartsD_Glutamate() {
        return this.smartsD_Glutamate;
    }

    private IAtomContainer getSmartsAcetate() {
        return this.smartsAcetate;
    }

    private IAtomContainer getSmartsSulphate() {
        return this.smartsSulphate;
    }

    public IAtomContainer getSmartsATP() {
        return this.smartsATP;
    }

    public IAtomContainer getSmartsADP() {
        return this.smartsADP;
    }

    public IAtomContainer getSmartsCoA() {
        return this.smartsCoA;
    }

    public IAtomContainer getSmartsAcetyl_CoA() {
        return this.smartsAcetyl_CoA;
    }

    public IAtomContainer getSmartsC00003() {
        return this.smartsC00003;
    }

    public IAtomContainer getSmartsC00006() {
        return this.smartsC00006;
    }

    public IAtomContainer getSmartsC00004() {
        return this.smartsC00004;
    }

    public IAtomContainer getSmartsC00005() {
        return this.smartsC00005;
    }

    public IAtomContainer getSmartsPyruvate() {
        return this.smartsPyruvate;
    }

    public IAtomContainer getSmartsAlanine() {
        return this.smartsAlanine;
    }
}

