/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm.checks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.Selector;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;

public class ChooseWinner
extends Selector
implements Serializable {
    private static final long serialVersionUID = 11112122121L;
    private static final Logger LOG = Logger.getLogger(ChooseWinner.class.getName());
    private EBIMatrix stereoMatrix;
    private EBIMatrix energyMatrix;
    private EBIMatrix similarityMatrix = null;
    private List<Cells> crossMappingTracer = null;
    private Map<Integer, IAtomContainer> educts = null;
    private Map<Integer, IAtomContainer> products = null;

    public ChooseWinner(List<String> eductNameList, List<String> productNameList) {
        this.rowSize = eductNameList.size();
        this.colSize = productNameList.size();
        this.flagMatrix = new boolean[this.rowSize][this.colSize];
    }

    public EBIMatrix getStereoMatrix() {
        return this.stereoMatrix;
    }

    public void setStereoMatrix(EBIMatrix stereoMatrix) {
        this.stereoMatrix = stereoMatrix;
    }

    public EBIMatrix getEnergyMatrix() {
        return this.energyMatrix;
    }

    public void setEnergyMatrix(EBIMatrix energyMatrix) {
        this.energyMatrix = energyMatrix;
    }

    public synchronized void searchWinners(Map<Integer, IAtomContainer> eductMap, Map<Integer, IAtomContainer> productMap, Holder mHolder) {
        this.initFlagMatrix();
        this.educts = eductMap;
        this.products = productMap;
        this.similarityMatrix = mHolder.getGraphSimilarityMatrix();
        this.setStereoMatrix(mHolder.getStereoMatrix());
        this.setEnergyMatrix(mHolder.getEnergyMatrix());
        this.crossMappingTracer = Collections.synchronizedList(new ArrayList());
        boolean isMappingFesiable = this.checkStatusFlag();
        ArrayList<Double> scores = new ArrayList<Double>();
        if (isMappingFesiable) {
            double maximumSimilarity = 0.0;
            for (int i = 0; i < this.rowSize; ++i) {
                for (int j = 0; j < this.colSize; ++j) {
                    double similarity = this.similarityMatrix.getValue(i, j);
                    if (!(similarity > Double.MIN_VALUE)) continue;
                    boolean maxValueI = this.isMajorSubgraphRow(this.similarityMatrix, i, j);
                    boolean maxValueJ = this.isMajorSubgraphColumn(this.similarityMatrix, i, j);
                    if (!maxValueI || !maxValueJ) continue;
                    if (similarity > maximumSimilarity) {
                        maximumSimilarity = similarity;
                        this.initFlagMatrix();
                        scores.clear();
                    }
                    if (similarity != maximumSimilarity) continue;
                    this.flagMatrix[i][j] = true;
                    scores.add(similarity);
                }
            }
        }
        this.resolveDeadLocks(scores);
        this.setWinOverFlags();
    }

    public synchronized boolean getFlag() {
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.colSize; ++j) {
                if (!this.flagMatrix[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean[][] getFlagMatrix() {
        return this.flagMatrix;
    }

    private synchronized void initFlagMatrix() {
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.colSize; ++j) {
                this.flagMatrix[i][j] = false;
            }
        }
    }

    private synchronized void initFlagMatrix(boolean[][] boolMatrix, int rowSize, int colSize) {
        for (int i = 0; i < rowSize; ++i) {
            for (int j = 0; j < colSize; ++j) {
                boolMatrix[i][j] = false;
            }
        }
    }

    private synchronized boolean checkStatusFlag() {
        for (int i = 0; i < this.rowSize; ++i) {
            for (int j = 0; j < this.colSize; ++j) {
                if (!(this.similarityMatrix.getValue(i, j) > Double.MIN_VALUE)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void setWinOverFlags() {
        for (Integer indexI : this.educts.keySet()) {
            for (Integer indexJ : this.products.keySet()) {
                Cells cell = new Cells();
                cell.indexI = indexI;
                cell.indexJ = indexJ;
                cell.eductName = this.educts.get(indexI).getID();
                cell.productName = this.products.get(indexJ).getID();
                if (!this.flagMatrix[indexI][indexJ] || cell.eductName.equalsIgnoreCase(cell.productName)) continue;
                this.flagMatrix[indexI.intValue()][indexJ.intValue()] = !this.checkTwinMapping(cell);
            }
        }
    }

    private synchronized boolean checkTwinMapping(Cells refCell) {
        boolean _statusFlag = false;
        for (Cells cell : this.crossMappingTracer) {
            if (!cell.eductName.equals(refCell.eductName) || !cell.productName.equals(refCell.productName) || cell.indexI != refCell.indexI && cell.indexJ != refCell.indexJ) continue;
            _statusFlag = true;
            break;
        }
        if (!_statusFlag) {
            this.crossMappingTracer.add(refCell);
        }
        return _statusFlag;
    }

    private synchronized void resolveDeadLocks(List<Double> scores) {
        boolean[][] deadlockFreeFlagMatrix = new boolean[this.rowSize][this.colSize];
        this.initFlagMatrix(deadlockFreeFlagMatrix, this.rowSize, this.colSize);
        for (Double score : scores) {
            Cells choosenCell = new DeadLockResolver().resolver(score);
            deadlockFreeFlagMatrix[choosenCell.indexI][choosenCell.indexJ] = true;
        }
        this.flagMatrix = deadlockFreeFlagMatrix;
    }

    class DeadLockResolver {
        DeadLockResolver() {
        }

        private synchronized double getMaxStereo(List<Cells> choosenCells) {
            double max = -999.0;
            for (Cells cell : choosenCells) {
                double val = ChooseWinner.this.getStereoMatrix().getValue(cell.indexI, cell.indexJ);
                if (!(val > max)) continue;
                max = val;
            }
            return max;
        }

        private synchronized double getMinEnergy(List<Cells> choosenCells) {
            double min = 999999.0;
            for (Cells cell : choosenCells) {
                double val = ChooseWinner.this.getEnergyMatrix().getValue(cell.indexI, cell.indexJ);
                if (!(val < min)) continue;
                min = val;
            }
            return min;
        }

        public synchronized Cells resolver(double choosenScore) {
            ArrayList<Cells> choosenCells = new ArrayList<Cells>();
            for (int i = 0; i < ChooseWinner.this.rowSize; ++i) {
                for (int j = 0; j < ChooseWinner.this.colSize; ++j) {
                    if (!ChooseWinner.this.flagMatrix[i][j] || !(choosenScore > Double.MIN_VALUE) || ChooseWinner.this.similarityMatrix.getValue(i, j) != choosenScore) continue;
                    Cells cells = new Cells();
                    cells.indexI = i;
                    cells.indexJ = j;
                    choosenCells.add(cells);
                }
            }
            double maxStereo = this.getMaxStereo(choosenCells);
            double minEnergy = this.getMinEnergy(choosenCells);
            for (Cells cell : choosenCells) {
                double stereoVal = ChooseWinner.this.stereoMatrix.getValue(cell.indexI, cell.indexJ);
                double energyVal = ChooseWinner.this.energyMatrix.getValue(cell.indexI, cell.indexJ);
                if (!(stereoVal <= maxStereo) || !(energyVal <= minEnergy)) continue;
                return cell;
            }
            return (Cells)choosenCells.listIterator().next();
        }
    }

    class Cells {
        String eductName;
        String productName;
        int indexI;
        int indexJ;

        Cells() {
        }
    }
}

