/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.ebi.reactionblast.fingerprints.tools.Similarity;
import uk.ac.ebi.reactionblast.mapping.container.HydrogenFreeFingerPrintContainer;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.container.helper.MolMapping;
import uk.ac.ebi.reactionblast.mapping.helper.Debugger;
import uk.ac.ebi.reactionblast.mapping.interfaces.BestMatch;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.tools.EBIMatrix;

public class Holder
extends Debugger
implements Cloneable,
Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 18989786786L;
    private static final Logger LOG = Logger.getLogger(Holder.class.getName());
    private final List<MolMapping> mappingMolPair;
    private final EBIMatrix stereoMatrix;
    private final EBIMatrix cliqueMatrix;
    private final EBIMatrix graphSimilarityMatrix;
    private final EBIMatrix fragmentMatrix;
    private final EBIMatrix energyMatrix;
    private final EBIMatrix fpSimMatrixWithoutHydrogen;
    private final int row;
    private final int coloumn;
    private ReactionContainer structureInformation;
    private BestMatch bestMatchContainer;
    private List<String> eductCounter;
    private List<String> productCounter;
    private String reactionID;
    private HydrogenFreeFingerPrintContainer hydFPFree;
    private IMappingAlgorithm theory;

    public Holder(IMappingAlgorithm theory, String reactionID, List<String> eductCounter, List<String> productCounter, ReactionContainer reactionContainer, BestMatch bestMatchContainer, HydrogenFreeFingerPrintContainer hydFPFree) throws IOException {
        this(eductCounter.size(), productCounter.size());
        this.theory = theory;
        this.reactionID = reactionID;
        this.eductCounter = eductCounter;
        this.productCounter = productCounter;
        this.structureInformation = reactionContainer;
        this.bestMatchContainer = bestMatchContainer;
        this.hydFPFree = hydFPFree;
        this.setFingerprint();
        this.setMolMapping();
    }

    public Holder(int row, int coloumn) {
        this.row = row;
        this.coloumn = coloumn;
        this.graphSimilarityMatrix = new EBIMatrix(row, coloumn);
        this.stereoMatrix = new EBIMatrix(row, coloumn);
        this.cliqueMatrix = new EBIMatrix(row, coloumn);
        this.fragmentMatrix = new EBIMatrix(row, coloumn);
        this.fpSimMatrixWithoutHydrogen = new EBIMatrix(row, coloumn);
        this.energyMatrix = new EBIMatrix(row, coloumn);
        this.mappingMolPair = Collections.synchronizedList(new ArrayList());
        this.initialize();
    }

    public synchronized EBIMatrix getStereoMatrix() {
        return this.stereoMatrix;
    }

    public synchronized EBIMatrix getCliqueMatrix() {
        return this.cliqueMatrix;
    }

    public synchronized EBIMatrix getGraphSimilarityMatrix() {
        return this.graphSimilarityMatrix;
    }

    public synchronized EBIMatrix getFragmentMatrix() {
        return this.fragmentMatrix;
    }

    public synchronized EBIMatrix getEnergyMatrix() {
        return this.energyMatrix;
    }

    private void initialize() {
        this.graphSimilarityMatrix.initMatrix(0.0);
        this.stereoMatrix.initMatrix(0.0);
        this.cliqueMatrix.initMatrix(0.0);
        this.fragmentMatrix.initMatrix(0.0);
        this.fpSimMatrixWithoutHydrogen.initMatrix(0.0);
        this.energyMatrix.initMatrix(0.0);
    }

    private void setFingerprint() {
        for (int i = 0; i < this.eductCounter.size(); ++i) {
            for (int j = 0; j < this.productCounter.size(); ++j) {
                try {
                    String eductName = this.eductCounter.get(i).trim();
                    String productName = this.productCounter.get(j).trim();
                    BitSet hydrogenEductFP = this.hydFPFree.getFingerPrint(eductName);
                    BitSet hydrogenProductFP = this.hydFPFree.getFingerPrint(productName);
                    float hydrogenSimVal = Similarity.getTanimotoSimilarity(hydrogenEductFP, hydrogenProductFP);
                    this.fpSimMatrixWithoutHydrogen.setValue(i, j, hydrogenSimVal);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(Holder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void setMolMapping() {
        for (int i = 0; i < this.eductCounter.size(); ++i) {
            for (int j = 0; j < this.productCounter.size(); ++j) {
                try {
                    String eductName = this.eductCounter.get(i).trim();
                    String productName = this.productCounter.get(j).trim();
                    MolMapping m = new MolMapping(eductName, productName, i, j);
                    this.getMappingMolPair().add(m);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(Holder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public synchronized EBIMatrix getFPSimilarityMatrix() {
        return this.fpSimMatrixWithoutHydrogen;
    }

    public synchronized ReactionContainer getReactionContainer() {
        return this.structureInformation;
    }

    public synchronized List<MolMapping> getMappingMolPair() {
        return this.mappingMolPair;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        Holder mhClone = new Holder(this.row, this.coloumn);
        mhClone.setTheory(this.getTheory());
        double[][] arrayCopy = this.getGraphSimilarityMatrix().getArrayCopy();
        EBIMatrix matrix = mhClone.getGraphSimilarityMatrix();
        this.setData(arrayCopy, matrix, this.row, this.coloumn);
        arrayCopy = this.getFragmentMatrix().getArrayCopy();
        matrix = mhClone.getFragmentMatrix();
        this.setData(arrayCopy, matrix, this.row, this.coloumn);
        arrayCopy = this.getStereoMatrix().getArrayCopy();
        matrix = mhClone.getStereoMatrix();
        this.setData(arrayCopy, matrix, this.row, this.coloumn);
        arrayCopy = this.getCliqueMatrix().getArrayCopy();
        matrix = mhClone.getCliqueMatrix();
        this.setData(arrayCopy, matrix, this.row, this.coloumn);
        arrayCopy = this.getEnergyMatrix().getArrayCopy();
        matrix = mhClone.getEnergyMatrix();
        this.setData(arrayCopy, matrix, this.row, this.coloumn);
        arrayCopy = this.getFPSimilarityMatrix().getArrayCopy();
        matrix = mhClone.getFPSimilarityMatrix();
        this.setData(arrayCopy, matrix, this.row, this.coloumn);
        mhClone.structureInformation = this.getReactionContainer();
        mhClone.bestMatchContainer = this.getBestMatchContainer();
        return mhClone;
    }

    private void setData(double[][] sourceData, EBIMatrix sinkMatrix, int rows, int coloumns) {
        double[][] newDataMatrix = sinkMatrix.getArray();
        for (int i = 0; i < rows; ++i) {
            System.arraycopy(sourceData[i], 0, newDataMatrix[i], 0, coloumns);
        }
    }

    public synchronized BestMatch getBestMatchContainer() {
        return this.bestMatchContainer;
    }

    public IMappingAlgorithm getTheory() {
        return this.theory;
    }

    public void setTheory(IMappingAlgorithm theory) {
        this.theory = theory;
    }
}

