/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.algorithm.BaseGameTheory;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMatrix;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.ChooseWinner;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.ReactionIsomorphismHandler;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.RuleBasedMappingHandler;
import uk.ac.ebi.reactionblast.mapping.algorithm.checks.Selector;
import uk.ac.ebi.reactionblast.mapping.container.MoleculeMoleculeMapping;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.container.helper.MolMapping;
import uk.ac.ebi.reactionblast.mapping.graph.GraphMatching;
import uk.ac.ebi.reactionblast.mapping.interfaces.IGraphMatching;
import uk.ac.ebi.reactionblast.tools.CDKSMILES;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;
import uk.ac.ebi.reactionblast.tools.labelling.SmilesMoleculeLabeller;

final class GameTheoryRings
extends BaseGameTheory {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 1455660878786L;
    private static final Logger LOG = Logger.getLogger(GameTheoryRings.class.getName());
    private final List<String> eductList;
    private final List<String> productList;
    private Holder mh;
    private final ChooseWinner winner;
    private final IReaction reaction;
    private final String RID;
    private final String _dirSuffix;
    private final boolean removeHydrogen;
    private MoleculeMoleculeMapping reactionMolMapping = null;
    private Map<Integer, IAtomContainer> educts = null;
    private Map<Integer, IAtomContainer> products = null;
    private int delta = 0;
    private Integer stepIndex = 0;
    private final ICanonicalMoleculeLabeller canonLabeler = new SmilesMoleculeLabeller();

    GameTheoryRings(IReaction reaction, boolean removeHydrogen, Map<Integer, IAtomContainer> _educts, Map<Integer, IAtomContainer> _products, GameTheoryMatrix rpsh) throws Exception {
        this.removeHydrogen = removeHydrogen;
        this.reaction = reaction;
        this.educts = _educts;
        this.products = _products;
        this.RID = reaction.getID();
        this.eductList = Collections.synchronizedList(rpsh.getEductCounter());
        this.productList = Collections.synchronizedList(rpsh.getProductCounter());
        this.mh = rpsh.getMatrixHolder();
        this.setReactionMolMapping(rpsh.getReactionMolMapping());
        this.winner = new ChooseWinner(this.eductList, this.productList);
        this._dirSuffix = this.getSuffix();
        ReactionIsomorphismHandler RIH = new ReactionIsomorphismHandler(this.mh, this.eductList, this.productList);
        if (RIH.getIsomorphismFlag()) {
            this.mh = RIH.getMatrixHolder();
            this.GenerateIsoMorphismMapping();
        } else {
            this.GenerateMapping();
        }
    }

    private synchronized void GenerateIsoMorphismMapping() throws Exception {
        RuleBasedMappingHandler ph = new RuleBasedMappingHandler(this.mh, this.eductList, this.productList);
        if (ph.isMatchFound()) {
            this.mh = ph.getMatrixHolder();
        }
        this.winner.searchWinners(this.educts, this.products, this.mh);
        if (this.winner.getFlag()) {
            this.UpdateMapping();
            this.UpdateMatrix(this.mh, this.removeHydrogen);
            this.GenerateMapping();
        }
    }

    private synchronized void GenerateMapping() throws Exception {
        RuleBasedMappingHandler ruleBasedMappingHandler = new RuleBasedMappingHandler(this.mh, this.eductList, this.productList);
        if (ruleBasedMappingHandler.isMatchFound()) {
            this.mh = Selector.modifyMatrix(ruleBasedMappingHandler.getMatrixHolder());
        }
        this.winner.searchWinners(this.educts, this.products, this.mh);
        if (this.winner.getFlag()) {
            this.UpdateMapping();
            this.UpdateMatrix(this.mh, this.removeHydrogen);
            this.GenerateMapping();
        }
    }

    private synchronized void UpdateMapping() throws Exception {
        boolean[][] FlagMatrix = this.winner.getFlagMatrix();
        ReactionContainer reactionStructureInformationContainer = this.mh.getReactionContainer();
        for (int iIndex = 0; iIndex < reactionStructureInformationContainer.getEductCount(); ++iIndex) {
            for (int jIndex = 0; jIndex < reactionStructureInformationContainer.getProductCount(); ++jIndex) {
                int substrateIndex = iIndex;
                int productIndex = jIndex;
                IAtomContainer ac1 = reactionStructureInformationContainer.getEduct(substrateIndex);
                IAtomContainer ac2 = reactionStructureInformationContainer.getProduct(productIndex);
                if (!FlagMatrix[substrateIndex][productIndex]) continue;
                BitSet A = reactionStructureInformationContainer.getFingerPrintofEduct(substrateIndex);
                BitSet B = reactionStructureInformationContainer.getFingerPrintofProduct(productIndex);
                ac1.setID(this.eductList.get(substrateIndex));
                ac2.setID(this.productList.get(productIndex));
                GraphMatching GM = new GraphMatching(this.RID, ac1, ac2, this._dirSuffix, this.removeHydrogen);
                boolean mcsMatch = ((IGraphMatching)GM).mcsMatch(this.mh, this.removeHydrogen, substrateIndex, productIndex, A, B);
                if (mcsMatch) {
                    this.delta += ((IGraphMatching)GM).removeMatchedAtomsAndUpdateAAM(this.reaction);
                    List<MolMapping> rMap = this.getReactionMolMapping().getMapping(this.RID, this.eductList.get(substrateIndex), this.productList.get(productIndex));
                    for (MolMapping map : rMap) {
                        map.setReactionMapping(true);
                        IAtomContainer mol = ((IGraphMatching)GM).getMatchedPart();
                        mol = this.canonLabeler.getCanonicalMolecule(mol);
                        CDKSMILES cdkSmiles = new CDKSMILES(mol, true, false);
                        this.stepIndex = this.stepIndex + 1;
                        map.setMatchedSMILES(cdkSmiles.getCanonicalSMILES(), this.stepIndex);
                    }
                }
                IAtomContainer remainingEduct = ((IGraphMatching)GM).getRemainingEduct();
                IAtomContainer remainingProduct = ((IGraphMatching)GM).getRemainingProduct();
                reactionStructureInformationContainer.putEduct(substrateIndex, remainingEduct);
                reactionStructureInformationContainer.putProduct(productIndex, remainingProduct);
                reactionStructureInformationContainer.setEductModified(substrateIndex, true);
                reactionStructureInformationContainer.setProductModified(productIndex, true);
            }
        }
    }

    @Override
    public synchronized MoleculeMoleculeMapping getReactionMolMapping() {
        return this.reactionMolMapping;
    }

    @Override
    public synchronized void setReactionMolMapping(MoleculeMoleculeMapping reactionMolMapping) {
        this.reactionMolMapping = reactionMolMapping;
    }

    @Override
    public synchronized int getDelta() {
        return this.delta;
    }
}

