/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.mapping.algorithm.BaseGameTheory;
import uk.ac.ebi.reactionblast.mapping.algorithm.Holder;
import uk.ac.ebi.reactionblast.mapping.container.BestMatchContainer;
import uk.ac.ebi.reactionblast.mapping.container.HydrogenFreeFingerPrintContainer;
import uk.ac.ebi.reactionblast.mapping.container.MoleculeMoleculeMapping;
import uk.ac.ebi.reactionblast.mapping.container.ReactionContainer;
import uk.ac.ebi.reactionblast.mapping.interfaces.BestMatch;
import uk.ac.ebi.reactionblast.mapping.interfaces.IGraphTheoryMatrix;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.tools.AtomContainerSetComparator;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public class GameTheoryMatrix
extends BaseGameTheory
implements IGraphTheoryMatrix {
    private static final long serialVersionUID = 189888888786L;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(GameTheoryMatrix.class);
    private static final Logger LOG = Logger.getLogger(GameTheoryMatrix.class.getName());
    private Holder matrixHolder;
    private MoleculeMoleculeMapping reactionBlastMolMapping;
    private final List<String> eductCounter;
    private final List<String> productCounter;
    private final IReaction reaction;
    private final Map<Integer, BitSet> substrateductFPMap;
    private final Map<Integer, BitSet> productFPMap;
    private final FingerprintGenerator fpr;
    private final HydrogenFreeFingerPrintContainer hydFreeFPContainer;
    private final boolean removeHydrogen;
    private final String reactionID;
    private final ReactionContainer structureMapObj;
    private final BestMatch bestMatchContainer;
    private final IMappingAlgorithm theory;

    public GameTheoryMatrix(IMappingAlgorithm theory, IReaction reaction, boolean removeHydrogen) throws Exception {
        this.theory = theory;
        this.removeHydrogen = removeHydrogen;
        this.reaction = reaction;
        this.reactionID = reaction.getID();
        this.substrateductFPMap = Collections.synchronizedSortedMap(new TreeMap());
        this.productFPMap = Collections.synchronizedSortedMap(new TreeMap());
        this.fpr = new FingerprintGenerator();
        this.eductCounter = Collections.synchronizedList(new LinkedList());
        this.productCounter = Collections.synchronizedList(new LinkedList());
        this.structureMapObj = new ReactionContainer();
        this.bestMatchContainer = new BestMatchContainer();
        this.hydFreeFPContainer = new HydrogenFreeFingerPrintContainer();
        this.reactionBlastMolMapping = new MoleculeMoleculeMapping();
        try {
            this.StoichiometricCoefficientReplicator_Structure_FingerPrint_MapGenerator();
            this.BuildScoringMatrix();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private synchronized void BuildScoringMatrix() throws Exception {
        try {
            this.matrixHolder = new Holder(this.theory, this.reactionID, this.eductCounter, this.productCounter, this.structureMapObj, this.bestMatchContainer, this.hydFreeFPContainer);
            this.reactionBlastMolMapping.setMolMappings(this.reactionID, this.matrixHolder.getMappingMolPair());
            this.UpdateMatrix(this.matrixHolder, this.removeHydrogen);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    @Override
    public synchronized void Clear() throws IOException {
        this.structureMapObj.Clear();
        this.hydFreeFPContainer.Clear();
    }

    @Override
    public synchronized List<String> getEductCounter() {
        return Collections.unmodifiableList(this.eductCounter);
    }

    @Override
    public synchronized List<String> getProductCounter() {
        return Collections.unmodifiableList(this.productCounter);
    }

    private synchronized void StoichiometricCoefficientReplicator_Structure_FingerPrint_MapGenerator() {
        IAtomContainer tempMol;
        IAtomContainer mol;
        int key;
        LinkedList<IAtomContainer> ac = new LinkedList<IAtomContainer>();
        LinkedList<IAtomContainer> pd = new LinkedList<IAtomContainer>();
        this.sortAtomContainer(ac, pd);
        for (key = 0; key < ac.size(); ++key) {
            try {
                BitSet FP2;
                mol = ((IAtomContainer)ac.get(key)).clone();
                String eductID = ((IAtomContainer)ac.get(key)).getID().trim();
                mol.setID(eductID);
                if (this.hydFreeFPContainer.isKeyPresent(eductID)) {
                    FP2 = this.hydFreeFPContainer.getFingerPrint(eductID);
                } else if (mol.getAtomCount() > 0) {
                    tempMol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
                    FP2 = this.fpr.getFingerprint(tempMol);
                } else {
                    FP2 = new BitSet(FingerprintGenerator.getFingerprinterSize());
                }
                this.hydFreeFPContainer.setValue(eductID, FP2);
                this.eductCounter.add(key, eductID);
                this.structureMapObj.putEduct(key, mol);
                this.structureMapObj.setEductModified(key, true);
                this.substrateductFPMap.put(key, FP2);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(GameTheoryMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        for (key = 0; key < pd.size(); ++key) {
            try {
                BitSet fingerPrint;
                mol = ((IAtomContainer)pd.get(key)).clone();
                String productID = ((IAtomContainer)pd.get(key)).getID().trim();
                mol.setID(productID);
                if (this.hydFreeFPContainer.isKeyPresent(productID)) {
                    fingerPrint = this.hydFreeFPContainer.getFingerPrint(productID);
                } else if (mol.getAtomCount() > 0) {
                    tempMol = ExtAtomContainerManipulator.removeHydrogensExceptSingleAndPreserveAtomID(mol);
                    fingerPrint = this.fpr.getFingerprint(tempMol);
                } else {
                    fingerPrint = new BitSet(FingerprintGenerator.getFingerprinterSize());
                }
                this.hydFreeFPContainer.setValue(productID, fingerPrint);
                this.productCounter.add(key, productID);
                this.structureMapObj.putProduct(key, mol);
                this.structureMapObj.setProductModified(key, true);
                this.productFPMap.put(key, fingerPrint);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(GameTheoryMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public synchronized Holder getMatrixHolder() {
        return this.matrixHolder;
    }

    @Override
    public synchronized MoleculeMoleculeMapping getReactionMolMapping() {
        return this.reactionBlastMolMapping;
    }

    private synchronized void sortAtomContainer(List<IAtomContainer> ac, List<IAtomContainer> pd) {
        for (IAtomContainer e : this.reaction.getReactants().atomContainers()) {
            ac.add(e);
        }
        for (IAtomContainer p : this.reaction.getProducts().atomContainers()) {
            pd.add(p);
        }
        try {
            AtomContainerSetComparator comparator = new AtomContainerSetComparator();
            Collections.sort(ac, comparator);
            Collections.sort(pd, comparator);
        }
        catch (Exception e) {
            logger.debug("ERROR: in AtomMappingTool: " + e.getMessage());
        }
    }

    @Override
    public synchronized int getDelta() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void setReactionMolMapping(MoleculeMoleculeMapping reactionMolMapping) {
        this.reactionBlastMolMapping = reactionMolMapping;
    }
}

