/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.io.filesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.interfaces.IDataStore;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000RXNWriter;

public class FilesystemReactionDataStore
implements IDataStore<IReaction> {
    private static final Logger LOG = Logger.getLogger(FilesystemReactionDataStore.class.getName());
    private File reactionDir;
    private MDLV2000RXNWriter rxnWriter;

    public FilesystemReactionDataStore(String reactionPath) {
        if (reactionPath != null) {
            this.reactionDir = new File(reactionPath);
            if (!this.reactionDir.exists()) {
                this.reactionDir.mkdir();
            }
            this.rxnWriter = new MDLV2000RXNWriter();
        }
    }

    @Override
    public void store(IReaction reaction) {
        String id = reaction.getID();
        File file = new File(this.reactionDir, id + ".rxn");
        try {
            FileWriter writer = new FileWriter(file);
            this.rxnWriter = new MDLV2000RXNWriter(writer);
            this.rxnWriter.write(reaction);
            this.rxnWriter.close();
        }
        catch (IOException | CDKException e) {
            e.printStackTrace();
        }
    }
}

