/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.io.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.io.MDLV2000Reader;
import uk.ac.ebi.reactionblast.interfaces.IDataSource;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;

public class FilesystemMoleculeDataSource
implements IDataSource<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(FilesystemMoleculeDataSource.class.getName());
    private File moleculeDir;
    private MDLV2000Reader molReader;
    private ITransformation<IAtomContainer> transformation;

    public FilesystemMoleculeDataSource(String moleculePath) {
        if (moleculePath != null) {
            this.moleculeDir = new File(moleculePath);
            this.molReader = new MDLV2000Reader();
        }
    }

    @Override
    public void setTransformation(ITransformation<IAtomContainer> transformation) {
        this.transformation = transformation;
    }

    @Override
    public IAtomContainer get(String id) {
        File molFile = new File(this.moleculeDir, id + ".mol");
        try {
            this.molReader.setReader(new FileReader(molFile));
            IAtomContainer mol = this.molReader.read(new AtomContainer());
            if (this.transformation == null) {
                return mol;
            }
            return this.transformation.transform(mol);
        }
        catch (FileNotFoundException | CDKException c) {
            return null;
        }
    }

    @Override
    public Iterable<IAtomContainer> getAll() {
        final String[] fileNames = this.moleculeDir.list();
        final int numberOfReactions = fileNames.length;
        return new Iterable<IAtomContainer>(){

            @Override
            public Iterator<IAtomContainer> iterator() {
                return new Iterator<IAtomContainer>(){
                    private int currentIndex;

                    @Override
                    public boolean hasNext() {
                        return this.currentIndex < numberOfReactions;
                    }

                    @Override
                    public IAtomContainer next() {
                        String filename = fileNames[this.currentIndex];
                        File molFile = new File(FilesystemMoleculeDataSource.this.moleculeDir, filename);
                        ++this.currentIndex;
                        try {
                            IAtomContainer mol;
                            try (FileReader reader = new FileReader(molFile);){
                                FilesystemMoleculeDataSource.this.molReader.setReader(reader);
                                mol = FilesystemMoleculeDataSource.this.molReader.read(new AtomContainer());
                                mol.setID(filename.substring(0, filename.indexOf(46)));
                            }
                            if (FilesystemMoleculeDataSource.this.transformation == null) {
                                return mol;
                            }
                            return FilesystemMoleculeDataSource.this.transformation.transform(mol);
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            return null;
                        }
                        catch (IOException | CDKException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public List<String> getIDList() {
        ArrayList<String> ids = new ArrayList<String>();
        for (String filename : this.moleculeDir.list()) {
            ids.add(filename.substring(0, filename.indexOf(46)));
        }
        return ids;
    }

    @Override
    public void close() {
        try {
            this.molReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

