/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.Axis;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class LeftToRightReactionLayout
extends AbstractDirectReactionLayout {
    private static final Logger LOG = Logger.getLogger(LeftToRightReactionLayout.class.getName());

    public LeftToRightReactionLayout() {
        this(true);
    }

    public LeftToRightReactionLayout(boolean shouldLayout) {
        this(shouldLayout, new Vector2d(0.0, 1.0));
    }

    public LeftToRightReactionLayout(boolean shouldLayout, Vector2d moleculeAxis) {
        super(shouldLayout, moleculeAxis);
        this.arrowAxis = Axis.X;
    }

    @Override
    public BoundsTree layout(IReaction reaction, Vector2d axis) {
        double arrowCenterX;
        IAtomContainerSet reactants = reaction.getReactants();
        reactants.setID("r");
        this.reactantBoundsTree = this.reactantLayout.layout(reactants, axis);
        IAtomContainerSet products = reaction.getProducts();
        products.setID("p");
        this.productBoundsTree = this.productLayout.layout(products, axis);
        int borderX = this.params.borderX;
        int borderY = this.params.borderY;
        int arrowGap = this.params.arrowGap;
        int arrowLength = this.params.arrowLength;
        double rbH = this.reactantBoundsTree.getHeight();
        double pbH = this.productBoundsTree.getHeight();
        double rbW = this.reactantBoundsTree.getWidth();
        double maxH = Math.max(rbH, pbH);
        double dx = borderX;
        double dy = (double)borderY + maxH / 2.0;
        this.shiftMoleculeSet(reaction.getReactants(), this.reactantBoundsTree, dx, dy);
        dx = (double)borderX + rbW + (double)arrowLength + (double)(2 * arrowGap);
        this.shiftMoleculeSet(reaction.getProducts(), this.productBoundsTree, dx, dy);
        this.boundsTree = new BoundsTree(reaction.getID(), this.productBoundsTree, this.reactantBoundsTree);
        this.arrowPos = arrowCenterX = (double)borderX + rbW + (double)arrowGap + (double)(arrowLength / 2);
        return this.boundsTree;
    }

    @Override
    public Vector2d getAxis() {
        return new Vector2d(1.0, 0.0);
    }

    @Override
    public double getAxisPosition() {
        return this.boundsTree.getHeight() / 2.0 + (double)this.params.borderY;
    }
}

