/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.awtlayout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.MoleculeLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;

public class ZoomToFitAWTLayout
extends AbstractDirectLayout<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(ZoomToFitAWTLayout.class.getName());
    private final DirectMoleculeDrawer drawer;

    public ZoomToFitAWTLayout(DirectMoleculeDrawer drawer) {
        this.drawer = drawer;
        super.setParams(drawer.getParams());
    }

    public void layout(IAtomContainer mol, Dimension cellCanvas, Graphics2D g) {
        double centerY;
        AffineTransform originalTransform = g.getTransform();
        double cW = cellCanvas.width;
        double cH = cellCanvas.height;
        if (this.shouldInvert) {
            super.invert(mol);
        }
        BoundsTree tree = this.getBoundsTree(mol, g);
        double tW = tree.getWidth();
        double tH = tree.getHeight();
        Rectangle2D stringBounds = null;
        String label = mol.getID();
        Font labelFont = new Font(this.params.labelPanelFont, 0, this.params.labelPanelFontSize);
        if (this.params.drawLabelPanel) {
            g.setFont(labelFont);
            FontMetrics metrics = g.getFontMetrics();
            stringBounds = metrics.getStringBounds(label, g);
            double labelHeight = stringBounds.getHeight();
            cH += labelHeight;
        }
        double zoom = this.calculateZoom(tW, tH, cW, cH);
        double centerX = cW / 2.0;
        Params params = this.drawer.getParams();
        if (params.drawMoleculeID) {
            centerY = cH / 2.0 - params.labelYGap;
        } else if (params.drawLabelPanel) {
            double labelHeight = stringBounds.getHeight();
            double scaledLabelHeight = labelHeight / 2.0 * (1.0 / zoom);
            centerY = (double)cellCanvas.height / 2.0 - scaledLabelHeight;
        } else {
            centerY = cH / 2.0;
        }
        g.translate(centerX, centerY);
        g.scale(zoom, zoom);
        this.drawer.drawMolecule(mol, g);
        g.setTransform(originalTransform);
        if (params.drawLabelPanel) {
            double cX = cW / 2.0;
            double cY = cH / 2.0;
            g.setFont(labelFont);
            FontMetrics metrics = g.getFontMetrics();
            double halfWidth = stringBounds.getWidth() / 2.0;
            double halfHeight = stringBounds.getHeight() / 2.0;
            double halfScaledTreeWidth = tH * zoom / 2.0;
            double lY = cY + halfScaledTreeWidth - (double)params.borderY;
            double ascent = metrics.getAscent();
            float x = (float)(cX - halfWidth);
            float y = (float)(lY - halfHeight + ascent);
            g.setColor(Color.BLACK);
            g.drawString(label, x, y);
        }
    }

    private BoundsTree getBoundsTree(IAtomContainer mol, Graphics2D g) {
        Rectangle2D bb = GeometryTools.getRectangle2D(mol);
        GeometryTools.translate2D(mol, -bb.getCenterX(), -bb.getCenterY());
        GeometryTools.scaleMolecule(mol, GeometryTools.getScaleFactor(mol, this.params.bondLength));
        MoleculeLayout exactLayout = new MoleculeLayout(this.params);
        return exactLayout.layout(mol, g);
    }

    private double calculateZoom(double tw, double th, double cw, double ch) {
        Params params = this.drawer.getParams();
        double borderX = params.borderX;
        double borderY = params.borderY;
        double rW = tw + borderX * 2.0;
        double rH = th + borderY * 2.0;
        return Math.min(cw / rW, ch / rH);
    }

    @Override
    public BoundsTree layout(IAtomContainer obj, Vector2d axis) {
        return null;
    }

    @Override
    public Vector2d getAxis() {
        return null;
    }

    @Override
    public double getAxisPosition() {
        return 0.0;
    }
}

