/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.graph;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.ebi.centres.ConnectionTable;

public class BasicConnectionTable<A>
implements ConnectionTable<A> {
    private static final Logger LOG = Logger.getLogger(BasicConnectionTable.class.getName());
    private final Map<A, Map<A, Map.Entry<Integer, Integer>>> connections = new HashMap<A, Map<A, Map.Entry<Integer, Integer>>>();
    private final Map<A, Map<A, Map.Entry<Integer, Integer>>> stereo = new HashMap<A, Map<A, Map.Entry<Integer, Integer>>>();

    public void addConnection(A first, A second, int order) {
        this.addConnection(first, second, order, 0);
    }

    public void addConnection(A first, A second, int order, int sign) {
        this.newConnection(first, second, order, sign >= 1 ? 1 : (sign <= -1 ? -1 : 0));
        this.newConnection(second, first, order, sign >= 1 ? -1 : (sign <= -1 ? 1 : 0));
    }

    private void newConnection(A first, A second, int order, int sign) {
        if (!this.connections.containsKey(first)) {
            this.connections.put(first, new HashMap());
        }
        this.connections.get(first).put(second, new AbstractMap.SimpleEntry<Integer, Integer>(order, sign));
    }

    @Override
    public Collection<A> getConnected(A atom) {
        return this.connections.get(atom).keySet();
    }

    @Override
    public int getOrder(A first, A second) {
        return this.connections.get(first).get(second).getKey();
    }

    @Override
    public Integer getDepth(A first, A second) {
        return this.connections.get(first).get(second).getValue();
    }

    @Override
    public Integer getAtomCount() {
        return this.connections.keySet().size();
    }
}

