/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.cdk;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import uk.ac.ebi.centres.graph.BasicConnectionTable;

public class CDKConnectionTable
extends BasicConnectionTable<IAtom> {
    private static final Map<IBond.Order, Integer> orders = Maps.newHashMapWithExpectedSize(4);
    private static final Map<IBond.Stereo, Integer> depths = Maps.newHashMapWithExpectedSize(4);
    private static final Logger LOG = Logger.getLogger(CDKConnectionTable.class.getName());

    public CDKConnectionTable(IAtomContainer container) {
        for (int i = 0; i < container.getAtomCount(); ++i) {
            container.getAtom(i).setProperty("number", i + 1);
        }
        for (IBond bond : container.bonds()) {
            this.addConnection(bond.getAtom(0), bond.getAtom(1), this.getOrder(bond.getOrder()), this.getDepth(bond.getStereo()));
        }
    }

    private int getOrder(IBond.Order order) {
        Integer value = orders.get((Object)order);
        return value != null ? value : 0;
    }

    private int getDepth(IBond.Stereo stereo) {
        Integer value = depths.get((Object)stereo);
        return value != null ? value : 0;
    }

    static {
        orders.put(IBond.Order.SINGLE, 1);
        orders.put(IBond.Order.DOUBLE, 2);
        orders.put(IBond.Order.TRIPLE, 3);
        orders.put(IBond.Order.QUADRUPLE, 4);
        depths.put(IBond.Stereo.UP, -1);
        depths.put(IBond.Stereo.DOWN, 1);
        depths.put(IBond.Stereo.UP_INVERTED, 1);
        depths.put(IBond.Stereo.DOWN_INVERTED, -1);
    }
}

