/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres;

import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.SignCalculator;

public abstract class Abstract2DSignCalculator<A>
implements SignCalculator<A> {
    @Override
    public int getSign(Ligand<A> a1, Ligand<A> a2, Ligand<A> a3, Ligand<A> a4) {
        if (a1.getDepth() == 0 && a2.getDepth() == 0 && a3.getDepth() == 0 && a4.getDepth() == 0) {
            return 0;
        }
        double[][] matrix = new double[][]{{this.getX(a1.getAtom()), this.getY(a1.getAtom()), 1.0, a1.getDepth()}, {this.getX(a2.getAtom()), this.getY(a2.getAtom()), 1.0, a2.getDepth()}, {this.getX(a3.getAtom()), this.getY(a3.getAtom()), 1.0, a3.getDepth()}, {this.getX(a4.getAtom()), this.getY(a4.getAtom()), 1.0, a4.getDepth()}};
        return (int)Math.abs(this.determinant(matrix));
    }

    @Override
    public int getSign(A a1, A a2, A a3) {
        double[][] matrix = new double[][]{{this.getX(a1), this.getY(a1), 1.0}, {this.getX(a2), this.getY(a2), 1.0}, {this.getX(a3), this.getY(a3), 1.0}};
        return (int)Math.signum(this.determinant(matrix));
    }

    public abstract double getX(A var1);

    public abstract double getY(A var1);

    private double determinant(double[][] arr) {
        double result = 0.0;
        if (arr.length == 1) {
            result = arr[0][0];
            return result;
        }
        if (arr.length == 2) {
            result = arr[0][0] * arr[1][1] - arr[0][1] * arr[1][0];
            return result;
        }
        for (int i = 0; i < arr[0].length; ++i) {
            double[][] temp = new double[arr.length - 1][arr[0].length - 1];
            for (int j = 1; j < arr.length; ++j) {
                for (int k = 0; k < arr[0].length; ++k) {
                    if (k < i) {
                        temp[j - 1][k] = arr[j][k];
                        continue;
                    }
                    if (k <= i) continue;
                    temp[j - 1][k - 1] = arr[j][k];
                }
            }
            result += arr[0][i] * Math.pow(-1.0, i) * this.determinant(temp);
        }
        return result;
    }
}

