/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool.rgroup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import uk.ac.ebi.aamtool.rgroup.MultiReactionContainer;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;

public class ECRgroupFrequency {
    protected static final boolean DEBUG = false;
    private static final Logger LOG = Logger.getLogger(ECRgroupFrequency.class.getName());

    public static void main(String[] args) {
        ECRgroupFrequency ecRgroupFrequency = new ECRgroupFrequency(args);
    }

    public ECRgroupFrequency(String[] args) {
        System.out.println("------------------------------------------------------");
        TreeMap<String, Object> reactionMap = new TreeMap<String, Object>();
        for (String dir : args) {
            File[] files;
            File f = new File(dir);
            if (!f.isDirectory()) continue;
            for (File ec : files = f.listFiles()) {
                File[] listReactionFiles;
                String ecNumber = ec.getName();
                if (!ec.isDirectory()) continue;
                for (File reactionFile : listReactionFiles = ec.listFiles()) {
                    String reactionName = reactionFile.getName().split("\\.")[0];
                    try {
                        MDLRXNV2000Reader mdlrxnV2000Reader = new MDLRXNV2000Reader(new FileReader(reactionFile));
                        Reaction reaction = mdlrxnV2000Reader.read(new Reaction());
                        mdlrxnV2000Reader.close();
                        if (reactionMap.containsKey(ecNumber)) {
                            ((MultiReactionContainer)reactionMap.get(ecNumber)).addReaction(reaction, reactionName);
                            continue;
                        }
                        MultiReactionContainer r = new MultiReactionContainer(ecNumber);
                        r.addReaction(reaction, reactionName);
                        reactionMap.put(ecNumber, r);
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(ECRgroupFrequency.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException | CDKException ex) {
                        Logger.getLogger(ECRgroupFrequency.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        int ec1Counter = 0;
        int ec2Counter = 0;
        int ec3Counter = 0;
        int ec4Counter = 0;
        int ec5Counter = 0;
        int ec6Counter = 0;
        int ec1_RGroupReactionCounter = 0;
        int ec2_RGroupReactionCounter = 0;
        int ec3_RGroupReactionCounter = 0;
        int ec4_RGroupReactionCounter = 0;
        int ec5_RGroupReactionCounter = 0;
        int ec6_RGroupReactionCounter = 0;
        int no_common_fragment_in_non_r_group = 0;
        int no_common_fragment_in_r_group = 0;
        int no_common_fragment_in_either = 0;
        TreeMap<String, Set<String>> commonCommonMap = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> commonDifferenceMap = new TreeMap<String, Set<String>>();
        TreeMap<String, Set<String>> commonUnionMap = new TreeMap<String, Set<String>>();
        TreeSet<String> r_group_ec = new TreeSet<String>();
        block22: for (String ec : reactionMap.keySet()) {
            String ec3;
            if (((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) {
                r_group_ec.add(ec);
            }
            if (((MultiReactionContainer)reactionMap.get(ec)).getCommonCommonFP().isEmpty() && ((MultiReactionContainer)reactionMap.get(ec)).getCommonDifferenceFP().isEmpty() && !((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) {
                ++no_common_fragment_in_non_r_group;
            }
            if (((MultiReactionContainer)reactionMap.get(ec)).getCommonCommonFP().isEmpty() && ((MultiReactionContainer)reactionMap.get(ec)).getCommonDifferenceFP().isEmpty() && ((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) {
                ++no_common_fragment_in_r_group;
            }
            if (((MultiReactionContainer)reactionMap.get(ec)).getCommonCommonFP().isEmpty() && ((MultiReactionContainer)reactionMap.get(ec)).getCommonDifferenceFP().isEmpty()) {
                ++no_common_fragment_in_either;
            }
            if (!commonCommonMap.containsKey(ec3 = ((MultiReactionContainer)reactionMap.get(ec)).getEnzyme1Level() + "." + ((MultiReactionContainer)reactionMap.get(ec)).getEnzyme2Level() + "." + ((MultiReactionContainer)reactionMap.get(ec)).getEnzyme3Level())) {
                commonCommonMap.put(ec3, ((MultiReactionContainer)reactionMap.get(ec)).getCommonCommonFP());
            } else if (commonCommonMap.containsKey(ec3)) {
                ((Set)commonCommonMap.get(ec3)).retainAll(((MultiReactionContainer)reactionMap.get(ec)).getCommonCommonFP());
            }
            if (!commonDifferenceMap.containsKey(ec3)) {
                commonDifferenceMap.put(ec3, ((MultiReactionContainer)reactionMap.get(ec)).getCommonDifferenceFP());
            } else if (commonDifferenceMap.containsKey(ec3)) {
                ((Set)commonDifferenceMap.get(ec3)).retainAll(((MultiReactionContainer)reactionMap.get(ec)).getCommonDifferenceFP());
            }
            if (!commonUnionMap.containsKey(ec3)) {
                commonUnionMap.put(ec3, ((MultiReactionContainer)reactionMap.get(ec)).getAllFP());
            } else if (commonUnionMap.containsKey(ec3)) {
                ((Set)commonUnionMap.get(ec3)).retainAll(((MultiReactionContainer)reactionMap.get(ec)).getAllFP());
            }
            switch (((MultiReactionContainer)reactionMap.get(ec)).getEnzyme1Level()) {
                case "1": {
                    ++ec1Counter;
                    if (!((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) continue block22;
                    ++ec1_RGroupReactionCounter;
                    continue block22;
                }
                case "2": {
                    ++ec2Counter;
                    if (!((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) continue block22;
                    ++ec2_RGroupReactionCounter;
                    continue block22;
                }
                case "3": {
                    ++ec3Counter;
                    if (!((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) continue block22;
                    ++ec3_RGroupReactionCounter;
                    continue block22;
                }
                case "4": {
                    ++ec4Counter;
                    if (!((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) continue block22;
                    ++ec4_RGroupReactionCounter;
                    continue block22;
                }
                case "5": {
                    ++ec5Counter;
                    if (!((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) continue block22;
                    ++ec5_RGroupReactionCounter;
                    continue block22;
                }
                case "6": {
                    ++ec6Counter;
                    if (!((MultiReactionContainer)reactionMap.get(ec)).isRGroup()) continue block22;
                    ++ec6_RGroupReactionCounter;
                    continue block22;
                }
            }
            System.out.println("UNKNOW EC CLASS");
        }
        int total_EC = ec1Counter + ec2Counter + ec3Counter + ec4Counter + ec5Counter + ec6Counter;
        int total_r_group_counter = ec1_RGroupReactionCounter + ec2_RGroupReactionCounter + ec3_RGroupReactionCounter + ec4_RGroupReactionCounter + ec5_RGroupReactionCounter + ec6_RGroupReactionCounter;
        System.out.println("------------------------------------------------------");
        System.out.println("R-group EC numbers");
        System.out.println(r_group_ec);
        System.out.println("------------------------------------------------------");
        System.out.println("# EC 1 Numbers " + ec1Counter);
        System.out.println("# R-Group EC 1 Numbers " + ec1_RGroupReactionCounter);
        System.out.println("# EC 2 Numbers " + ec2Counter);
        System.out.println("# R-Group EC 2 Numbers " + ec2_RGroupReactionCounter);
        System.out.println("# EC 3 Numbers " + ec3Counter);
        System.out.println("# R-Group EC 3 Numbers " + ec3_RGroupReactionCounter);
        System.out.println("# EC 4 Numbers " + ec4Counter);
        System.out.println("# R-Group EC 4 Numbers " + ec4_RGroupReactionCounter);
        System.out.println("# EC 5 Numbers " + ec5Counter);
        System.out.println("# R-Group EC 5 Numbers " + ec5_RGroupReactionCounter);
        System.out.println("# EC 6 Numbers " + ec6Counter);
        System.out.println("# R-Group EC 6 Numbers " + ec6_RGroupReactionCounter);
        System.out.println("# EC Numbers " + total_EC);
        System.out.println("# R-Group EC Numbers " + total_r_group_counter);
        System.out.println("# EC with No Common Fragment in Non R-Groups " + no_common_fragment_in_non_r_group);
        System.out.println("# EC with No Common Fragment in R-Groups " + no_common_fragment_in_r_group);
        System.out.println("# EC with No Common Fragment in Either R-Groups " + no_common_fragment_in_either);
        System.out.println("------------------------------------------------------");
        int empty_signature = 0;
        int one_signature_common = 0;
        int more_than_one_signature_common = 0;
        int empty_union_common = 0;
        int one_union_common = 0;
        int more_than_one_union_common = 0;
        for (String ec : commonCommonMap.keySet()) {
            int size;
            if (((Set)commonCommonMap.get(ec)).isEmpty() && ((Set)commonDifferenceMap.get(ec)).isEmpty()) {
                ++empty_signature;
            } else if (!((Set)commonCommonMap.get(ec)).isEmpty() || !((Set)commonDifferenceMap.get(ec)).isEmpty()) {
                size = ((Set)commonCommonMap.get(ec)).size() + ((Set)commonDifferenceMap.get(ec)).size();
                if (size == 1) {
                    ++one_signature_common;
                } else if (size > 1) {
                    ++more_than_one_signature_common;
                }
            }
            if (((Set)commonUnionMap.get(ec)).isEmpty()) {
                ++empty_union_common;
                continue;
            }
            if (((Set)commonUnionMap.get(ec)).isEmpty()) continue;
            size = ((Set)commonUnionMap.get(ec)).size();
            if (size == 1) {
                ++one_union_common;
                continue;
            }
            if (size <= 1) continue;
            ++more_than_one_union_common;
        }
        System.out.println("------------------------------------------------------");
        System.out.println("# 3rd level EC Count " + commonCommonMap.size());
        System.out.println("# 3rd level EC with No Common Fragment " + empty_signature);
        System.out.println("# 3rd level EC with One Common Fragment " + one_signature_common);
        System.out.println("# 3rd level EC with more than One Common Fragment " + more_than_one_signature_common);
        System.out.println("# 3rd level EC Count " + commonUnionMap.size());
        System.out.println("# 3rd level EC with No Common Union Fragment " + empty_union_common);
        System.out.println("# 3rd level EC with One Common Union Fragment " + one_union_common);
        System.out.println("# 3rd level EC with more than One Common Union Fragment " + more_than_one_union_common);
        System.out.println("------------------------------------------------------");
    }
}

