/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.aamtool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.ebi.aamtool.Helper;
import uk.ac.ebi.aamtool.SimilarityResult;
import uk.ac.ebi.reactionblast.fingerprints.PatternFingerprinter;
import uk.ac.ebi.reactionblast.fingerprints.ReactionFingerprinter;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;
import uk.ac.ebi.reactionblast.mechanism.MappingSolution;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.mechanism.helper.MoleculeMoleculePair;
import uk.ac.ebi.reactionblast.tools.ReactionSimilarityTool;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;

public class Annotator
extends Helper {
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String TAB = "\t";
    private static final Logger LOG = Logger.getLogger(Annotator.class.getName());
    protected boolean REPORT_ALL_MAPPINGS = false;
    protected boolean GENERATE_IMAGE = false;
    protected boolean GENERATE_AAMIMAGE = false;
    protected boolean REPORT_MMP = false;
    protected boolean REPORT_PATTERNS = false;
    protected boolean REMAP = true;
    protected String PREFIX = "";

    Annotator() {
    }

    protected ReactionMechanismTool getReactionMechanismTool(IReaction cdkReaction, boolean reMap) throws Exception {
        if (AtomContainerSetManipulator.getAtomCount(cdkReaction.getReactants()) == cdkReaction.getMappingCount()) {
            cdkReaction.setFlag(128, true);
        } else {
            cdkReaction.setFlag(128, false);
        }
        ReactionMechanismTool rmt = new ReactionMechanismTool(cdkReaction, reMap, true, false, new StandardizeReaction());
        return rmt;
    }

    protected boolean writeFiles(String reactionID, ReactionMechanismTool mech) throws IOException, CDKException, Exception {
        MappingSolution s = mech.getSelectedSolution();
        if (s == null) {
            return false;
        }
        File writeRXNMappedFile = this.writeRXNMappedFile(new File(".").getCanonicalPath(), s.getBondChangeCalculator().getReaction(), reactionID);
        System.out.println("Mapped RXN File " + writeRXNMappedFile.getAbsolutePath());
        if (this.GENERATE_IMAGE) {
            try {
                File generateImage = this.generateImage(new File(".").getCanonicalPath(), s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens(), reactionID);
                System.out.println("Annotated RXN Image " + generateImage.getAbsolutePath());
            }
            catch (Exception e) {
                Logger.getLogger(Annotator.class.getName()).log(Level.SEVERE, "Unable to generate AAM image", e);
            }
        } else if (!this.GENERATE_IMAGE && this.GENERATE_AAMIMAGE) {
            try {
                File generateImage = this.generateAAMImage(new File(".").getCanonicalPath(), s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens(), reactionID);
                System.out.println("Annotated RXN Image " + generateImage.getAbsolutePath());
            }
            catch (Exception e) {
                Logger.getLogger(Annotator.class.getName()).log(Level.SEVERE, "Unable to generate AAM image", e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSimilarityMatrix(List<SimilarityResult> results, String jobID) throws IOException {
        String rootPath = new File(".").getCanonicalPath();
        File bcMatrix = new File(rootPath, jobID + "_Bond_Change" + ".mat");
        File rcMatrix = new File(rootPath, jobID + "_Reaction_Centre" + ".mat");
        File stMatrix = new File(rootPath, jobID + "_Structure_Similarity" + ".mat");
        FileWriter writerBC = new FileWriter(bcMatrix);
        BufferedWriter bufferedWriterBC = new BufferedWriter(writerBC);
        FileWriter writerRC = new FileWriter(rcMatrix);
        BufferedWriter bufferedWriterRC = new BufferedWriter(writerRC);
        FileWriter writerST = new FileWriter(stMatrix);
        BufferedWriter bufferedWriterST = new BufferedWriter(writerST);
        bufferedWriterBC.newLine();
        try {
            for (SimilarityResult s : results) {
                if (s.getSimilarityReactions().containsKey("BC")) {
                    bufferedWriterBC.write("\"" + s.getQuery() + "\"" + TAB + "\"" + s.getTarget() + "\"" + TAB + s.getSimilarityReactions().get("BC"));
                    bufferedWriterBC.newLine();
                    continue;
                }
                bufferedWriterBC.write("\"" + s.getQuery() + "\"" + TAB + "\"" + s.getTarget() + "\"" + TAB + "NA");
                bufferedWriterBC.newLine();
            }
        }
        finally {
            bufferedWriterBC.close();
        }
        try {
            for (SimilarityResult s : results) {
                if (s.getSimilarityReactions().containsKey("RC")) {
                    bufferedWriterRC.write("\"" + s.getQuery() + "\"" + TAB + "\"" + s.getTarget() + "\"" + TAB + s.getSimilarityReactions().get("RC"));
                    bufferedWriterRC.newLine();
                    continue;
                }
                bufferedWriterRC.write("\"" + s.getQuery() + "\"" + TAB + "\"" + s.getTarget() + "\"" + TAB + "NA");
                bufferedWriterRC.newLine();
            }
        }
        finally {
            bufferedWriterRC.close();
        }
        try {
            for (SimilarityResult s : results) {
                if (s.getSimilarityReactions().containsKey("ST")) {
                    bufferedWriterST.write("\"" + s.getQuery() + "\"" + TAB + "\"" + s.getTarget() + "\"" + TAB + s.getSimilarityReactions().get("ST"));
                    bufferedWriterST.newLine();
                    continue;
                }
                bufferedWriterST.write("\"" + s.getQuery() + "\"" + TAB + "\"" + s.getTarget() + "\"" + TAB + "NA");
                bufferedWriterST.newLine();
            }
        }
        finally {
            bufferedWriterST.close();
        }
    }

    private void printRPAIRPatternAsText(MappingSolution s, StringBuilder sb) throws CloneNotSupportedException {
        Map<String, Collection<String>> moleculeMoleculeTransformationPairs = s.getBondChangeCalculator().getMoleculeMoleculeTransformationPairs();
        StringBuilder sbcomp = new StringBuilder();
        int index = 1;
        for (String m : moleculeMoleculeTransformationPairs.keySet()) {
            StringBuilder mmp = new StringBuilder(m);
            mmp.append(TAB);
            mmp.append(moleculeMoleculeTransformationPairs.get(m));
            sbcomp.append(index).append(": ").append((CharSequence)mmp);
            sbcomp.append(NEW_LINE);
            ++index;
        }
        Collection<MoleculeMoleculePair> reactionTransform = s.getBondChangeCalculator().getReactionCentreTransformationPairs();
        StringBuilder pair1 = new StringBuilder();
        index = 1;
        for (MoleculeMoleculePair moleculeMoleculePair : reactionTransform) {
            pair1.append(index).append(": ").append(moleculeMoleculePair.getSmirks1());
            pair1.append(NEW_LINE);
            ++index;
        }
        StringBuilder pair2 = new StringBuilder();
        index = 1;
        for (MoleculeMoleculePair moleculeMoleculePair : reactionTransform) {
            pair2.append(index).append(": ").append(moleculeMoleculePair.getSmirks2());
            pair2.append(NEW_LINE);
            ++index;
        }
        StringBuilder stringBuilder = new StringBuilder();
        index = 1;
        for (MoleculeMoleculePair m : reactionTransform) {
            stringBuilder.append(index).append(": ").append(m.getSmirks3());
            stringBuilder.append(NEW_LINE);
            ++index;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder sbOC = new StringBuilder();
        StringBuilder sbST = new StringBuilder();
        Map<Integer, IPatternFingerprinter> reactionCenterFormedCleavedFingerprint = s.getBondChangeCalculator().getReactionCenterFormedCleavedFingerprint();
        for (Map.Entry<Integer, IPatternFingerprinter> m : reactionCenterFormedCleavedFingerprint.entrySet()) {
            if (m.getKey() == -1) continue;
            IPatternFingerprinter iPatternFingerprinter = ((IPatternFingerprinter)m.getValue()).clone();
            iPatternFingerprinter.setFingerprintID("Reaction Center at Level: " + m.getKey());
            stringBuilder2.append(iPatternFingerprinter).append(NEW_LINE);
        }
        Map<Integer, IPatternFingerprinter> reactionCenterOrderChangeFingerprint = s.getBondChangeCalculator().getReactionCenterOrderChangeFingerprint();
        for (Map.Entry entry : reactionCenterOrderChangeFingerprint.entrySet()) {
            if ((Integer)entry.getKey() == -1) continue;
            IPatternFingerprinter value = ((IPatternFingerprinter)entry.getValue()).clone();
            value.setFingerprintID("Reaction Center at Level: " + entry.getKey());
            sbOC.append(value).append(NEW_LINE);
        }
        Map<Integer, IPatternFingerprinter> reactionCenterStereoChangeFingerprint = s.getBondChangeCalculator().getReactionCenterStereoChangeFingerprint();
        for (Map.Entry<Integer, IPatternFingerprinter> m : reactionCenterStereoChangeFingerprint.entrySet()) {
            if (m.getKey() == -1) continue;
            IPatternFingerprinter value = m.getValue().clone();
            value.setFingerprintID("Reaction Center at Level: " + m.getKey());
            sbST.append(value).append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append("//");
        sb.append(NEW_LINE);
        sb.append("Reaction Centre Formed/Cleaved");
        sb.append(NEW_LINE);
        sb.append(stringBuilder2.toString());
        sb.append(NEW_LINE);
        sb.append("Reaction Centre Order Changed");
        sb.append(NEW_LINE);
        sb.append(sbOC.toString());
        sb.append(NEW_LINE);
        sb.append("Reaction Centre Stereo Changes");
        sb.append(NEW_LINE);
        sb.append(sbST.toString());
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("//").append(NEW_LINE);
        sb.append("TRANSFORMATIONS");
        sb.append(NEW_LINE);
        sb.append("MMP Level 1");
        sb.append(NEW_LINE);
        sb.append(pair1.toString());
        sb.append(NEW_LINE);
        sb.append("MMP Level 2");
        sb.append(NEW_LINE);
        sb.append(pair2.toString());
        sb.append(NEW_LINE);
        sb.append("MMP Level 3");
        sb.append(NEW_LINE);
        sb.append(stringBuilder.toString());
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append("//").append(NEW_LINE);
        sb.append("REACTION MMP (RPAIR)");
        sb.append(NEW_LINE);
        sb.append(sbcomp.toString());
        sb.append(NEW_LINE);
    }

    private void printRPAIRPatternAsXML(MappingSolution s, Document doc, Element rootElement) {
        Element rpairMATCH;
        Map<Integer, IPatternFingerprinter> reactionCenterFormedCleavedFingerprint = s.getBondChangeCalculator().getReactionCenterFormedCleavedFingerprint();
        Map<Integer, IPatternFingerprinter> reactionCenterOrderChangeFingerprint = s.getBondChangeCalculator().getReactionCenterOrderChangeFingerprint();
        Map<Integer, IPatternFingerprinter> reactionCenterStereoChangeFingerprint = s.getBondChangeCalculator().getReactionCenterStereoChangeFingerprint();
        Set<Integer> levels = reactionCenterFormedCleavedFingerprint.keySet();
        for (Integer i : levels) {
            if (i == -1) continue;
            Element rc = doc.createElement("ReactionCenters");
            rootElement.appendChild(rc);
            Attr attr = doc.createAttribute("LEVEL");
            attr.setValue(i + "");
            rc.setAttributeNode(attr);
            if (reactionCenterFormedCleavedFingerprint.containsKey(i)) {
                Element fp_FORMED_CLEAVED = doc.createElement("FC");
                fp_FORMED_CLEAVED.appendChild(doc.createTextNode(reactionCenterFormedCleavedFingerprint.get(i).getFeatures().toString()));
                rc.appendChild(fp_FORMED_CLEAVED);
            }
            if (reactionCenterOrderChangeFingerprint.containsKey(i)) {
                Element fp_ORDER_CHANGED = doc.createElement("OC");
                fp_ORDER_CHANGED.appendChild(doc.createTextNode(reactionCenterOrderChangeFingerprint.get(i).getFeatures().toString()));
                rc.appendChild(fp_ORDER_CHANGED);
            }
            if (!reactionCenterStereoChangeFingerprint.containsKey(i)) continue;
            Iterator<MoleculeMoleculePair> fp_STEREO_CHANGED = doc.createElement("ST");
            fp_STEREO_CHANGED.appendChild(doc.createTextNode(reactionCenterStereoChangeFingerprint.get(i).getFeatures().toString()));
            rc.appendChild((Node)((Object)fp_STEREO_CHANGED));
        }
        Collection<MoleculeMoleculePair> reactionTransform = s.getBondChangeCalculator().getReactionCentreTransformationPairs();
        Element transform = doc.createElement("TRANSFORMATION");
        rootElement.appendChild(transform);
        Attr attr = doc.createAttribute("LEVEL");
        attr.setValue("1");
        transform.setAttributeNode(attr);
        int index = 1;
        for (MoleculeMoleculePair m : reactionTransform) {
            rpairMATCH = doc.createElement("MMP" + index);
            rpairMATCH.appendChild(doc.createTextNode(m.getSmirks1()));
            transform.appendChild(rpairMATCH);
            ++index;
        }
        transform = doc.createElement("TRANSFORMATION");
        rootElement.appendChild(transform);
        attr = doc.createAttribute("LEVEL");
        attr.setValue("2");
        transform.setAttributeNode(attr);
        index = 1;
        for (MoleculeMoleculePair m : reactionTransform) {
            rpairMATCH = doc.createElement("MMP" + index);
            rpairMATCH.appendChild(doc.createTextNode(m.getSmirks2()));
            transform.appendChild(rpairMATCH);
            ++index;
        }
        transform = doc.createElement("TRANSFORMATION");
        rootElement.appendChild(transform);
        attr = doc.createAttribute("LEVEL");
        attr.setValue("3");
        transform.setAttributeNode(attr);
        index = 1;
        for (MoleculeMoleculePair m : reactionTransform) {
            rpairMATCH = doc.createElement("MMP" + index);
            rpairMATCH.appendChild(doc.createTextNode(m.getSmirks3()));
            transform.appendChild(rpairMATCH);
            ++index;
        }
        Map<String, Collection<String>> moleculeMoleculeTransformationPairs = s.getBondChangeCalculator().getMoleculeMoleculeTransformationPairs();
        index = 1;
        for (String m : moleculeMoleculeTransformationPairs.keySet()) {
            Element rpair = doc.createElement("RPAIR");
            rootElement.appendChild(rpair);
            attr = doc.createAttribute("COUNT");
            attr.setValue(index + "");
            rpair.setAttributeNode(attr);
            Element rpairMATCH2 = doc.createElement("MMP");
            Collection<String> mmp = moleculeMoleculeTransformationPairs.get(m);
            StringBuilder sb = new StringBuilder(m);
            sb.append(TAB);
            sb.append(mmp);
            rpairMATCH2.appendChild(doc.createTextNode(sb.toString()));
            rpair.appendChild(rpairMATCH2);
            ++index;
        }
    }

    protected void annotateReactionAsText(ReactionMechanismTool rmt, String reactionID, StringBuilder sb) throws CloneNotSupportedException {
        DecimalFormatSymbols instance = DecimalFormatSymbols.getInstance();
        instance.setExponentSeparator("E");
        DecimalFormat df = new DecimalFormat("##E00", instance);
        NumberFormat myFormatter = NumberFormat.getInstance();
        myFormatter.setMinimumFractionDigits(2);
        myFormatter.setMaximumFractionDigits(2);
        try {
            MappingSolution s = rmt.getSelectedSolution();
            if (s == null) {
                System.out.println("No valid solution found");
                return;
            }
            if (this.REPORT_PATTERNS) {
                sb.append(NEW_LINE);
                sb.append("//");
                sb.append(NEW_LINE);
                sb.append("FINGERPRINTS BC");
                sb.append(NEW_LINE);
                if (!s.getBondChangeCalculator().getFormedCleavedWFingerprint().getFeatures().isEmpty()) {
                    sb.append(NEW_LINE);
                    sb.append("FORMED_CLEAVED");
                    sb.append(NEW_LINE);
                    sb.append(s.getBondChangeCalculator().getFormedCleavedWFingerprint().getFeatures().toString()).append(NEW_LINE);
                }
                if (!s.getBondChangeCalculator().getOrderChangesWFingerprint().getFeatures().isEmpty()) {
                    sb.append(NEW_LINE);
                    sb.append("ORDER_CHANGED");
                    sb.append(NEW_LINE);
                    sb.append(s.getBondChangeCalculator().getOrderChangesWFingerprint().getFeatures().toString()).append(NEW_LINE);
                }
                if (!s.getBondChangeCalculator().getStereoChangesWFingerprint().getFeatures().isEmpty()) {
                    sb.append(NEW_LINE);
                    sb.append("STEREO_CHANGED");
                    sb.append(NEW_LINE);
                    sb.append(s.getBondChangeCalculator().getStereoChangesWFingerprint().getFeatures().toString()).append(NEW_LINE);
                }
                sb.append(NEW_LINE);
                sb.append("//");
                sb.append(NEW_LINE);
                sb.append("FINGERPRINTS RC");
                sb.append(NEW_LINE);
                sb.append(s.getBondChangeCalculator().getReactionCenterWFingerprint().getFeatures().toString()).append(NEW_LINE);
                if (this.REPORT_MMP) {
                    this.printRPAIRPatternAsText(s, sb);
                }
            }
            SmilesGenerator smiles = SmilesGenerator.generic().withAtomClasses();
            sb.append(NEW_LINE);
            sb.append("//");
            sb.append(NEW_LINE);
            sb.append("SELECTED AAM MAPPING");
            sb.append(NEW_LINE);
            sb.append(smiles.createReactionSMILES(s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens()));
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            if (this.REMAP) {
                sb.append(NEW_LINE);
                sb.append("//");
                sb.append(NEW_LINE);
                sb.append("REACTANT INPUT ATOM INDEX<->AAM ID");
                sb.append(NEW_LINE);
                sb.append(s.getReactor().getInputRankLabelledAtomsReactant());
                sb.append(NEW_LINE);
                sb.append("PRODUCT INPUT ATOM INDEX<->AAM ID");
                sb.append(NEW_LINE);
                sb.append(s.getReactor().getInputRankLabelledAtomsProduct());
                sb.append(NEW_LINE);
                sb.append(NEW_LINE);
            }
            if (this.REPORT_ALL_MAPPINGS) {
                int index = 1;
                for (MappingSolution m : rmt.getAllSolutions()) {
                    sb.append("//");
                    sb.append(NEW_LINE);
                    sb.append(index).append(") AAM MAPPING ALGORITHM: ").append(m.getAlgorithmID().description());
                    sb.append(NEW_LINE);
                    sb.append(smiles.createReactionSMILES(m.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens()));
                    sb.append(NEW_LINE);
                    sb.append("SCORE: ").append(m.getTotalBondChanges() + m.getTotalFragmentChanges());
                    sb.append(", CHAOS: ").append(m.getTotalFragmentChanges()).append(" <=> ").append(m.getSmallestFragmentCount());
                    sb.append(", SIGMA: ").append(m.getTotalCarbonBondChanges());
                    sb.append(", ENERGY: ").append(df.format(m.getBondEnergySum()));
                    sb.append(", DELTA: ").append(df.format(m.getEnergyDelta()));
                    sb.append(NEW_LINE);
                    ++index;
                }
            }
        }
        catch (CDKException ex) {
            System.err.println("Invalid RXN File " + reactionID);
            Logger.getLogger(Annotator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void annotateReactionAsXML(ReactionMechanismTool rmt, String reactionID, Document doc, Element rootElement) {
        DecimalFormatSymbols instance = DecimalFormatSymbols.getInstance();
        instance.setExponentSeparator("E");
        DecimalFormat df = new DecimalFormat("##E00", instance);
        NumberFormat myFormatter = NumberFormat.getInstance();
        myFormatter.setMinimumFractionDigits(2);
        myFormatter.setMaximumFractionDigits(2);
        Element annot = doc.createElement("ANNOTATION");
        rootElement.appendChild(annot);
        try {
            MappingSolution s = rmt.getSelectedSolution();
            if (s == null) {
                System.out.println("No valid solution found");
                return;
            }
            if (this.REPORT_PATTERNS) {
                Element fp = doc.createElement("FINGERPRINTS");
                annot.appendChild(fp);
                Attr attr = doc.createAttribute("BC");
                attr.setValue("1");
                fp.setAttributeNode(attr);
                if (!s.getBondChangeCalculator().getFormedCleavedWFingerprint().getFeatures().isEmpty()) {
                    Element fp_Formed_Cleaved = doc.createElement("FORMED_CLEAVED");
                    fp_Formed_Cleaved.appendChild(doc.createTextNode(s.getBondChangeCalculator().getFormedCleavedWFingerprint().getFeatures().toString()));
                    fp.appendChild(fp_Formed_Cleaved);
                }
                if (!s.getBondChangeCalculator().getOrderChangesWFingerprint().getFeatures().isEmpty()) {
                    Element fp_ORDER_CHANGED = doc.createElement("ORDER_CHANGED");
                    fp_ORDER_CHANGED.appendChild(doc.createTextNode(s.getBondChangeCalculator().getOrderChangesWFingerprint().getFeatures().toString()));
                    fp.appendChild(fp_ORDER_CHANGED);
                }
                if (!s.getBondChangeCalculator().getStereoChangesWFingerprint().getFeatures().isEmpty()) {
                    Element fp_STEREO_CHANGED = doc.createElement("STEREO_CHANGED");
                    fp_STEREO_CHANGED.appendChild(doc.createTextNode(s.getBondChangeCalculator().getStereoChangesWFingerprint().getFeatures().toString()));
                    fp.appendChild(fp_STEREO_CHANGED);
                }
                fp = doc.createElement("FINGERPRINTS");
                annot.appendChild(fp);
                attr = doc.createAttribute("RC");
                attr.setValue("2");
                fp.setAttributeNode(attr);
                Element fp_Reaction_Centre = doc.createElement("CENTRE");
                fp_Reaction_Centre.appendChild(doc.createTextNode(s.getBondChangeCalculator().getReactionCenterWFingerprint().getFeatures().toString()));
                fp.appendChild(fp_Reaction_Centre);
                if (this.REPORT_MMP) {
                    this.printRPAIRPatternAsXML(s, doc, annot);
                }
            }
            SmilesGenerator smiles = SmilesGenerator.generic().withAtomClasses();
            Element aam = doc.createElement("MAPPING");
            annot.appendChild(aam);
            Attr attr = doc.createAttribute("STATUS");
            attr.setValue("SELECTED");
            aam.setAttributeNode(attr);
            Element selected_AAM = doc.createElement("AAM");
            selected_AAM.appendChild(doc.createTextNode(smiles.createReactionSMILES(s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens())));
            aam.appendChild(selected_AAM);
            if (this.REMAP) {
                String reactant_atom_rank = s.getReactor().getInputRankLabelledAtomsProduct().toString();
                String product_atom_rank = s.getReactor().getInputRankLabelledAtomsProduct().toString();
                Element selected_AAM_RANK_R = doc.createElement("RANK_REACTANT");
                selected_AAM_RANK_R.appendChild(doc.createTextNode(reactant_atom_rank));
                aam.appendChild(selected_AAM_RANK_R);
                Element selected_AAM_RANK_P = doc.createElement("RANK_PRODUCT");
                selected_AAM_RANK_P.appendChild(doc.createTextNode(product_atom_rank));
                aam.appendChild(selected_AAM_RANK_P);
            }
            if (this.REPORT_ALL_MAPPINGS) {
                for (MappingSolution m : rmt.getAllSolutions()) {
                    aam = doc.createElement("MAPPING");
                    annot.appendChild(aam);
                    attr = doc.createAttribute("ALGORTIHM");
                    attr.setValue(m.getAlgorithmID().description());
                    aam.setAttributeNode(attr);
                    Element solutionAAM = doc.createElement("AAM");
                    solutionAAM.appendChild(doc.createTextNode(smiles.createReactionSMILES(m.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens())));
                    aam.appendChild(solutionAAM);
                    Element score = doc.createElement("SCORE");
                    score.appendChild(doc.createTextNode(m.getTotalBondChanges() + m.getTotalFragmentChanges() + ""));
                    aam.appendChild(score);
                    score = doc.createElement("CHAOS");
                    score.appendChild(doc.createTextNode(m.getTotalFragmentChanges() + " <=> " + m.getSmallestFragmentCount()));
                    aam.appendChild(score);
                    score = doc.createElement("SIGMA");
                    score.appendChild(doc.createTextNode(m.getTotalCarbonBondChanges() + ""));
                    aam.appendChild(score);
                    score = doc.createElement("ENERGY");
                    score.appendChild(doc.createTextNode(df.format(m.getBondEnergySum()) + ""));
                    aam.appendChild(score);
                    score = doc.createElement("DELTA");
                    score.appendChild(doc.createTextNode(df.format(m.getEnergyDelta()) + ""));
                    aam.appendChild(score);
                }
            }
        }
        catch (CDKException ex) {
            System.err.println("Invalid RXN File " + reactionID);
            Logger.getLogger(Annotator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void compareRXNXML(ReactionMechanismTool annotateRXNQ, String reactionQID, ReactionMechanismTool annotateRXNT, String reactionTID, Document doc, Element rootElement) throws Exception {
        NumberFormat myFormatter = NumberFormat.getInstance();
        myFormatter.setMinimumFractionDigits(2);
        myFormatter.setMaximumFractionDigits(2);
        Element element = doc.createElement("COMPARISON");
        rootElement.appendChild(element);
        Element query2 = doc.createElement("QUERY");
        element.appendChild(query2);
        this.annotateReactionAsXML(annotateRXNQ, reactionQID, doc, query2);
        BondChangeCalculator bondChangeCalculatorQ = annotateRXNQ.getSelectedSolution().getBondChangeCalculator();
        Element target = doc.createElement("TARGET");
        element.appendChild(target);
        this.annotateReactionAsXML(annotateRXNT, reactionTID, doc, target);
        BondChangeCalculator bondChangeCalculatorT = annotateRXNT.getSelectedSolution().getBondChangeCalculator();
        PatternFingerprinter fpQ = new PatternFingerprinter();
        fpQ.add(bondChangeCalculatorQ.getFormedCleavedWFingerprint());
        fpQ.add(bondChangeCalculatorQ.getOrderChangesWFingerprint());
        fpQ.add(bondChangeCalculatorQ.getStereoChangesWFingerprint());
        PatternFingerprinter fpT = new PatternFingerprinter();
        fpT.add(bondChangeCalculatorT.getFormedCleavedWFingerprint());
        fpT.add(bondChangeCalculatorT.getOrderChangesWFingerprint());
        fpT.add(bondChangeCalculatorT.getStereoChangesWFingerprint());
        double similarityBondChanges = ReactionSimilarityTool.getSimilarity(fpQ, fpT);
        Element sim = doc.createElement("SIMILARITY");
        element.appendChild(sim);
        Attr attr = doc.createAttribute("BC");
        attr.setValue("1");
        sim.setAttributeNode(attr);
        Element score = doc.createElement("SCORE");
        score.appendChild(doc.createTextNode(myFormatter.format(similarityBondChanges)));
        sim.appendChild(score);
        double similarityReactionCentres = ReactionSimilarityTool.getSimilarity(bondChangeCalculatorQ.getReactionCenterWFingerprint(), bondChangeCalculatorT.getReactionCenterWFingerprint());
        sim = doc.createElement("SIMILARITY");
        element.appendChild(sim);
        attr = doc.createAttribute("RC");
        attr.setValue("2");
        sim.setAttributeNode(attr);
        score = doc.createElement("SCORE");
        score.appendChild(doc.createTextNode(myFormatter.format(similarityReactionCentres)));
        sim.appendChild(score);
        ReactionFingerprinter rfQ = new ReactionFingerprinter(bondChangeCalculatorQ.getReaction());
        ReactionFingerprinter rfT = new ReactionFingerprinter(bondChangeCalculatorT.getReaction());
        double similarityReactionStructure = ReactionSimilarityTool.getSimilarity(rfQ.getReactionStruturalFingerprint(), rfT.getReactionStruturalFingerprint());
        sim = doc.createElement("SIMILARITY");
        element.appendChild(sim);
        attr = doc.createAttribute("ST");
        attr.setValue("3");
        sim.setAttributeNode(attr);
        score = doc.createElement("SCORE");
        score.appendChild(doc.createTextNode(myFormatter.format(similarityReactionStructure)));
        sim.appendChild(score);
    }

    protected Map<String, String> similarityReactions(ReactionMechanismTool annotateRXNQ, String reactionQID, ReactionMechanismTool annotateRXNT, String reactionTID) throws Exception {
        HashMap<String, String> scores = new HashMap<String, String>();
        NumberFormat myFormatter = NumberFormat.getInstance();
        myFormatter.setMinimumFractionDigits(2);
        myFormatter.setMaximumFractionDigits(2);
        BondChangeCalculator bondChangeCalculatorQ = annotateRXNQ.getSelectedSolution().getBondChangeCalculator();
        BondChangeCalculator bondChangeCalculatorT = annotateRXNT.getSelectedSolution().getBondChangeCalculator();
        PatternFingerprinter fpQ = new PatternFingerprinter();
        fpQ.add(bondChangeCalculatorQ.getFormedCleavedWFingerprint());
        fpQ.add(bondChangeCalculatorQ.getOrderChangesWFingerprint());
        fpQ.add(bondChangeCalculatorQ.getStereoChangesWFingerprint());
        PatternFingerprinter fpT = new PatternFingerprinter();
        fpT.add(bondChangeCalculatorT.getFormedCleavedWFingerprint());
        fpT.add(bondChangeCalculatorT.getOrderChangesWFingerprint());
        fpT.add(bondChangeCalculatorT.getStereoChangesWFingerprint());
        double similarityBondChanges = ReactionSimilarityTool.getSimilarity(fpQ, fpT);
        scores.put("BC", myFormatter.format(similarityBondChanges));
        double similarityReactionCentres = ReactionSimilarityTool.getSimilarity(bondChangeCalculatorQ.getReactionCenterWFingerprint(), bondChangeCalculatorT.getReactionCenterWFingerprint());
        scores.put("RC", myFormatter.format(similarityReactionCentres));
        ReactionFingerprinter rfQ = new ReactionFingerprinter(bondChangeCalculatorQ.getReaction());
        ReactionFingerprinter rfT = new ReactionFingerprinter(bondChangeCalculatorT.getReaction());
        double similarityReactionStructure = ReactionSimilarityTool.getSimilarity(rfQ.getReactionStruturalFingerprint(), rfT.getReactionStruturalFingerprint());
        scores.put("ST", myFormatter.format(similarityReactionStructure));
        return scores;
    }

    protected void compareRXNText(ReactionMechanismTool annotateRXNQ, String reactionQID, ReactionMechanismTool annotateRXNT, String reactionTID, StringBuilder sb) throws Exception {
        NumberFormat myFormatter = NumberFormat.getInstance();
        myFormatter.setMinimumFractionDigits(2);
        myFormatter.setMaximumFractionDigits(2);
        sb.append(NEW_LINE).append("//");
        sb.append(NEW_LINE);
        sb.append("Annotating Query Reaction ").append(reactionQID).append(NEW_LINE);
        this.annotateReactionAsText(annotateRXNQ, reactionQID, sb);
        BondChangeCalculator bondChangeCalculatorQ = annotateRXNQ.getSelectedSolution().getBondChangeCalculator();
        sb.append(NEW_LINE).append("//");
        sb.append(NEW_LINE);
        sb.append("Annotating Target Reaction ").append(reactionTID).append(NEW_LINE);
        this.annotateReactionAsText(annotateRXNT, reactionTID, sb);
        BondChangeCalculator bondChangeCalculatorT = annotateRXNT.getSelectedSolution().getBondChangeCalculator();
        PatternFingerprinter fpQ = new PatternFingerprinter();
        fpQ.add(bondChangeCalculatorQ.getFormedCleavedWFingerprint());
        fpQ.add(bondChangeCalculatorQ.getOrderChangesWFingerprint());
        fpQ.add(bondChangeCalculatorQ.getStereoChangesWFingerprint());
        PatternFingerprinter fpT = new PatternFingerprinter();
        fpT.add(bondChangeCalculatorT.getFormedCleavedWFingerprint());
        fpT.add(bondChangeCalculatorT.getOrderChangesWFingerprint());
        fpT.add(bondChangeCalculatorT.getStereoChangesWFingerprint());
        sb.append(NEW_LINE);
        sb.append("//");
        sb.append(NEW_LINE).append("REACTION SIMILARITY METRICS (Min:0, Max:1.0)");
        sb.append(NEW_LINE);
        double similarityBondChanges = ReactionSimilarityTool.getSimilarity(fpQ, fpT);
        sb.append("Bond Change Similarity (BC): ").append(myFormatter.format(similarityBondChanges));
        sb.append(NEW_LINE);
        double similarityReactionCentres = ReactionSimilarityTool.getSimilarity(bondChangeCalculatorQ.getReactionCenterWFingerprint(), bondChangeCalculatorT.getReactionCenterWFingerprint());
        sb.append("Reaction Centre Similarity (RC): ").append(myFormatter.format(similarityReactionCentres));
        sb.append(NEW_LINE);
        ReactionFingerprinter rfQ = new ReactionFingerprinter(bondChangeCalculatorQ.getReaction());
        ReactionFingerprinter rfT = new ReactionFingerprinter(bondChangeCalculatorT.getReaction());
        double similarityReactionStructure = ReactionSimilarityTool.getSimilarity(rfQ.getReactionStruturalFingerprint(), rfT.getReactionStruturalFingerprint());
        sb.append("Reaction Structure Similarity (ST): ").append(myFormatter.format(similarityReactionStructure));
        sb.append(NEW_LINE);
    }
}

