/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.mcss;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.Isomorphism;
import org.openscience.smsd.interfaces.Algorithm;
import org.openscience.smsd.mcss.Fragment;
import org.openscience.smsd.mcss.JobType;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class MCSSThread
implements Callable<LinkedBlockingQueue<IAtomContainer>> {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MCSSThread.class);
    private static final Logger LOG = Logger.getLogger(MCSSThread.class.getName());
    private final List<IAtomContainer> mcssList;
    private final JobType jobType;
    private final int taskNumber;
    private final boolean matchBonds;
    private final boolean matchRings;
    private final boolean matchAtomType;

    public MCSSThread(List<IAtomContainer> mcssList, JobType jobType, int taskNumber) {
        this(mcssList, jobType, taskNumber, true, true, true);
    }

    public MCSSThread(List<IAtomContainer> mcssList, JobType jobType, int taskNumber, boolean matchBonds, boolean matchRings, boolean matchAtomType) {
        this.mcssList = mcssList;
        this.jobType = jobType;
        this.taskNumber = taskNumber;
        this.matchBonds = matchBonds;
        this.matchRings = matchRings;
        this.matchAtomType = matchAtomType;
    }

    @Override
    public synchronized LinkedBlockingQueue<IAtomContainer> call() {
        if (this.jobType.equals(JobType.MULTIPLE)) {
            return this.multiSolution();
        }
        return this.singleSolution();
    }

    private synchronized LinkedBlockingQueue<IAtomContainer> multiSolution() {
        LinkedBlockingQueue<IAtomContainer> mcss = new LinkedBlockingQueue<IAtomContainer>();
        logger.debug("Calling MCSSTask " + this.taskNumber + " with " + this.mcssList.size() + " items");
        long startTime = Calendar.getInstance().getTimeInMillis();
        IAtomContainer querySeed = this.mcssList.get(0);
        long calcTime = startTime;
        ConcurrentLinkedQueue<IAtomContainer> seeds = new ConcurrentLinkedQueue<IAtomContainer>();
        try {
            TreeSet<Fragment> localSeeds = new TreeSet<Fragment>();
            int minSeedSize = querySeed.getAtomCount();
            for (int index = 1; index < this.mcssList.size(); ++index) {
                IAtomContainer target = this.mcssList.get(index);
                Isomorphism comparison = new Isomorphism(querySeed, target, Algorithm.DEFAULT, this.matchBonds, this.matchRings, this.matchAtomType);
                comparison.setChemFilters(true, true, true);
                Collection<Fragment> fragmentsFromMCS = this.getMCSS(comparison);
                logger.debug("comparison for task " + this.taskNumber + " has " + fragmentsFromMCS.size() + " unique matches of size " + comparison.getFirstAtomMapping().getCount());
                logger.debug("MCSS for task " + this.taskNumber + " has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
                logger.debug("Target for task " + this.taskNumber + " has " + target.getAtomCount() + " atoms, and " + target.getBondCount() + " bonds");
                long endCalcTime = Calendar.getInstance().getTimeInMillis();
                logger.debug("Task " + this.taskNumber + " index " + index + " took " + (endCalcTime - calcTime) + "ms");
                calcTime = endCalcTime;
                if (fragmentsFromMCS.isEmpty()) {
                    localSeeds.clear();
                    break;
                }
                for (Fragment fragment : fragmentsFromMCS) {
                    if (minSeedSize > fragment.getContainer().getAtomCount()) {
                        localSeeds.clear();
                        minSeedSize = fragment.getContainer().getAtomCount();
                    }
                    if (minSeedSize != fragment.getContainer().getAtomCount()) continue;
                    localSeeds.add(fragment);
                }
            }
            if (!localSeeds.isEmpty()) {
                for (Fragment f : localSeeds) {
                    seeds.add(f.getContainer());
                }
                localSeeds.clear();
            }
            logger.debug("No of Potential MULTIPLE " + seeds.size());
            minSeedSize = Integer.MAX_VALUE;
            while (!seeds.isEmpty()) {
                IAtomContainer fragmentMCS = (IAtomContainer)seeds.poll();
                localSeeds = new TreeSet();
                logger.debug("Potential MULTIPLE " + this.getMCSSSmiles(fragmentMCS));
                for (IAtomContainer target : this.mcssList) {
                    Isomorphism comparison = new Isomorphism(fragmentMCS, target, Algorithm.DEFAULT, this.matchBonds, this.matchRings, this.matchAtomType);
                    comparison.setChemFilters(true, true, true);
                    Collection<Fragment> fragmentsFromMCS = this.getMCSS(comparison);
                    if (fragmentsFromMCS == null || fragmentsFromMCS.isEmpty()) {
                        localSeeds.clear();
                        break;
                    }
                    for (Fragment fragment : fragmentsFromMCS) {
                        if (minSeedSize > fragment.getContainer().getAtomCount()) {
                            localSeeds.clear();
                            minSeedSize = fragment.getContainer().getAtomCount();
                        }
                        if (minSeedSize != fragment.getContainer().getAtomCount()) continue;
                        localSeeds.add(fragment);
                    }
                    fragmentMCS = ((Fragment)localSeeds.iterator().next()).getContainer();
                }
                if (localSeeds.isEmpty()) continue;
                for (Fragment f : localSeeds) {
                    mcss.add(f.getContainer());
                }
                localSeeds.clear();
            }
        }
        catch (CDKException e) {
            logger.error("ERROR IN MCS Thread: ", e);
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        logger.debug("Done: task " + this.taskNumber + " took " + (endTime - startTime) + "ms");
        logger.debug(" and mcss has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
        return mcss;
    }

    private synchronized LinkedBlockingQueue<IAtomContainer> singleSolution() {
        logger.debug("Calling MCSSTask " + this.taskNumber + " with " + this.mcssList.size() + " items");
        LinkedBlockingQueue<IAtomContainer> mcss = new LinkedBlockingQueue<IAtomContainer>();
        long startTime = Calendar.getInstance().getTimeInMillis();
        IAtomContainer querySeed = this.mcssList.get(0);
        long calcTime = startTime;
        try {
            for (int index = 1; index < this.mcssList.size(); ++index) {
                IAtomContainer target = ExtAtomContainerManipulator.removeHydrogens(this.mcssList.get(index));
                Isomorphism comparison = new Isomorphism(querySeed, target, Algorithm.DEFAULT, this.matchBonds, this.matchRings, this.matchAtomType);
                comparison.setChemFilters(true, true, true);
                Collection<Fragment> fragmentsFomMCS = this.getMCSS(comparison);
                logger.debug("comparison for task " + this.taskNumber + " has " + fragmentsFomMCS.size() + " unique matches of size " + comparison.getFirstAtomMapping().getCount());
                logger.debug("MCSS for task " + this.taskNumber + " has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
                logger.debug("Target for task " + this.taskNumber + " has " + target.getAtomCount() + " atoms, and " + target.getBondCount() + " bonds");
                long endCalcTime = Calendar.getInstance().getTimeInMillis();
                logger.debug("Task " + this.taskNumber + " index " + index + " took " + (endCalcTime - calcTime) + "ms");
                calcTime = endCalcTime;
                if (fragmentsFomMCS.isEmpty()) break;
                querySeed = fragmentsFomMCS.iterator().next().getContainer();
            }
            if (querySeed != null) {
                mcss.add(querySeed);
                long endTime = Calendar.getInstance().getTimeInMillis();
                logger.debug("Done: task " + this.taskNumber + " took " + (endTime - startTime) + "ms");
                logger.debug(" and mcss has " + querySeed.getAtomCount() + " atoms, and " + querySeed.getBondCount() + " bonds");
            }
        }
        catch (Exception e) {
            logger.error("ERROR IN MCS Thread: ", e);
        }
        return mcss;
    }

    private synchronized Collection<Fragment> getMCSS(BaseMapping comparison) {
        HashSet<Fragment> matchList = new HashSet<Fragment>();
        for (AtomAtomMapping mapping : comparison.getAllAtomMapping()) {
            try {
                IAtomContainer match = mapping.getCommonFragment();
                try {
                    matchList.add(new Fragment(match));
                }
                catch (CDKException ex) {
                    logger.error("ERROR IN MCS Thread: ", ex);
                }
            }
            catch (CloneNotSupportedException ex) {
                logger.error("ERROR IN MCS Thread: ", ex);
            }
        }
        return matchList;
    }

    public synchronized String getMCSSSmiles(IAtomContainer ac) throws CDKException {
        SmilesGenerator g = new SmilesGenerator().aromatic();
        return g.create(ac);
    }

    public synchronized int getTaskNumber() {
        return this.taskNumber;
    }
}

