/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.filters;

import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class BaseFilter {
    private final IAtomContainer mol1;
    private final IAtomContainer mol2;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(BaseFilter.class);

    public BaseFilter(IAtomContainer sourceMol, IAtomContainer targetMol) {
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(sourceMol);
        }
        catch (CDKException ex) {
            logger.error(Level.SEVERE, null, ex);
        }
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(targetMol);
        }
        catch (CDKException ex) {
            logger.error(Level.SEVERE, null, ex);
        }
        this.mol1 = sourceMol;
        this.mol2 = targetMol;
    }

    public BaseFilter(IQueryAtomContainer sourceMol, IAtomContainer targetMol) {
        this.mol1 = sourceMol;
        this.mol2 = targetMol;
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(this.mol2);
        }
        catch (CDKException ex) {
            logger.error(Level.SEVERE, null, ex);
        }
    }

    public synchronized IAtomContainer getQuery() {
        return this.mol1;
    }

    public synchronized IAtomContainer getTarget() {
        return this.mol2;
    }
}

