/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2.sub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.algorithm.vflib.vf2.AtomMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.BondMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.DefaultAtomMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.DefaultBondMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.sub.Pattern;
import org.openscience.smsd.algorithm.vflib.vf2.sub.StateStream;
import org.openscience.smsd.algorithm.vflib.vf2.sub.VFState;
import org.openscience.smsd.algorithm.vflib.vf2.sub.VFSubState;

public final class VF
extends Pattern {
    private final IAtomContainer query;
    private final int[][] g1;
    private final GraphUtil.EdgeToBondMap bonds1;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;
    private final Pattern.Patterns searchType;

    private VF(IAtomContainer query2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType, Pattern.Patterns searchType) {
        this.query = query2;
        this.atomMatcher = new DefaultAtomMatcher(shouldMatchRings, matchAtomType);
        this.bondMatcher = new DefaultBondMatcher(shouldMatchBonds, shouldMatchRings, matchAtomType);
        this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query2);
        this.g1 = GraphUtil.toAdjList(query2, this.bonds1);
        this.searchType = searchType;
    }

    @Override
    public List<Map<IAtom, IAtom>> matchAll(IAtomContainer target) {
        GraphUtil.EdgeToBondMap bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
        int[][] g2 = GraphUtil.toAdjList(target, bonds2);
        VFIterable iterable = new VFIterable(this.query, target, this.g1, g2, this.bonds1, bonds2, this.atomMatcher, this.bondMatcher, this.searchType);
        ArrayList<Map<IAtom, IAtom>> mappings = new ArrayList<Map<IAtom, IAtom>>();
        for (int[] map : iterable) {
            HashMap<IAtom, IAtom> atomAtomMapping = new HashMap<IAtom, IAtom>();
            for (int i = 0; i < map.length; ++i) {
                if (map[i] < 0) continue;
                atomAtomMapping.put(this.query.getAtom(i), target.getAtom(map[i]));
            }
            mappings.add(atomAtomMapping);
        }
        return mappings;
    }

    public static Pattern findSubstructure(IQueryAtomContainer query2) {
        boolean isQuery = query2 instanceof IQueryAtomContainer;
        return VF.findSubstructure(query2, false, false, false);
    }

    public static Pattern findIdentical(IQueryAtomContainer query2) {
        boolean isQuery = query2 instanceof IQueryAtomContainer;
        return VF.findIdentical(query2, false, false, false);
    }

    public static Pattern findSubstructure(IAtomContainer query2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        return new VF(query2, shouldMatchBonds, shouldMatchRings, matchAtomType, Pattern.Patterns.SUBGRAPH);
    }

    public static Pattern findIdentical(IAtomContainer query2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        return new VF(query2, shouldMatchBonds, shouldMatchRings, matchAtomType, Pattern.Patterns.IDENTICAL);
    }

    private static final class VFIterable
    implements Iterable<int[]> {
        private final IAtomContainer container1;
        private final IAtomContainer container2;
        private final int[][] g1;
        private final int[][] g2;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;
        private final AtomMatcher atomMatcher;
        private final BondMatcher bondMatcher;
        private final Pattern.Patterns searchType;

        private VFIterable(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher, Pattern.Patterns searchType) {
            this.container1 = container1;
            this.container2 = container2;
            this.g1 = g1;
            this.g2 = g2;
            this.bonds1 = bonds1;
            this.bonds2 = bonds2;
            this.atomMatcher = atomMatcher;
            this.bondMatcher = bondMatcher;
            this.searchType = searchType;
        }

        @Override
        public Iterator<int[]> iterator() {
            if (null != this.searchType) {
                switch (this.searchType) {
                    case IDENTICAL: {
                        return new StateStream(new VFState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher), this.searchType);
                    }
                }
                return new StateStream(new VFSubState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher), this.searchType);
            }
            return null;
        }
    }
}

