/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2.mcs;

import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.algorithm.vflib.vf2.AtomMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.BondMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.mcs.AbstractVFSeedState;

final class VFSeedState
extends AbstractVFSeedState {
    private final IAtomContainer queryContainer;
    private final IAtomContainer targetContainer;
    private final GraphUtil.EdgeToBondMap queryBond;
    private final GraphUtil.EdgeToBondMap targetBond;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    VFSeedState(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
        super(g1, g2);
        this.queryContainer = container1;
        this.targetContainer = container2;
        this.queryBond = bonds1;
        this.targetBond = bonds2;
        this.atomMatcher = atomMatcher;
        this.bondMatcher = bondMatcher;
    }

    @Override
    boolean isMatchFeasible(int n, int m) {
        if (!this.atomMatcher.matches(this.queryContainer.getAtom(n), this.targetContainer.getAtom(m))) {
            return false;
        }
        int nTerminal1 = 0;
        int nTerminal2 = 0;
        int nRemain1 = 0;
        int nRemain2 = 0;
        for (int n_prime : this.g1[n]) {
            int m_prime = this.m1[n_prime];
            if (m_prime != -1) {
                IBond bond2 = this.targetBond.get(m, m_prime);
                if (bond2 == null) {
                    return false;
                }
                if (this.bondMatcher.matches(this.queryBond.get(n, n_prime), bond2)) continue;
                return false;
            }
            if (this.t1[n_prime] > 0) {
                ++nTerminal1;
                continue;
            }
            ++nRemain1;
        }
        for (int m_prime : this.g2[m]) {
            if (this.m2[m_prime] != -1) continue;
            if (this.t2[m_prime] > 0) {
                ++nTerminal2;
                continue;
            }
            ++nRemain2;
        }
        return nTerminal1 <= nTerminal2 || nRemain1 + nTerminal1 <= nRemain2 + nTerminal2 || nTerminal1 <= nTerminal2 && nRemain1 + nTerminal1 <= nRemain2 + nTerminal2;
    }
}

