/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2.mcs;

import java.util.Arrays;
import org.openscience.smsd.algorithm.vflib.vf2.mcs.State;

abstract class AbstractVFSeedState
extends State {
    protected static final int UNMAPPED = -1;
    protected final int[][] g1;
    protected final int[][] g2;
    protected final int[] m1;
    protected final int[] m2;
    protected final int[] t1;
    protected final int[] t2;
    protected int size;

    public AbstractVFSeedState(int[][] g1, int[][] g2) {
        this.g1 = g1;
        this.g2 = g2;
        this.m1 = new int[g1.length];
        this.m2 = new int[g2.length];
        this.t1 = new int[g1.length];
        this.t2 = new int[g2.length];
        this.size = 0;
        Arrays.fill(this.m1, -1);
        Arrays.fill(this.m2, -1);
    }

    @Override
    final int hasNextCandidate(int n) {
        int i;
        if (this.size == 0) {
            return 0;
        }
        for (i = n + 1; i < this.g1.length; ++i) {
            if (this.m1[i] != -1 || this.t1[i] <= 0) continue;
            return i;
        }
        for (i = n + 1; i < this.g1.length; ++i) {
            if (this.m1[i] != -1) continue;
            return i;
        }
        return this.maxQueryCandidate();
    }

    @Override
    final int nextCandidate(int n, int m) {
        if (this.size == 0) {
            return m + 1;
        }
        for (int i = m + 1; i < this.g2.length; ++i) {
            if (this.m2[i] != -1 || this.t1[n] != 0 && this.t2[i] <= 0) continue;
            return i;
        }
        return this.maxTargetCandidate();
    }

    @Override
    final int maxQueryCandidate() {
        return this.g1.length;
    }

    @Override
    final int maxTargetCandidate() {
        return this.g2.length;
    }

    @Override
    final boolean addMapping(int n, int m) {
        if (!this.isMatchFeasible(n, m)) {
            return false;
        }
        this.m1[n] = m;
        this.m2[m] = n;
        ++this.size;
        for (int w : this.g1[n]) {
            if (this.t1[w] != 0) continue;
            this.t1[w] = this.size;
        }
        for (int w : this.g2[m]) {
            if (this.t2[w] != 0) continue;
            this.t2[w] = this.size;
        }
        return true;
    }

    @Override
    final void backTrack(int n, int m) {
        this.m2[m] = -1;
        this.m1[n] = -1;
        --this.size;
        for (int w : this.g1[n]) {
            if (this.t1[w] <= this.size) continue;
            this.t1[w] = 0;
        }
        for (int w : this.g2[m]) {
            if (this.t2[w] <= this.size) continue;
            this.t2[w] = 0;
        }
    }

    abstract boolean isMatchFeasible(int var1, int var2);

    @Override
    int[] mapping() {
        return Arrays.copyOf(this.m1, this.m1.length);
    }

    @Override
    int size() {
        return this.size;
    }
}

