/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.mcsplus.MCSPlus;
import org.openscience.smsd.filters.PostFilter;
import org.openscience.smsd.interfaces.IResults;

public final class MCSPlusHandler
implements IResults {
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<Map<Integer, Integer>> allMCS;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private boolean flagExchange = false;
    private final boolean shouldMatchRings;
    private final boolean shouldMatchBonds;
    private final boolean matchAtomType;
    private final boolean timeout;

    public MCSPlusHandler(IAtomContainer source, IAtomContainer target, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        this.source = source;
        this.target = target;
        this.shouldMatchRings = shouldMatchRings;
        this.shouldMatchBonds = shouldMatchBonds;
        this.matchAtomType = matchAtomType;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    public MCSPlusHandler(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
        this.shouldMatchRings = true;
        this.shouldMatchBonds = true;
        this.matchAtomType = true;
        this.allAtomMCS = Collections.synchronizedList(new ArrayList());
        this.allMCS = Collections.synchronizedList(new ArrayList());
        this.timeout = this.searchMCS();
    }

    private synchronized boolean searchMCS() {
        List<List<Integer>> mappings;
        List<List<Integer>> overlaps;
        MCSPlus mcsplus;
        if (this.source instanceof IQueryAtomContainer) {
            mcsplus = new MCSPlus((IQueryAtomContainer)this.source, this.target);
            overlaps = mcsplus.getOverlaps();
            mappings = Collections.synchronizedList(overlaps);
        } else if (!(this.source instanceof IQueryAtomContainer) && this.source.getAtomCount() < this.target.getAtomCount()) {
            mcsplus = new MCSPlus(this.source, this.target, this.shouldMatchBonds, this.shouldMatchRings, this.matchAtomType);
            overlaps = mcsplus.getOverlaps();
            mappings = Collections.synchronizedList(overlaps);
        } else {
            this.flagExchange = true;
            mcsplus = new MCSPlus(this.target, this.source, this.shouldMatchBonds, this.shouldMatchRings, this.matchAtomType);
            overlaps = mcsplus.getOverlaps();
            mappings = Collections.synchronizedList(overlaps);
        }
        List<Map<Integer, Integer>> solutions = PostFilter.filter(mappings);
        this.setAllMapping(solutions);
        this.setAllAtomMapping();
        return mcsplus.isTimeout();
    }

    private synchronized void setAllMapping(List<Map<Integer, Integer>> solutions) {
        try {
            int counter = 0;
            int bestSolSize = 0;
            for (Map<Integer, Integer> solution : solutions) {
                SortedMap<Integer, Integer> validSolution = Collections.synchronizedSortedMap(new TreeMap());
                if (!this.flagExchange) {
                    for (Map.Entry<Integer, Integer> map : solution.entrySet()) {
                        validSolution.put(map.getKey(), map.getValue());
                    }
                } else {
                    for (Map.Entry<Integer, Integer> map : solution.entrySet()) {
                        validSolution.put(map.getValue(), map.getKey());
                    }
                }
                if (validSolution.size() > bestSolSize) {
                    bestSolSize = validSolution.size();
                    counter = 0;
                    this.allMCS.clear();
                }
                if (validSolution.size() != bestSolSize) continue;
                this.allMCS.add(counter++, validSolution);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setAllAtomMapping() {
        try {
            int counter = 0;
            for (Map<Integer, Integer> solution : this.allMCS) {
                AtomAtomMapping atomMappings = new AtomAtomMapping(this.source, this.target);
                for (Map.Entry<Integer, Integer> map : solution.entrySet()) {
                    int IIndex = map.getKey();
                    int JIndex = map.getValue();
                    IAtom sourceAtom = this.source.getAtom(IIndex);
                    IAtom targetAtom = this.target.getAtom(JIndex);
                    atomMappings.put(sourceAtom, targetAtom);
                }
                this.allAtomMCS.add(counter++, atomMappings);
            }
        }
        catch (Exception I) {
            I.getCause();
        }
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    public synchronized boolean isTimeout() {
        return this.timeout;
    }
}

