/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.smsd.algorithm.matchers.DefaultMatcher;
import org.openscience.smsd.algorithm.mcsplus.Edge;
import org.openscience.smsd.helper.LabelContainer;

public final class GenerateCompatibilityGraph
implements Serializable {
    private static final long serialVersionUID = 96986606860861L;
    private List<Integer> compGraphNodes = null;
    private List<Integer> compGraphNodesCZero = null;
    private final List<Integer> cEdges;
    private final List<Integer> dEdges;
    private int cEdgesSize = 0;
    private int dEdgesSize = 0;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private final boolean shouldMatchBonds;
    private final boolean shouldMatchRings;
    private final boolean matchAtomType;

    public GenerateCompatibilityGraph(IAtomContainer source, IAtomContainer target, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) throws IOException {
        this.shouldMatchRings = shouldMatchRings;
        this.shouldMatchBonds = shouldMatchBonds;
        this.matchAtomType = matchAtomType;
        this.source = source;
        this.target = target;
        this.compGraphNodes = new ArrayList<Integer>();
        this.compGraphNodesCZero = new ArrayList<Integer>();
        this.cEdges = Collections.synchronizedList(new ArrayList());
        this.dEdges = Collections.synchronizedList(new ArrayList());
        if (!(shouldMatchBonds && matchAtomType || source.getAtomCount() <= 30 || target.getAtomCount() <= 30)) {
            this.compatibilityGraphNodesIfCEdgeIsZero();
            this.compatibilityGraphCEdgeZero();
            this.clearCompGraphNodesCZero();
        } else {
            this.compatibilityGraphNodes();
            this.compatibilityGraph();
            if (this.getCEdgesSize() == 0) {
                this.clearCompGraphNodes();
                this.clearCEgdes();
                this.clearDEgdes();
                this.resetCEdgesSize();
                this.resetDEdgesSize();
                this.compatibilityGraphNodesIfCEdgeIsZero();
                this.compatibilityGraphCEdgeZero();
                this.clearCompGraphNodesCZero();
            }
        }
    }

    private Map<IAtom, List<String>> labelAtomsBySymbol(IAtomContainer atomCont) {
        HashMap<IAtom, List<String>> label_list = new HashMap<IAtom, List<String>>();
        for (int i = 0; i < atomCont.getAtomCount(); ++i) {
            ArrayList<String> label = new ArrayList<String>(7);
            for (int a = 0; a < 7; ++a) {
                label.add(a, "Z9");
            }
            IAtom refAtom = atomCont.getAtom(i);
            String referenceAtom = refAtom instanceof IQueryAtom ? (((IQueryAtom)refAtom).getSymbol() == null ? "*" : ((IQueryAtom)refAtom).getSymbol()) : (!(refAtom instanceof IQueryAtom) && this.matchAtomType ? (refAtom.getAtomTypeName() == null ? refAtom.getSymbol() : refAtom.getAtomTypeName()) : refAtom.getSymbol());
            label.set(0, referenceAtom);
            List<IAtom> connAtoms = atomCont.getConnectedAtomsList(refAtom);
            int counter = 1;
            for (IAtom negAtom : connAtoms) {
                String neighbouringAtom = refAtom instanceof IQueryAtom ? (((IQueryAtom)negAtom).getSymbol() == null ? "*" : ((IQueryAtom)negAtom).getSymbol()) : (!(negAtom instanceof IQueryAtom) && this.matchAtomType ? (negAtom.getAtomTypeName() == null ? negAtom.getSymbol() : negAtom.getAtomTypeName()) : negAtom.getSymbol());
                label.set(counter, neighbouringAtom);
                ++counter;
            }
            this.bubbleSort(label);
            label_list.put(refAtom, label);
        }
        return label_list;
    }

    private void bubbleSort(List<String> num) {
        boolean flag = true;
        while (flag) {
            flag = false;
            for (int j = 0; j < num.size() - 1; ++j) {
                if (num.get(j).compareTo(num.get(j + 1)) <= 0) continue;
                String temp = num.get(j);
                num.set(j, num.get(j + 1));
                num.set(j + 1, temp);
                flag = true;
            }
        }
    }

    private int compatibilityGraphNodes() throws IOException {
        this.compGraphNodes.clear();
        HashSet<Edge> edges = new HashSet<Edge>();
        int nodeCount = 1;
        Map<IAtom, List<String>> labelAtomsBySymbolA = this.labelAtomsBySymbol(this.source);
        Map<IAtom, List<String>> labelAtomsBySymbolB = this.labelAtomsBySymbol(this.target);
        for (Map.Entry<IAtom, List<String>> labelA : labelAtomsBySymbolA.entrySet()) {
            for (Map.Entry<IAtom, List<String>> labelB : labelAtomsBySymbolB.entrySet()) {
                int atomNumberJ;
                int atomNumberI;
                Edge e;
                IAtom atom = labelA.getKey();
                if ((!(atom instanceof IQueryAtom) || !((IQueryAtom)atom).matches(labelB.getKey())) && (atom instanceof IQueryAtom || !atom.getSymbol().equals(labelB.getKey().getSymbol())) || edges.contains(e = new Edge(atomNumberI = this.source.getAtomNumber(labelA.getKey()), atomNumberJ = this.target.getAtomNumber(labelB.getKey())))) continue;
                edges.add(e);
                this.compGraphNodes.add(atomNumberI);
                this.compGraphNodes.add(atomNumberJ);
                this.compGraphNodes.add(nodeCount);
                ++nodeCount;
            }
        }
        return 0;
    }

    private int compatibilityGraph() throws IOException {
        int comp_graph_nodes_List_size = this.compGraphNodes.size();
        for (int a = 0; a < comp_graph_nodes_List_size; a += 3) {
            for (int b = a; b < comp_graph_nodes_List_size; b += 3) {
                if (a == b || Objects.equals(this.compGraphNodes.get(a), this.compGraphNodes.get(b)) || Objects.equals(this.compGraphNodes.get(a + 1), this.compGraphNodes.get(b + 1))) continue;
                IBond reactantBond = this.source.getBond(this.source.getAtom(this.compGraphNodes.get(a)), this.source.getAtom(this.compGraphNodes.get(b)));
                IBond productBond = this.target.getBond(this.target.getAtom(this.compGraphNodes.get(a + 1)), this.target.getAtom(this.compGraphNodes.get(b + 1)));
                if (reactantBond != null && productBond != null) {
                    this.addEdges(reactantBond, productBond, a, b);
                    continue;
                }
                if (reactantBond != null || productBond != null) continue;
                this.dEdges.add(a / 3 + 1);
                this.dEdges.add(b / 3 + 1);
            }
        }
        this.cEdgesSize = this.cEdges.size();
        this.dEdgesSize = this.dEdges.size();
        return 0;
    }

    private void addEdges(IBond reactantBond, IBond productBond, int iIndex, int jIndex) {
        if (!(this.isMatchBond() || this.isMatchRings() || this.matchAtomType)) {
            if (this.isRawMatch(reactantBond, productBond)) {
                this.cEdges.add(iIndex / 3 + 1);
                this.cEdges.add(jIndex / 3 + 1);
            }
        } else if (this.isMatchFeasible(reactantBond, productBond, this.isMatchBond(), this.isMatchRings(), this.matchAtomType)) {
            this.cEdges.add(iIndex / 3 + 1);
            this.cEdges.add(jIndex / 3 + 1);
        } else {
            this.dEdges.add(iIndex / 3 + 1);
            this.dEdges.add(jIndex / 3 + 1);
        }
    }

    private boolean isRawMatch(IBond reactantBond, IBond productBond) {
        return reactantBond.getAtom(0).getSymbol().equals(productBond.getAtom(0).getSymbol()) && reactantBond.getAtom(1).getSymbol().equals(productBond.getAtom(1).getSymbol()) ? reactantBond.getAtom(0).getHybridization().equals((Object)productBond.getAtom(0).getHybridization()) && reactantBond.getAtom(1).getHybridization().equals((Object)productBond.getAtom(1).getHybridization()) : reactantBond.getAtom(1).getSymbol().equals(productBond.getAtom(0).getSymbol()) && reactantBond.getAtom(0).getSymbol().equals(productBond.getAtom(1).getSymbol()) && reactantBond.getAtom(1).getHybridization().equals((Object)productBond.getAtom(0).getHybridization()) && reactantBond.getAtom(0).getHybridization().equals((Object)productBond.getAtom(1).getHybridization());
    }

    private Integer compatibilityGraphNodesIfCEdgeIsZero() throws IOException {
        int count_nodes = 1;
        ArrayList<String> list = new ArrayList<String>();
        this.compGraphNodesCZero = new ArrayList<Integer>();
        LabelContainer labelContainer = LabelContainer.getInstance();
        this.compGraphNodes.clear();
        for (int i = 0; i < this.source.getAtomCount(); ++i) {
            for (int j = 0; j < this.target.getAtomCount(); ++j) {
                IAtom atom1 = this.source.getAtom(i);
                IAtom atom2 = this.target.getAtom(j);
                if (atom1 instanceof IQueryAtom && ((IQueryAtom)atom1).matches(atom2) && !list.contains(i + "_" + j)) {
                    this.compGraphNodesCZero.add(i);
                    this.compGraphNodesCZero.add(j);
                    this.compGraphNodesCZero.add(labelContainer.getLabelID(atom2.getSymbol()));
                    this.compGraphNodesCZero.add(count_nodes);
                    this.compGraphNodes.add(i);
                    this.compGraphNodes.add(j);
                    this.compGraphNodes.add(count_nodes);
                    ++count_nodes;
                    list.add(i + "_" + j);
                    continue;
                }
                if (!atom1.getSymbol().equalsIgnoreCase(atom2.getSymbol()) || list.contains(i + "_" + j)) continue;
                this.compGraphNodesCZero.add(i);
                this.compGraphNodesCZero.add(j);
                this.compGraphNodesCZero.add(labelContainer.getLabelID(atom1.getSymbol()));
                this.compGraphNodesCZero.add(count_nodes);
                this.compGraphNodes.add(i);
                this.compGraphNodes.add(j);
                this.compGraphNodes.add(count_nodes);
                ++count_nodes;
                list.add(i + "_" + j);
            }
        }
        list.clear();
        return count_nodes;
    }

    private int compatibilityGraphCEdgeZero() throws IOException {
        int compGraphNodesCZeroListSize = this.compGraphNodesCZero.size();
        for (int a = 0; a < compGraphNodesCZeroListSize; a += 4) {
            int index_a = this.compGraphNodesCZero.get(a);
            int index_aPlus1 = this.compGraphNodesCZero.get(a + 1);
            for (int b = a + 4; b < compGraphNodesCZeroListSize; b += 4) {
                int index_b = this.compGraphNodesCZero.get(b);
                int index_bPlus1 = this.compGraphNodesCZero.get(b + 1);
                if (a == b || index_a == index_b || index_aPlus1 == index_bPlus1) continue;
                IBond reactantBond = this.source.getBond(this.source.getAtom(index_a), this.source.getAtom(index_b));
                IBond productBond = this.target.getBond(this.target.getAtom(index_aPlus1), this.target.getAtom(index_bPlus1));
                if (reactantBond != null && productBond != null) {
                    this.addZeroEdges(reactantBond, productBond, a, b);
                    continue;
                }
                if (reactantBond != null || productBond != null || this.source.getAtomCount() >= 50 || this.target.getAtomCount() >= 50) continue;
                this.dEdges.add(a / 4 + 1);
                this.dEdges.add(b / 4 + 1);
            }
        }
        this.cEdgesSize = this.cEdges.size();
        this.dEdgesSize = this.dEdges.size();
        return 0;
    }

    private void addZeroEdges(IBond reactantBond, IBond productBond, int indexI, int indexJ) {
        if (this.isMatchFeasible(reactantBond, productBond, this.isMatchBond(), this.isMatchRings(), this.matchAtomType)) {
            this.cEdges.add(indexI / 4 + 1);
            this.cEdges.add(indexJ / 4 + 1);
        } else {
            this.dEdges.add(indexI / 4 + 1);
            this.dEdges.add(indexJ / 4 + 1);
        }
    }

    private boolean isMatchFeasible(IBond bondA1, IBond bondA2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        if (bondA1 instanceof IQueryBond) {
            if (((IQueryBond)bondA1).matches(bondA2)) {
                IQueryAtom atom1 = (IQueryAtom)bondA1.getAtom(0);
                IQueryAtom atom2 = (IQueryAtom)bondA1.getAtom(1);
                return atom1.matches(bondA2.getAtom(0)) && atom2.matches(bondA2.getAtom(1)) || atom1.matches(bondA2.getAtom(1)) && atom2.matches(bondA2.getAtom(0));
            }
            return false;
        }
        return DefaultMatcher.matches(bondA1, bondA2, shouldMatchBonds, shouldMatchRings, matchAtomType);
    }

    public synchronized List<Integer> getCEgdes() {
        return Collections.synchronizedList(this.cEdges);
    }

    public synchronized List<Integer> getDEgdes() {
        return Collections.synchronizedList(this.dEdges);
    }

    public synchronized List<Integer> getCompGraphNodes() {
        return Collections.synchronizedList(this.compGraphNodes);
    }

    protected synchronized int getCEdgesSize() {
        return this.cEdgesSize;
    }

    protected synchronized int getDEdgesSize() {
        return this.dEdgesSize;
    }

    private List<Integer> getCompGraphNodesCZero() {
        return Collections.unmodifiableList(this.compGraphNodesCZero);
    }

    private void clearCEgdes() {
        this.cEdges.clear();
    }

    private void clearDEgdes() {
        this.dEdges.clear();
    }

    private void clearCompGraphNodes() {
        this.compGraphNodes.clear();
    }

    private void clearCompGraphNodesCZero() {
        this.compGraphNodesCZero.clear();
    }

    private void resetCEdgesSize() {
        this.cEdgesSize = 0;
    }

    private void resetDEdgesSize() {
        this.dEdgesSize = 0;
    }

    public synchronized void clear() {
        this.cEdges.clear();
        this.dEdges.clear();
        this.compGraphNodes.clear();
        this.compGraphNodesCZero.clear();
    }

    private boolean isMatchBond() {
        return this.shouldMatchBonds;
    }

    private boolean isMatchRings() {
        return this.shouldMatchRings;
    }
}

