/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ExactMapping {
    private static List<Integer> extractCliqueMapping(List<Integer> comp_graph_nodes, List<Integer> clique_List_org) {
        List<Integer> clique_mapping = Collections.synchronizedList(new ArrayList());
        ArrayList<Integer> clique_List = new ArrayList<Integer>(clique_List_org);
        int clique_siz = clique_List.size();
        int vec_size = comp_graph_nodes.size();
        for (int a = 0; a < clique_siz; ++a) {
            for (int b = 0; b < vec_size; b += 3) {
                if (clique_List.get(a) != comp_graph_nodes.get(b + 2)) continue;
                clique_mapping.add(comp_graph_nodes.get(b));
                clique_mapping.add(comp_graph_nodes.get(b + 1));
            }
        }
        return clique_mapping;
    }

    public static List<List<Integer>> extractMapping(List<List<Integer>> _mappings, List<Integer> comp_graph_nodes, List<Integer> clique_List_org) {
        try {
            List<Integer> clique_List = ExactMapping.extractCliqueMapping(comp_graph_nodes, clique_List_org);
            _mappings.add(clique_List);
        }
        catch (Exception e) {
            System.err.println("Error in FinalMapping List: " + e.getCause());
            e.printStackTrace();
            System.exit(1);
        }
        return _mappings;
    }

    public static Map<Integer, Integer> extractMapping(List<Integer> comp_graph_nodes, List<Integer> clique_List_org) {
        SortedMap<Integer, Integer> clique_mapping = Collections.synchronizedSortedMap(new TreeMap());
        try {
            ArrayList<Integer> clique_List = new ArrayList<Integer>(clique_List_org);
            for (int a = 0; a < clique_List.size(); ++a) {
                for (int b = 0; b < comp_graph_nodes.size(); b += 3) {
                    if (clique_List.get(a) != comp_graph_nodes.get(b + 2)) continue;
                    clique_mapping.put(comp_graph_nodes.get(b), comp_graph_nodes.get(b + 1));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in FinalMapping List: " + e.getCause());
            e.printStackTrace();
            System.exit(1);
        }
        return clique_mapping;
    }
}

