/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.matchers;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.smsd.algorithm.matchers.BondMatcher;
import org.openscience.smsd.algorithm.matchers.DefaultAtomMatcher;
import org.openscience.smsd.algorithm.matchers.DefaultAtomTypeMatcher;
import org.openscience.smsd.algorithm.matchers.DefaultBondMatcher;

public class DefaultMatcher {
    private static boolean isBondMatch(BondMatcher queryBondMatcher, IBond targetBond) {
        return queryBondMatcher.matches(targetBond);
    }

    private static boolean isAtomMatch(IBond bondA1, IBond bondA2, boolean shouldMatchRings, boolean matchAtomTypes) {
        AtomMatcher atomMatcher2;
        AtomMatcher atomMatcher1;
        if (matchAtomTypes) {
            atomMatcher1 = new DefaultAtomTypeMatcher(bondA1.getAtom(0), shouldMatchRings);
            atomMatcher2 = new DefaultAtomTypeMatcher(bondA1.getAtom(1), shouldMatchRings);
        } else {
            atomMatcher1 = new DefaultAtomMatcher(bondA1.getAtom(0), shouldMatchRings);
            atomMatcher2 = new DefaultAtomMatcher(bondA1.getAtom(1), shouldMatchRings);
        }
        if (atomMatcher1.matches(bondA2.getAtom(0)) && atomMatcher2.matches(bondA2.getAtom(1))) {
            return true;
        }
        return atomMatcher1.matches(bondA2.getAtom(1)) && atomMatcher2.matches(bondA2.getAtom(0));
    }

    public static boolean matches(IBond bondA1, IBond bondA2, boolean matchBond, boolean shouldMatchRings, boolean matchAtomTypes) {
        if (!DefaultMatcher.isAtomMatch(bondA1, bondA2, shouldMatchRings, matchAtomTypes)) {
            return false;
        }
        return DefaultMatcher.isBondMatch(new DefaultBondMatcher(bondA1, matchBond, shouldMatchRings, matchAtomTypes), bondA2);
    }
}

