/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public final class AtomAtomMapping
implements Serializable {
    private static final long serialVersionUID = 1223637237262778L;
    private final IAtomContainer query;
    private final IAtomContainer target;
    private final Map<IAtom, IAtom> mapping;
    private final Map<Integer, Integer> mappingIndex;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtomAtomMapping other = (AtomAtomMapping)obj;
        if (!(this.getQuery() == other.getQuery() || this.getQuery() != null && this.query.equals(other.query))) {
            return false;
        }
        if (!(this.getTarget() == other.getTarget() || this.getTarget() != null && this.target.equals(other.target))) {
            return false;
        }
        if (!(this.mapping == other.getMappingsByAtoms() || this.mapping != null && this.mapping.equals(other.mapping))) {
            return false;
        }
        return this.mappingIndex == other.getMappingsByIndex() || this.mappingIndex != null && this.mappingIndex.equals(other.mappingIndex);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.getQuery() != null ? this.getQuery().hashCode() : 0);
        hash = 67 * hash + (this.getTarget() != null ? this.getTarget().hashCode() : 0);
        hash = 67 * hash + (this.mapping != null ? this.getMappingsByAtoms().hashCode() : 0);
        hash = 67 * hash + (this.mappingIndex != null ? this.getMappingsByIndex().hashCode() : 0);
        return hash;
    }

    public AtomAtomMapping(IAtomContainer query2, IAtomContainer target) {
        this.query = query2;
        this.target = target;
        this.mapping = new TreeMap<IAtom, IAtom>(new MyQueryIAtomComp());
        this.mappingIndex = Collections.synchronizedSortedMap(new TreeMap());
    }

    public synchronized void put(IAtom atom1, IAtom atom2) {
        this.mapping.put(atom1, atom2);
        this.mappingIndex.put(this.getQuery().getAtomNumber(atom1), this.getTarget().getAtomNumber(atom2));
    }

    public synchronized String toString() {
        StringBuilder s = new StringBuilder();
        try {
            IReaction reaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
            reaction.addReactant(this.getQuery().clone(), 1.0);
            reaction.addProduct(this.getTarget().clone(), 1.0);
            int counter = 1;
            for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
                for (IAtom a : ac.atoms()) {
                    IAtom refAtom = this.getQuery().getAtom(ac.getAtomNumber(a));
                    if (this.mapping.containsKey(refAtom)) {
                        a.setProperty("cdk:AtomAtomMapping", counter);
                        a.setFlag(128, true);
                        IAtom mappedAtom = this.mapping.get(refAtom);
                        int mappedAtomIndex = this.getTarget().getAtomNumber(mappedAtom);
                        IAtom b = reaction.getProducts().getAtomContainer(0).getAtom(mappedAtomIndex);
                        b.setProperty("cdk:AtomAtomMapping", counter);
                        b.setFlag(128, true);
                        IMapping aammapping = reaction.getBuilder().newInstance(IMapping.class, a, b);
                        reaction.addMapping(aammapping);
                    }
                    ++counter;
                }
            }
            String createReactionSMILES = "NA";
            try {
                SmilesGenerator withAtomClasses = SmilesGenerator.generic().aromatic().withAtomClasses();
                createReactionSMILES = withAtomClasses.createReactionSMILES(reaction);
            }
            catch (CDKException ex) {
                Logger.getLogger(AtomAtomMapping.class.getName()).log(Level.SEVERE, null, ex);
            }
            s.append("MMP: ").append(createReactionSMILES).append(", AAM:[");
            for (IAtom firstAtom : this.mapping.keySet()) {
                int keyIndex = this.getQuery().getAtomNumber(firstAtom) + 1;
                int valueIndex = this.getTarget().getAtomNumber(this.mapping.get(firstAtom)) + 1;
                s.append(keyIndex).append(":").append(valueIndex).append("|");
            }
            s.append("]");
            try {
                s.append(", MCS: ").append(this.getCommonFragmentAsSMILES());
            }
            catch (CDKException ex) {
                Logger.getLogger(AtomAtomMapping.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(AtomAtomMapping.class.getName()).log(Level.SEVERE, null, ex);
        }
        return s.toString();
    }

    public synchronized boolean isEmpty() {
        return this.mapping.isEmpty();
    }

    public synchronized void clear() {
        this.mapping.clear();
        this.mappingIndex.clear();
    }

    public synchronized int getCount() {
        return this.mapping.isEmpty() ? 0 : this.mapping.size();
    }

    public synchronized Map<IAtom, IAtom> getMappingsByAtoms() {
        return Collections.unmodifiableMap(new LinkedHashMap<IAtom, IAtom>(this.mapping));
    }

    public synchronized Map<Integer, Integer> getMappingsByIndex() {
        return Collections.unmodifiableSortedMap(new TreeMap<Integer, Integer>(this.mappingIndex));
    }

    public synchronized int getQueryIndex(IAtom atom) {
        return this.getQuery().getAtomNumber(atom);
    }

    public synchronized int getTargetIndex(IAtom atom) {
        return this.getTarget().getAtomNumber(atom);
    }

    public synchronized IAtomContainer getQuery() {
        return this.query;
    }

    public synchronized IAtomContainer getTarget() {
        return this.target;
    }

    public synchronized IAtomContainer getMapCommonFragmentOnQuery() throws CloneNotSupportedException {
        IAtomContainer ac = this.getQuery().clone();
        List<IAtom> uniqueAtoms = Collections.synchronizedList(new ArrayList());
        for (IAtom atom2 : this.getQuery().atoms()) {
            if (this.mapping.containsKey(atom2)) continue;
            uniqueAtoms.add(ac.getAtom(this.getQueryIndex(atom2)));
        }
        uniqueAtoms.stream().forEach(atom -> ac.removeAtomAndConnectedElectronContainers((IAtom)atom));
        return ac;
    }

    public synchronized IAtomContainer getMapCommonFragmentOnTarget() throws CloneNotSupportedException {
        IAtomContainer ac = this.getTarget().clone();
        List<IAtom> uniqueAtoms = Collections.synchronizedList(new ArrayList());
        for (IAtom atom2 : this.getTarget().atoms()) {
            if (this.mapping.containsValue(atom2)) continue;
            uniqueAtoms.add(ac.getAtom(this.getTargetIndex(atom2)));
        }
        uniqueAtoms.stream().forEach(atom -> ac.removeAtomAndConnectedElectronContainers((IAtom)atom));
        return ac;
    }

    public synchronized IAtomContainer getCommonFragment() throws CloneNotSupportedException {
        IAtomContainer ac = this.getQuery().clone();
        List<IAtom> uniqueAtoms = Collections.synchronizedList(new ArrayList());
        for (IAtom atom2 : this.getQuery().atoms()) {
            if (this.mapping.containsKey(atom2)) continue;
            uniqueAtoms.add(ac.getAtom(this.getQueryIndex(atom2)));
        }
        for (IBond bond : this.getQuery().bonds()) {
            IAtom atom1ForBondInTarget = this.mapping.get(bond.getAtom(0));
            IAtom atom2ForBondInTarget = this.mapping.get(bond.getAtom(1));
            IBond bondInTarget = this.getTarget().getBond(atom1ForBondInTarget, atom2ForBondInTarget);
            if (bondInTarget != null) continue;
            IAtom atom1InCommonContainer = ac.getAtom(this.getQueryIndex(bond.getAtom(0)));
            IAtom atom2InCommonContainer = ac.getAtom(this.getQueryIndex(bond.getAtom(1)));
            ac.removeBond(ac.getBond(atom1InCommonContainer, atom2InCommonContainer));
        }
        uniqueAtoms.stream().forEach(atom -> ac.removeAtomAndConnectedElectronContainers((IAtom)atom));
        try {
            CDKHydrogenAdder.getInstance(ac.getBuilder()).addImplicitHydrogens(ac);
        }
        catch (CDKException ex) {
            Logger.getLogger(AtomAtomMapping.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
        }
        catch (CDKException ex) {
            Logger.getLogger(AtomAtomMapping.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ac;
    }

    public synchronized String getCommonFragmentAsSMILES() throws CloneNotSupportedException, CDKException {
        SmilesGenerator aromatic = SmilesGenerator.unique().withAtomClasses();
        return aromatic.create(this.getCommonFragment());
    }

    public Map<IAtom, IAtom> sortByValues(Map<IAtom, IAtom> map) {
        LinkedList<Map.Entry<IAtom, IAtom>> entries = new LinkedList<Map.Entry<IAtom, IAtom>>(map.entrySet());
        Collections.sort(entries, (o1, o2) -> {
            int atomNumber1 = this.getQuery().getAtomNumber((IAtom)o1.getKey());
            int atomNumber2 = this.getQuery().getAtomNumber((IAtom)o2.getKey());
            return atomNumber1 - atomNumber2;
        });
        LinkedHashMap<IAtom, IAtom> sortedMap = new LinkedHashMap<IAtom, IAtom>();
        entries.stream().forEach(entry -> sortedMap.put((IAtom)entry.getKey(), (IAtom)entry.getValue()));
        return sortedMap;
    }

    class MyQueryIAtomComp
    implements Comparator<IAtom> {
        MyQueryIAtomComp() {
        }

        @Override
        public int compare(IAtom o1, IAtom o2) {
            int atomNumber1 = AtomAtomMapping.this.getQuery().getAtomNumber(o1);
            int atomNumber2 = AtomAtomMapping.this.getQuery().getAtomNumber(o2);
            return atomNumber1 - atomNumber2;
        }
    }
}

