/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ArrowElement;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

public class ReactionArrowGenerator
implements IGenerator<IReaction> {
    @Override
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        Rectangle2D totalBoundsReactants = BoundsCalculator.calculateBounds(reaction.getReactants());
        Rectangle2D totalBoundsProducts = BoundsCalculator.calculateBounds(reaction.getProducts());
        if (totalBoundsReactants == null || totalBoundsProducts == null) {
            return null;
        }
        double separation = (Double)model.getParameter(BasicSceneGenerator.BondLength.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        Color foregroundColor = (Color)model.getParameter(BasicSceneGenerator.ForegroundColor.class).getValue();
        return new ArrowElement(totalBoundsReactants.getMaxX() + separation, totalBoundsReactants.getCenterY(), totalBoundsProducts.getMinX() - separation, totalBoundsReactants.getCenterY(), 1.0 / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue(), true, foregroundColor);
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(new IGeneratorParameter[0]);
    }
}

