/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class AromaticBondsCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private static final String[] NAMES = new String[]{"nAromBond"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#aromaticBondsCount", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("AromaticBondsCountDescriptor expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer ac;
        try {
            ac = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Error during clone"));
        }
        int aromaticBondsCount = 0;
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(ac);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Error during atom type perception"));
            }
            try {
                Aromaticity.cdkLegacy().apply(ac);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("Error during aromaticity detection: " + e.getMessage()));
            }
        }
        for (IBond bond : ac.bonds()) {
            if (!bond.getFlag(32)) continue;
            ++aromaticBondsCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(aromaticBondsCount), this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        return true;
    }
}

