/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.Mappings;
import org.openscience.cdk.isomorphism.Pattern;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SmartsMatchers;
import org.openscience.cdk.pharmacophore.PharmacophoreAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQuery;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAngleBond;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreQueryBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class PharmacophoreMatcher {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(PharmacophoreMatcher.class);
    private PharmacophoreQuery pharmacophoreQuery = null;
    private IAtomContainer pharmacophoreMolecule = null;
    private Mappings mappings = null;
    private final Aromaticity arom = new Aromaticity(ElectronDonation.daylight(), Cycles.or(Cycles.all(), Cycles.relevant()));

    public PharmacophoreMatcher() {
    }

    public PharmacophoreMatcher(PharmacophoreQuery pharmacophoreQuery) {
        this.pharmacophoreQuery = pharmacophoreQuery;
    }

    public boolean matches(IAtomContainer atomContainer) throws CDKException {
        return this.matches(atomContainer, true);
    }

    public boolean matches(IAtomContainer atomContainer, boolean initializeTarget) throws CDKException {
        if (!GeometryUtil.has3DCoordinates(atomContainer)) {
            throw new CDKException("Molecule must have 3D coordinates");
        }
        if (this.pharmacophoreQuery == null) {
            throw new CDKException("Must set the query pharmacophore before matching");
        }
        if (!this.checkQuery(this.pharmacophoreQuery)) {
            throw new CDKException("A problem in the query. Make sure all pharmacophore groups of the same symbol have the same same SMARTS");
        }
        String title = (String)atomContainer.getProperty("cdk:Title");
        if (initializeTarget) {
            this.pharmacophoreMolecule = this.getPharmacophoreMolecule(atomContainer);
        } else {
            for (IAtom iAtom : this.pharmacophoreMolecule.atoms()) {
                PharmacophoreAtom patom = (PharmacophoreAtom)iAtom;
                ArrayList<Integer> tmpList = new ArrayList<Integer>();
                for (int idx : patom.getMatchingAtoms()) {
                    tmpList.add(idx);
                }
                Point3d coords = this.getEffectiveCoordinates(atomContainer, tmpList);
                patom.setPoint3d(coords);
            }
        }
        if (this.pharmacophoreMolecule.getAtomCount() < this.pharmacophoreQuery.getAtomCount()) {
            this.logger.debug("Target [" + title + "] did not match the query SMARTS. Skipping constraints");
            return false;
        }
        this.mappings = Pattern.findSubstructure(this.pharmacophoreQuery).matchAll(this.pharmacophoreMolecule);
        return this.mappings.atLeast(1);
    }

    public List<List<IBond>> getMatchingPharmacophoreBonds() {
        if (this.mappings == null) {
            return null;
        }
        ArrayList<List<IBond>> bonds = new ArrayList<List<IBond>>();
        for (Map<IBond, IBond> map : this.mappings.toBondMap()) {
            bonds.add(new ArrayList<IBond>(map.values()));
        }
        return bonds;
    }

    public List<HashMap<IBond, IBond>> getTargetQueryBondMappings() {
        if (this.mappings == null) {
            return null;
        }
        ArrayList<HashMap<IBond, IBond>> bondMap = new ArrayList<HashMap<IBond, IBond>>();
        for (Map<IBond, IBond> map : this.mappings.toBondMap()) {
            bondMap.add(new HashMap<IBond, IBond>(HashBiMap.create(map).inverse()));
        }
        return bondMap;
    }

    public List<List<PharmacophoreAtom>> getMatchingPharmacophoreAtoms() {
        if (this.pharmacophoreMolecule == null || this.mappings == null) {
            return null;
        }
        return this.getPCoreAtoms(this.mappings);
    }

    public List<List<PharmacophoreAtom>> getUniqueMatchingPharmacophoreAtoms() {
        if (this.pharmacophoreMolecule == null || this.mappings == null) {
            return null;
        }
        return this.getPCoreAtoms(this.mappings.uniqueAtoms());
    }

    private List<List<PharmacophoreAtom>> getPCoreAtoms(Mappings mappings) {
        ArrayList<List<PharmacophoreAtom>> atoms = new ArrayList<List<PharmacophoreAtom>>();
        for (Map<IAtom, IAtom> map : mappings.toAtomMap()) {
            ArrayList<PharmacophoreAtom> pcoreatoms = new ArrayList<PharmacophoreAtom>();
            for (IAtom atom : map.values()) {
                pcoreatoms.add((PharmacophoreAtom)atom);
            }
            atoms.add(pcoreatoms);
        }
        return atoms;
    }

    public PharmacophoreQuery getPharmacophoreQuery() {
        return this.pharmacophoreQuery;
    }

    public void setPharmacophoreQuery(PharmacophoreQuery query2) {
        this.pharmacophoreQuery = query2;
    }

    private IAtomContainer getPharmacophoreMolecule(IAtomContainer input) throws CDKException {
        this.prepareInput(input);
        IAtomContainer pharmacophoreMolecule = input.getBuilder().newInstance(IAtomContainer.class, 0, 0, 0, 0);
        HashSet<String> matched = new HashSet<String>();
        LinkedHashSet<PharmacophoreAtom> uniqueAtoms = new LinkedHashSet<PharmacophoreAtom>();
        this.logger.debug("Converting [" + input.getProperty("cdk:Title") + "] to a pcore molecule");
        for (IAtom atom : this.pharmacophoreQuery.atoms()) {
            PharmacophoreQueryAtom qatom = (PharmacophoreQueryAtom)atom;
            String smarts = qatom.getSmarts();
            if (!matched.add(qatom.getSymbol())) continue;
            int count = 0;
            for (IQueryAtomContainer query2 : qatom.getCompiledSmarts()) {
                Mappings mappings = Pattern.findSubstructure(query2).matchAll(input).uniqueAtoms();
                for (int[] mapping : mappings) {
                    uniqueAtoms.add(this.newPCoreAtom(input, qatom, smarts, mapping));
                    ++count;
                }
            }
            this.logger.debug("\tFound " + count + " unique matches for " + smarts);
        }
        pharmacophoreMolecule.setAtoms(uniqueAtoms.toArray(new IAtom[uniqueAtoms.size()]));
        if (this.hasDistanceConstraints(this.pharmacophoreQuery)) {
            int npatom = pharmacophoreMolecule.getAtomCount();
            for (int i = 0; i < npatom - 1; ++i) {
                for (int j = i + 1; j < npatom; ++j) {
                    PharmacophoreAtom atom1 = (PharmacophoreAtom)pharmacophoreMolecule.getAtom(i);
                    PharmacophoreAtom atom2 = (PharmacophoreAtom)pharmacophoreMolecule.getAtom(j);
                    PharmacophoreBond bond = new PharmacophoreBond(atom1, atom2);
                    pharmacophoreMolecule.addBond(bond);
                }
            }
        }
        if (this.hasAngleConstraints(this.pharmacophoreQuery)) {
            int nangleDefs = 0;
            for (IBond bond : this.pharmacophoreQuery.bonds()) {
                if (!(bond instanceof PharmacophoreQueryAngleBond)) continue;
                IAtom startQAtom = bond.getAtom(0);
                IAtom middleQAtom = bond.getAtom(1);
                IAtom endQAtom = bond.getAtom(2);
                ArrayList<IAtom> startl = new ArrayList<IAtom>();
                ArrayList<IAtom> middlel = new ArrayList<IAtom>();
                ArrayList<IAtom> endl = new ArrayList<IAtom>();
                for (IAtom tatom : pharmacophoreMolecule.atoms()) {
                    if (tatom.getSymbol().equals(startQAtom.getSymbol())) {
                        startl.add(tatom);
                    }
                    if (tatom.getSymbol().equals(middleQAtom.getSymbol())) {
                        middlel.add(tatom);
                    }
                    if (!tatom.getSymbol().equals(endQAtom.getSymbol())) continue;
                    endl.add(tatom);
                }
                ArrayList<IAtom[]> tmpl = new ArrayList<IAtom[]>();
                for (IAtom middle : middlel) {
                    for (IAtom start : startl) {
                        if (middle.equals(start)) continue;
                        for (IAtom end : endl) {
                            if (start.equals(end) || middle.equals(end)) continue;
                            tmpl.add(new IAtom[]{start, middle, end});
                        }
                    }
                }
                ArrayList<IAtom[]> unique = new ArrayList<IAtom[]>();
                for (int i = 0; i < tmpl.size(); ++i) {
                    IAtom[] seq1 = (IAtom[])tmpl.get(i);
                    boolean isRepeat = false;
                    for (int j = 0; j < unique.size(); ++j) {
                        IAtom[] seq2;
                        if (i == j || seq1[1] != (seq2 = (IAtom[])unique.get(j))[1] || seq1[0] != seq2[2] || seq1[2] != seq2[0]) continue;
                        isRepeat = true;
                    }
                    if (isRepeat) continue;
                    unique.add(seq1);
                }
                for (IAtom[] seq : unique) {
                    PharmacophoreAngleBond pbond = new PharmacophoreAngleBond((PharmacophoreAtom)seq[0], (PharmacophoreAtom)seq[1], (PharmacophoreAtom)seq[2]);
                    pharmacophoreMolecule.addBond(pbond);
                    ++nangleDefs;
                }
            }
            this.logger.debug("Added " + nangleDefs + " defs to the target pcore molecule");
        }
        return pharmacophoreMolecule;
    }

    private PharmacophoreAtom newPCoreAtom(IAtomContainer input, PharmacophoreQueryAtom qatom, String smarts, int[] mapping) {
        Point3d coords = this.getEffectiveCoordinates(input, mapping);
        PharmacophoreAtom patom = new PharmacophoreAtom(smarts, qatom.getSymbol(), coords);
        patom.setMatchingAtoms(mapping);
        return patom;
    }

    private void prepareInput(IAtomContainer input) throws CDKException {
        SmartsMatchers.prepare(input, true);
        this.arom.apply(input);
    }

    private boolean hasDistanceConstraints(IQueryAtomContainer query2) {
        for (IBond bond : query2.bonds()) {
            if (!(bond instanceof PharmacophoreQueryBond)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAngleConstraints(IQueryAtomContainer query2) {
        for (IBond bond : query2.bonds()) {
            if (!(bond instanceof PharmacophoreQueryAngleBond)) continue;
            return true;
        }
        return false;
    }

    private int[] intIndices(List<Integer> atomIndices) {
        int[] ret = new int[atomIndices.size()];
        for (int i = 0; i < atomIndices.size(); ++i) {
            ret[i] = atomIndices.get(i);
        }
        return ret;
    }

    private Point3d getEffectiveCoordinates(IAtomContainer atomContainer, List<Integer> atomIndices) {
        Point3d ret = new Point3d(0.0, 0.0, 0.0);
        for (Integer atomIndice : atomIndices) {
            int atomIndex = atomIndice;
            Point3d coord = atomContainer.getAtom(atomIndex).getPoint3d();
            ret.x += coord.x;
            ret.y += coord.y;
            ret.z += coord.z;
        }
        ret.x /= (double)atomIndices.size();
        ret.y /= (double)atomIndices.size();
        ret.z /= (double)atomIndices.size();
        return ret;
    }

    private Point3d getEffectiveCoordinates(IAtomContainer atomContainer, int[] atomIndices) {
        Point3d ret = new Point3d(0.0, 0.0, 0.0);
        for (int i : atomIndices) {
            Point3d coord = atomContainer.getAtom(i).getPoint3d();
            ret.x += coord.x;
            ret.y += coord.y;
            ret.z += coord.z;
        }
        ret.x /= (double)atomIndices.length;
        ret.y /= (double)atomIndices.length;
        ret.z /= (double)atomIndices.length;
        return ret;
    }

    private boolean checkQuery(IQueryAtomContainer query2) {
        if (!(query2 instanceof PharmacophoreQuery)) {
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < query2.getAtomCount(); ++i) {
            IQueryAtom atom = (IQueryAtom)query2.getAtom(i);
            if (!(atom instanceof PharmacophoreQueryAtom)) {
                return false;
            }
            PharmacophoreQueryAtom pqatom = (PharmacophoreQueryAtom)atom;
            String label = pqatom.getSymbol();
            String smarts = pqatom.getSmarts();
            if (!map.containsKey(label)) {
                map.put(label, smarts);
                continue;
            }
            if (((String)map.get(label)).equals(smarts)) continue;
            return false;
        }
        return true;
    }
}

