/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.CRC32;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class CircularFingerprinter
implements IFingerprinter {
    public static final int CLASS_ECFP0 = 1;
    public static final int CLASS_ECFP2 = 2;
    public static final int CLASS_ECFP4 = 3;
    public static final int CLASS_ECFP6 = 4;
    public static final int CLASS_FCFP0 = 5;
    public static final int CLASS_FCFP2 = 6;
    public static final int CLASS_FCFP4 = 7;
    public static final int CLASS_FCFP6 = 8;
    private final int ATOMCLASS_ECFP = 1;
    private final int ATOMCLASS_FCFP = 2;
    private int classType;
    private int atomClass;
    private IAtomContainer mol;
    private final int length;
    private int[] identity;
    private boolean[] resolvedChiral;
    private int[][] atomGroup;
    private CRC32 crc = new CRC32();
    private ArrayList<FP> fplist = new ArrayList();
    private boolean[] amask;
    private int[] hcount;
    private int[][] atomAdj;
    private int[][] bondAdj;
    private int[] ringBlock;
    private int[][] smallRings;
    private int[] bondOrder;
    private boolean[] atomArom;
    private boolean[] bondArom;
    private int[][] tetra;
    private boolean[] maskDon;
    private boolean[] maskAcc;
    private boolean[] maskPos;
    private boolean[] maskNeg;
    private boolean[] maskAro;
    private boolean[] maskHal;
    private int[] bondSum;
    private boolean[] hasDouble;
    private boolean[] aliphatic;
    private boolean[] isOxide;
    private boolean[] lonePair;
    private boolean[] tetrazole;

    public CircularFingerprinter() {
        this(4);
    }

    public CircularFingerprinter(int classType) {
        this(classType, 1024);
    }

    public CircularFingerprinter(int classType, int len) {
        if (classType < 1 || classType > 8) {
            throw new IllegalArgumentException("Invalid classType specified: " + classType);
        }
        this.classType = classType;
        this.length = len;
    }

    public void calculate(IAtomContainer mol) throws CDKException {
        this.mol = mol;
        this.fplist.clear();
        this.atomClass = this.classType <= 4 ? 1 : 2;
        this.excavateMolecule();
        if (this.atomClass == 2) {
            this.calculateBioTypes();
        }
        int na = mol.getAtomCount();
        this.identity = new int[na];
        this.resolvedChiral = new boolean[na];
        this.atomGroup = new int[na][];
        for (int n = 0; n < na; ++n) {
            if (!this.amask[n]) continue;
            this.identity[n] = this.atomClass == 1 ? this.initialIdentityECFP(n) : this.initialIdentityFCFP(n);
            this.atomGroup[n] = new int[]{n};
            this.fplist.add(new FP(this.identity[n], 0, this.atomGroup[n]));
        }
        int niter = this.classType == 2 || this.classType == 6 ? 1 : (this.classType == 3 || this.classType == 7 ? 2 : (this.classType == 4 || this.classType == 8 ? 3 : 0));
        for (int iter = 1; iter <= niter; ++iter) {
            int n;
            int[] newident = new int[na];
            for (n = 0; n < na; ++n) {
                if (!this.amask[n]) continue;
                newident[n] = this.circularIterate(iter, n);
            }
            this.identity = newident;
            for (n = 0; n < na; ++n) {
                if (!this.amask[n]) continue;
                this.atomGroup[n] = this.growAtoms(this.atomGroup[n]);
                this.considerNewFP(new FP(this.identity[n], iter, this.atomGroup[n]));
            }
        }
    }

    public int getFPCount() {
        return this.fplist.size();
    }

    public FP getFP(int N) {
        return this.fplist.get(N);
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer mol) throws CDKException {
        this.calculate(mol);
        BitSet bits = new BitSet(this.length);
        for (int n = 0; n < this.fplist.size(); ++n) {
            int i = this.fplist.get((int)n).hashCode;
            long b = i >= 0 ? (long)i : (long)(i & Integer.MAX_VALUE) | 0x80000000L;
            bits.set((int)(b % (long)this.length));
        }
        return new BitSetFingerprint(bits);
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer mol) throws CDKException {
        this.calculate(mol);
        final TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (FP fp : this.fplist) {
            if (map.containsKey(fp.hashCode)) {
                map.put(fp.hashCode, (Integer)map.get(fp.hashCode) + 1);
                continue;
            }
            map.put(fp.hashCode, 1);
        }
        final int sz = map.size();
        final int[] hash = new int[sz];
        final int[] count = new int[sz];
        int n = 0;
        Iterator i$ = map.keySet().iterator();
        while (i$.hasNext()) {
            int h;
            hash[n] = h = ((Integer)i$.next()).intValue();
            count[n++] = (Integer)map.get(h);
        }
        return new ICountFingerprint(){

            @Override
            public long size() {
                return 0x100000000L;
            }

            @Override
            public int numOfPopulatedbins() {
                return sz;
            }

            @Override
            public int getCount(int index) {
                return count[index];
            }

            @Override
            public int getHash(int index) {
                return hash[index];
            }

            @Override
            public void merge(ICountFingerprint fp) {
            }

            @Override
            public void setBehaveAsBitFingerprint(boolean behaveAsBitFingerprint) {
            }

            @Override
            public boolean hasHash(int hash2) {
                return map.containsKey(hash2);
            }

            @Override
            public int getCountForHash(int hash2) {
                return map.containsKey(hash2) ? (Integer)map.get(hash2) : 0;
            }
        };
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer mol) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return this.length;
    }

    private int initialIdentityECFP(int aidx) {
        IAtom atom = this.mol.getAtom(aidx);
        int nheavy = this.atomAdj[aidx].length;
        int nhydr = this.hcount[aidx];
        int atno = atom.getAtomicNumber();
        int[] ELEMENT_BONDING = new int[]{0, 1, 0, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 4, 3, 2, 1, 0, 1, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 3, 4, 5, 6, 7, 8, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        int degree = (atno > 0 && atno < ELEMENT_BONDING.length ? ELEMENT_BONDING[atno] : 0) - nhydr;
        int chg = atom.getFormalCharge();
        int inring = this.ringBlock[aidx] > 0 ? 1 : 0;
        this.crc.reset();
        this.crc.update(nheavy << 4 | degree);
        this.crc.update(atno);
        this.crc.update(chg + 128);
        this.crc.update(nhydr << 4 | inring);
        return (int)this.crc.getValue();
    }

    private int initialIdentityFCFP(int aidx) {
        return (this.maskDon[aidx] ? 1 : 0) | (this.maskAcc[aidx] ? 2 : 0) | (this.maskPos[aidx] ? 4 : 0) | (this.maskNeg[aidx] ? 8 : 0) | (this.atomArom[aidx] ? 16 : 0) | (this.maskHal[aidx] ? 32 : 0);
    }

    private int circularIterate(int iter, int atom) {
        int[] adj = this.atomAdj[atom];
        int[] adjb = this.bondAdj[atom];
        int[] seq = new int[2 + 2 * adj.length];
        seq[0] = iter;
        seq[1] = this.identity[atom];
        for (int n = 0; n < adj.length; ++n) {
            seq[2 * n + 2] = this.bondArom[adjb[n]] ? 15 : this.bondOrder[adjb[n]];
            seq[2 * n + 3] = this.identity[adj[n]];
        }
        int p = 0;
        while (p < adj.length - 1) {
            int i = 2 + 2 * p;
            if (seq[i] > seq[i + 2] || seq[i] == seq[i + 2] && seq[i + 1] > seq[i + 3]) {
                int sw = seq[i];
                seq[i] = seq[i + 2];
                seq[i + 2] = sw;
                sw = seq[i + 1];
                seq[i + 1] = seq[i + 3];
                seq[i + 3] = sw;
                if (p <= 0) continue;
                --p;
                continue;
            }
            ++p;
        }
        this.crc.reset();
        for (int n = 0; n < seq.length; n += 2) {
            this.crc.update(seq[n]);
            int v = seq[n + 1];
            this.crc.update(v >>> 24);
            this.crc.update(v >> 16 & 0xFF);
            this.crc.update(v >> 8 & 0xFF);
            this.crc.update(v & 0xFF);
        }
        if (!this.resolvedChiral[atom] && this.tetra[atom] != null) {
            int[] ru = this.tetra[atom];
            int[] par = new int[]{ru[0] < 0 ? 0 : this.identity[ru[0]], ru[1] < 0 ? 0 : this.identity[ru[1]], ru[2] < 0 ? 0 : this.identity[ru[2]], ru[3] < 0 ? 0 : this.identity[ru[3]]};
            if (par[0] != par[1] && par[0] != par[2] && par[0] != par[3] && par[1] != par[2] && par[1] != par[3] && par[2] != par[3]) {
                int rp = 0;
                if (par[0] < par[1]) {
                    ++rp;
                }
                if (par[0] < par[2]) {
                    ++rp;
                }
                if (par[0] < par[3]) {
                    ++rp;
                }
                if (par[1] < par[2]) {
                    ++rp;
                }
                if (par[1] < par[3]) {
                    ++rp;
                }
                if (par[2] < par[3]) {
                    ++rp;
                }
                this.crc.update((rp & 1) + 1);
                this.resolvedChiral[atom] = true;
            }
        }
        return (int)this.crc.getValue();
    }

    private int[] growAtoms(int[] atoms) {
        int na = this.mol.getAtomCount();
        boolean[] mask = new boolean[na];
        for (int n = 0; n < atoms.length; ++n) {
            mask[atoms[n]] = true;
            int[] adj = this.atomAdj[atoms[n]];
            for (int i = 0; i < adj.length; ++i) {
                mask[adj[i]] = true;
            }
        }
        int sz = 0;
        for (int n = 0; n < na; ++n) {
            if (!mask[n]) continue;
            ++sz;
        }
        int[] newList = new int[sz];
        for (int n = na - 1; n >= 0; --n) {
            if (!mask[n]) continue;
            newList[--sz] = n;
        }
        return newList;
    }

    private void considerNewFP(FP newFP) {
        int hit = -1;
        FP fp = null;
        for (int n = 0; n < this.fplist.size(); ++n) {
            fp = this.fplist.get(n);
            boolean equal = fp.atoms.length == newFP.atoms.length;
            for (int i = fp.atoms.length - 1; equal && i >= 0; --i) {
                if (fp.atoms[i] == newFP.atoms[i]) continue;
                equal = false;
            }
            if (!equal) continue;
            hit = n;
            break;
        }
        if (hit < 0) {
            this.fplist.add(newFP);
            return;
        }
        if (fp.iteration < newFP.iteration || fp.hashCode < newFP.hashCode) {
            return;
        }
        this.fplist.set(hit, newFP);
    }

    private void excavateMolecule() {
        int n;
        int na = this.mol.getAtomCount();
        int nb = this.mol.getBondCount();
        this.amask = new boolean[na];
        for (n = 0; n < na; ++n) {
            this.amask[n] = this.mol.getAtom(n).getAtomicNumber() > 1;
        }
        this.atomAdj = new int[na][];
        this.bondAdj = new int[na][];
        this.bondOrder = new int[nb];
        this.hcount = new int[na];
        for (n = 0; n < this.mol.getBondCount(); ++n) {
            IBond bond = this.mol.getBond(n);
            if (bond.getAtomCount() != 2) continue;
            int a1 = this.mol.getAtomNumber(bond.getAtom(0));
            int a2 = this.mol.getAtomNumber(bond.getAtom(1));
            if (this.amask[a1] && this.amask[a2]) {
                this.atomAdj[a1] = this.appendInteger(this.atomAdj[a1], a2);
                this.bondAdj[a1] = this.appendInteger(this.bondAdj[a1], n);
                this.atomAdj[a2] = this.appendInteger(this.atomAdj[a2], a1);
                this.bondAdj[a2] = this.appendInteger(this.bondAdj[a2], n);
                if (bond.getOrder() == IBond.Order.SINGLE) {
                    this.bondOrder[n] = 1;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.DOUBLE) {
                    this.bondOrder[n] = 2;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.TRIPLE) {
                    this.bondOrder[n] = 3;
                    continue;
                }
                if (bond.getOrder() != IBond.Order.QUADRUPLE) continue;
                this.bondOrder[n] = 4;
                continue;
            }
            if (!this.amask[a1]) {
                int n2 = a2;
                this.hcount[n2] = this.hcount[n2] + 1;
            }
            if (this.amask[a2]) continue;
            int n3 = a1;
            this.hcount[n3] = this.hcount[n3] + 1;
        }
        for (n = 0; n < na; ++n) {
            if (!this.amask[n] || this.atomAdj[n] != null) continue;
            this.atomAdj[n] = new int[0];
            this.bondAdj[n] = this.atomAdj[n];
        }
        String[] HYVALENCE_EL = new String[]{"C", "N", "O", "S", "P"};
        int[] HYVALENCE_VAL = new int[]{4, 3, 2, 2, 3};
        for (int n4 = 0; n4 < na; ++n4) {
            IAtom atom = this.mol.getAtom(n4);
            String el = atom.getSymbol();
            int hy = 0;
            for (int i = 0; i < HYVALENCE_EL.length; ++i) {
                if (!el.equals(HYVALENCE_EL[i])) continue;
                hy = HYVALENCE_VAL[i];
                break;
            }
            if (hy == 0) continue;
            int ch = atom.getFormalCharge();
            if (el.equals("C")) {
                ch = -Math.abs(ch);
            }
            boolean unpaired = false;
            hy += ch - 0;
            for (IBond bond : this.mol.getConnectedBondsList(atom)) {
                if (bond.getOrder() == IBond.Order.SINGLE) {
                    --hy;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.DOUBLE) {
                    hy -= 2;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.TRIPLE) {
                    hy -= 3;
                    continue;
                }
                if (bond.getOrder() != IBond.Order.QUADRUPLE) continue;
                hy -= 4;
            }
            int n5 = n4;
            this.hcount[n5] = this.hcount[n5] + Math.max(0, hy);
        }
        this.markRingBlocks();
        ArrayList<int[]> rings = new ArrayList<int[]>();
        for (int rsz = 3; rsz <= 7; ++rsz) {
            int[] path = new int[rsz];
            for (int n6 = 0; n6 < na; ++n6) {
                if (this.ringBlock[n6] <= 0) continue;
                path[0] = n6;
                this.recursiveRingFind(path, 1, rsz, this.ringBlock[n6], rings);
            }
        }
        this.smallRings = (int[][])rings.toArray((T[])new int[rings.size()][]);
        this.detectStrictAromaticity();
        this.tetra = new int[na][];
        for (int n7 = 0; n7 < na; ++n7) {
            this.tetra[n7] = this.rubricTetrahedral(n7);
        }
    }

    private void markRingBlocks() {
        int i;
        int na = this.mol.getAtomCount();
        this.ringBlock = new int[na];
        boolean[] visited = new boolean[na];
        for (int n = 0; n < na; ++n) {
            visited[n] = !this.amask[n];
        }
        int[] path = new int[na + 1];
        int plen = 0;
        while (true) {
            int current;
            int last;
            if (plen == 0) {
                last = -1;
                for (current = 0; current < na && visited[current]; ++current) {
                }
                if (current >= na) {
                    break;
                }
            } else {
                last = path[plen - 1];
                current = -1;
                for (int n = 0; n < this.atomAdj[last].length; ++n) {
                    if (visited[this.atomAdj[last][n]]) continue;
                    current = this.atomAdj[last][n];
                    break;
                }
            }
            if (current >= 0 && plen >= 2) {
                int back = path[plen - 1];
                for (int n = 0; n < this.atomAdj[current].length; ++n) {
                    int join = this.atomAdj[current][n];
                    if (join == back || !visited[join]) continue;
                    path[plen] = current;
                    for (int i2 = plen; i2 == plen || path[i2 + 1] != join; --i2) {
                        int id = this.ringBlock[path[i2]];
                        if (id == 0) {
                            this.ringBlock[path[i2]] = last;
                            continue;
                        }
                        if (id == last) continue;
                        for (int j = 0; j < na; ++j) {
                            if (this.ringBlock[j] != id) continue;
                            this.ringBlock[j] = last;
                        }
                    }
                }
            }
            if (current >= 0) {
                visited[current] = true;
                path[plen++] = current;
                continue;
            }
            --plen;
        }
        int nextID = 0;
        for (i = 0; i < na; ++i) {
            if (this.ringBlock[i] <= 0) continue;
            --nextID;
            for (int j = na - 1; j >= i; --j) {
                if (this.ringBlock[j] != this.ringBlock[i]) continue;
                this.ringBlock[j] = nextID;
            }
        }
        for (i = 0; i < na; ++i) {
            this.ringBlock[i] = -this.ringBlock[i];
        }
    }

    private void recursiveRingFind(int[] path, int psize, int capacity, int rblk, ArrayList<int[]> rings) {
        boolean flip;
        int n;
        if (psize < capacity) {
            int last = path[psize - 1];
            for (int n2 = 0; n2 < this.atomAdj[last].length; ++n2) {
                int adj = this.atomAdj[last][n2];
                if (this.ringBlock[adj] != rblk) continue;
                boolean fnd = false;
                for (int i = 0; i < psize; ++i) {
                    if (path[i] != adj) continue;
                    fnd = true;
                    break;
                }
                if (fnd) continue;
                int[] newPath = new int[capacity];
                for (int i = 0; i < psize; ++i) {
                    newPath[i] = path[i];
                }
                newPath[psize] = adj;
                this.recursiveRingFind(newPath, psize + 1, capacity, rblk, rings);
            }
            return;
        }
        int last = path[psize - 1];
        boolean fnd = false;
        for (n = 0; n < this.atomAdj[last].length; ++n) {
            if (this.atomAdj[last][n] != path[0]) continue;
            fnd = true;
            break;
        }
        if (!fnd) {
            return;
        }
        for (n = 0; n < path.length; ++n) {
            int count = 0;
            int p = path[n];
            block5: for (int i = 0; i < this.atomAdj[p].length; ++i) {
                for (int j = 0; j < path.length; ++j) {
                    if (this.atomAdj[p][i] != path[j]) continue;
                    ++count;
                    continue block5;
                }
            }
            if (count == 2) continue;
            return;
        }
        int first = 0;
        for (int n3 = 1; n3 < psize; ++n3) {
            if (path[n3] >= path[first]) continue;
            first = n3;
        }
        int fm = (first - 1 + psize) % psize;
        int fp = (first + 1) % psize;
        boolean bl = flip = path[fm] < path[fp];
        if (first != 0 || flip) {
            int[] newPath = new int[psize];
            for (int n4 = 0; n4 < psize; ++n4) {
                newPath[n4] = path[(first + (flip ? psize - n4 : n4)) % psize];
            }
            path = newPath;
        }
        for (int n5 = 0; n5 < rings.size(); ++n5) {
            int[] look = rings.get(n5);
            boolean same = true;
            for (int i = 0; i < psize; ++i) {
                if (look[i] == path[i]) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return;
        }
        rings.add(path);
    }

    private void detectStrictAromaticity() {
        boolean anyChange;
        int na = this.mol.getAtomCount();
        int nb = this.mol.getBondCount();
        this.atomArom = new boolean[na];
        this.bondArom = new boolean[nb];
        if (this.smallRings.length == 0) {
            return;
        }
        boolean[] piAtom = new boolean[na];
        for (int n = 0; n < nb; ++n) {
            if (this.bondOrder[n] != 2) continue;
            IBond bond = this.mol.getBond(n);
            piAtom[this.mol.getAtomNumber((IAtom)bond.getAtom((int)0))] = true;
            piAtom[this.mol.getAtomNumber((IAtom)bond.getAtom((int)1))] = true;
        }
        ArrayList<int[]> maybe = new ArrayList<int[]>();
        for (int[] r : this.smallRings) {
            if (r.length != 6) continue;
            boolean consider = true;
            for (int n = 0; n < 6; ++n) {
                int a = r[n];
                if (!piAtom[a]) {
                    consider = false;
                    break;
                }
                int b = this.findBond(a, r[n == 5 ? 0 : n + 1]);
                if (this.bondOrder[b] == 1 || this.bondOrder[b] == 2) continue;
                consider = false;
                break;
            }
            if (!consider) continue;
            maybe.add(r);
        }
        do {
            anyChange = false;
            for (int n = maybe.size() - 1; n >= 0; --n) {
                int i;
                int[] r = (int[])maybe.get(n);
                boolean phase1 = true;
                boolean phase2 = true;
                for (i = 0; i < 6; ++i) {
                    int b = this.findBond(r[i], r[i == 5 ? 0 : i + 1]);
                    if (this.bondArom[b]) continue;
                    phase1 = phase1 && this.bondOrder[b] == 2 - (i & 1);
                    phase2 = phase2 && this.bondOrder[b] == 1 + (i & 1);
                }
                if (!phase1 && !phase2) continue;
                for (i = 0; i < r.length; ++i) {
                    this.atomArom[r[i]] = true;
                    this.bondArom[this.findBond((int)r[i], (int)r[i == 5 ? 0 : i + 1])] = true;
                }
                maybe.remove(n);
                anyChange = true;
            }
        } while (anyChange);
    }

    private int[] rubricTetrahedral(int aidx) {
        int i;
        if (this.hcount[aidx] > 1) {
            return null;
        }
        IAtom atom = this.mol.getAtom(aidx);
        int[] ELEMENT_BLOCKS = new int[]{0, 1, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        int atno = atom.getAtomicNumber();
        if (atno <= 1 || atno >= ELEMENT_BLOCKS.length) {
            return null;
        }
        if (ELEMENT_BLOCKS[atno] != 2) {
            return null;
        }
        int adjc = this.atomAdj[aidx].length;
        int hc = this.hcount[aidx];
        if (!(adjc == 3 && hc == 1 || adjc == 4 && hc == 0)) {
            return null;
        }
        boolean wedgeOr3D = false;
        Point3d a3d = atom.getPoint3d();
        for (int n = 0; n < adjc; ++n) {
            IBond.Stereo stereo = this.mol.getBond(this.bondAdj[aidx][n]).getStereo();
            if (stereo == IBond.Stereo.UP || stereo == IBond.Stereo.DOWN) {
                wedgeOr3D = true;
                break;
            }
            if (stereo == IBond.Stereo.UP_OR_DOWN) {
                return null;
            }
            Point3d o3d = atom.getPoint3d();
            if (a3d == null || o3d == null || a3d.z == o3d.z) continue;
            wedgeOr3D = true;
            break;
        }
        if (!wedgeOr3D) {
            return null;
        }
        Point2d a2d = atom.getPoint2d();
        float x0 = a3d != null ? (float)a3d.x : (float)a2d.x;
        float y0 = a3d != null ? (float)a3d.y : (float)a2d.y;
        float z0 = a3d != null ? (float)a3d.z : 0.0f;
        float[] xp = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] yp = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] zp = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        int numShort = 0;
        for (int n = 0; n < adjc; ++n) {
            IAtom other = this.mol.getAtom(this.atomAdj[aidx][n]);
            IBond bond = this.mol.getBond(this.bondAdj[aidx][n]);
            Point3d o3d = other.getPoint3d();
            Point2d o2d = other.getPoint2d();
            if (o3d != null) {
                xp[n] = (float)(o3d.x - (double)x0);
                yp[n] = (float)(o3d.y - (double)y0);
                zp[n] = (float)(o3d.z - (double)z0);
            } else if (o2d != null) {
                IBond.Stereo stereo = bond.getStereo();
                xp[n] = (float)(o2d.x - (double)x0);
                yp[n] = (float)(o2d.y - (double)y0);
                zp[n] = other == bond.getAtom(0) ? 0.0f : (stereo == IBond.Stereo.UP ? 1.0f : (stereo == IBond.Stereo.DOWN ? -1.0f : 0.0f));
            } else {
                return null;
            }
            float dx = xp[n] - x0;
            float dy = yp[n] - y0;
            float dz = zp[n] - z0;
            float dsq = dx * dx + dy * dy + dz * dz;
            if (!(dsq < 1.0E-4f) || ++numShort <= 1) continue;
            return null;
        }
        int[] adj = this.atomAdj[aidx];
        if (adjc == 3) {
            adj = this.appendInteger(adj, -1);
            xp[3] = -(xp[0] + xp[1] + xp[2]);
            yp[3] = -(yp[0] + yp[1] + yp[2]);
            zp[3] = -(zp[0] + zp[1] + zp[2]);
            float dsq = xp[3] * xp[3] + yp[3] * yp[3] + zp[3] * zp[3];
            if (dsq < 1.0E-4f) {
                return null;
            }
            float inv = 1.0f / (float)Math.sqrt(dsq);
            xp[3] = xp[3] * inv;
            yp[3] = yp[3] * inv;
            zp[3] = zp[3] * inv;
        }
        float one = 0.0f;
        float two = 0.0f;
        for (i = 1; i <= 6; ++i) {
            int a = 0;
            int b = 0;
            if (i == 1) {
                a = 1;
                b = 2;
            } else if (i == 2) {
                a = 2;
                b = 3;
            } else if (i == 3) {
                a = 3;
                b = 1;
            } else if (i == 4) {
                a = 2;
                b = 1;
            } else if (i == 5) {
                a = 3;
                b = 2;
            } else if (i == 6) {
                a = 1;
                b = 3;
            }
            float xx = yp[a] * zp[b] - yp[b] * zp[a] - xp[0];
            float yy = zp[a] * xp[b] - zp[b] * xp[a] - yp[0];
            float zz = xp[a] * yp[b] - xp[b] * yp[a] - zp[0];
            if (i <= 3) {
                one += xx * xx + yy * yy + zz * zz;
                continue;
            }
            two += xx * xx + yy * yy + zz * zz;
        }
        if (two > one) {
            i = adj[2];
            adj[2] = adj[3];
            adj[3] = i;
        }
        return adj;
    }

    private void calculateBioTypes() {
        int n;
        int na = this.mol.getAtomCount();
        int nb = this.mol.getBondCount();
        this.maskDon = new boolean[na];
        this.maskAcc = new boolean[na];
        this.maskPos = new boolean[na];
        this.maskNeg = new boolean[na];
        this.maskAro = new boolean[na];
        this.maskHal = new boolean[na];
        this.aliphatic = new boolean[na];
        this.bondSum = new int[na];
        for (n = 0; n < na; ++n) {
            if (!this.amask[n]) continue;
            this.aliphatic[n] = this.mol.getAtom(n).getSymbol().equals("C");
            this.bondSum[n] = this.hcount[n];
        }
        this.hasDouble = new boolean[na];
        this.isOxide = new boolean[na];
        for (n = 0; n < nb; ++n) {
            IBond bond = this.mol.getBond(n);
            if (bond.getAtomCount() != 2) continue;
            int a1 = this.mol.getAtomNumber(bond.getAtom(0));
            int a2 = this.mol.getAtomNumber(bond.getAtom(1));
            int o = this.bondOrder[n];
            if (!this.amask[a1] || !this.amask[a2]) continue;
            int n2 = a1;
            this.bondSum[n2] = this.bondSum[n2] + o;
            int n3 = a2;
            this.bondSum[n3] = this.bondSum[n3] + o;
            if (o == 2) {
                this.hasDouble[a1] = true;
                this.hasDouble[a2] = true;
                if (this.mol.getAtom(a1).getSymbol().equals("O")) {
                    this.isOxide[a2] = true;
                }
                if (this.mol.getAtom(a2).getSymbol().equals("O")) {
                    this.isOxide[a1] = true;
                }
            }
            if (o == 1) continue;
            this.aliphatic[a1] = false;
            this.aliphatic[a2] = false;
        }
        this.lonePair = new boolean[na];
        for (n = 0; n < na; ++n) {
            int valence;
            IAtom atom = this.mol.getAtom(n);
            String el = atom.getSymbol();
            int n4 = el.equals("N") ? 3 : (valence = el.equals("O") || el.equals("S") ? 2 : 0);
            if (valence <= 0 || this.bondSum[n] + atom.getFormalCharge() > valence) continue;
            this.lonePair[n] = true;
        }
        this.tetrazole = new boolean[na];
        for (int[] r : this.smallRings) {
            if (r.length < 5 || r.length > 7) continue;
            this.considerBioTypeAromaticity(r);
            if (r.length != 5) continue;
            this.considerBioTypeTetrazole(r);
        }
        for (int n5 = 0; n5 < na; ++n5) {
            if (!this.amask[n5]) continue;
            this.maskDon[n5] = this.determineDonor(n5);
            this.maskAcc[n5] = this.determineAcceptor(n5);
            this.maskPos[n5] = this.determinePositive(n5);
            this.maskNeg[n5] = this.determineNegative(n5);
            this.maskHal[n5] = this.determineHalide(n5);
        }
    }

    private void considerBioTypeAromaticity(int[] ring) {
        int n;
        int rsz = ring.length;
        int countDouble = 0;
        for (n = 0; n < rsz; ++n) {
            int a = ring[n];
            if (this.hasDouble[a]) {
                ++countDouble;
                continue;
            }
            if (this.lonePair[a]) continue;
            return;
        }
        if (countDouble < rsz - 2) {
            return;
        }
        for (n = 0; n < rsz; ++n) {
            this.maskAro[ring[n]] = true;
        }
    }

    private void considerBioTypeTetrazole(int[] ring) {
        int n;
        int countC = 0;
        int countN = 0;
        int ndbl = 0;
        for (n = 0; n < 5; ++n) {
            IAtom atom = this.mol.getAtom(ring[n]);
            if (atom.getFormalCharge() != 0) {
                return;
            }
            String el = atom.getSymbol();
            if (el.equals("C")) {
                ++countC;
            } else if (el.equals("N")) {
                ++countN;
            }
            if (this.bondOrder[this.findBond(ring[n], ring[n == 4 ? 0 : n + 1])] != 2) continue;
            ++ndbl;
        }
        if (countC != 1 || countN != 4 || ndbl != 2) {
            return;
        }
        for (n = 0; n < 5; ++n) {
            if (!this.mol.getAtom(ring[n]).getSymbol().equals("N")) continue;
            this.tetrazole[ring[n]] = true;
        }
    }

    private boolean determineDonor(int aidx) {
        if (this.hcount[aidx] == 0) {
            return false;
        }
        IAtom atom = this.mol.getAtom(aidx);
        String el = atom.getSymbol();
        if (el.equals("N") || el.equals("O")) {
            if (this.tetrazole[aidx]) {
                return false;
            }
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                if (!this.isOxide[this.atomAdj[aidx][n]] || this.mol.getAtom(this.atomAdj[aidx][n]).getSymbol().equals("C") && el.equals("N")) continue;
                return false;
            }
            return true;
        }
        if (el.equals("S")) {
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                if (!this.hasDouble[this.atomAdj[aidx][n]]) continue;
                return false;
            }
            return true;
        }
        if (el.equals("C")) {
            for (int n = 0; n < this.bondAdj[aidx].length; ++n) {
                if (this.bondOrderBioType(this.bondAdj[aidx][n]) != 3) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean determineAcceptor(int aidx) {
        IAtom atom = this.mol.getAtom(aidx);
        if (!this.lonePair[aidx] || this.mol.getAtom(aidx).getFormalCharge() > 0) {
            return false;
        }
        if (atom.getSymbol().equals("N")) {
            boolean basic = true;
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                if (this.aliphatic[this.atomAdj[aidx][n]]) continue;
                basic = false;
                break;
            }
            if (basic) {
                return false;
            }
        }
        return true;
    }

    private boolean determinePositive(int aidx) {
        IAtom atom = this.mol.getAtom(aidx);
        int chg = atom.getFormalCharge();
        if (chg < 0) {
            return false;
        }
        if (chg > 0) {
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                if (this.mol.getAtom(this.atomAdj[aidx][n]).getFormalCharge() >= 0) continue;
                return false;
            }
            return true;
        }
        String el = atom.getSymbol();
        if (el.equals("N")) {
            boolean basic = true;
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                if (this.aliphatic[this.atomAdj[aidx][n]]) continue;
                basic = false;
                break;
            }
            if (basic) {
                return true;
            }
            if (this.hasDouble[aidx] && this.hcount[aidx] == 0) {
                int other = -1;
                for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                    if (this.bondOrderBioType(this.bondAdj[aidx][n]) != 2) continue;
                    other = this.atomAdj[aidx][n];
                    break;
                }
                if (other >= 0) {
                    int amines = 0;
                    for (int n = 0; n < this.atomAdj[other].length; ++n) {
                        int a = this.atomAdj[other][n];
                        if (a == aidx) continue;
                        if (this.hasDouble[a]) {
                            amines = 0;
                            break;
                        }
                        String ael = this.mol.getAtom(a).getSymbol();
                        if (ael.equals("N")) {
                            if (this.hcount[a] > 0) {
                                amines = 0;
                                break;
                            }
                            ++amines;
                            continue;
                        }
                        if (ael.equals("C")) continue;
                        amines = 0;
                        break;
                    }
                    if (amines > 0) {
                        return true;
                    }
                }
            }
        } else if (el.equals("C")) {
            boolean imine = false;
            boolean amine = false;
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                int a = this.atomAdj[aidx][n];
                if (this.tetrazole[a]) {
                    imine = false;
                    amine = false;
                    break;
                }
                if (!this.mol.getAtom(a).getSymbol().equals("N")) continue;
                if (this.bondOrderBioType(this.bondAdj[aidx][n]) == 2) {
                    imine = true;
                    continue;
                }
                if (this.hcount[a] != 1) continue;
                amine = true;
            }
            if (imine && amine) {
                return true;
            }
        }
        return false;
    }

    private boolean determineNegative(int aidx) {
        IAtom atom = this.mol.getAtom(aidx);
        int chg = atom.getFormalCharge();
        if (chg > 0) {
            return false;
        }
        if (chg < 0) {
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                if (this.mol.getAtom(this.atomAdj[aidx][n]).getFormalCharge() <= 0) continue;
                return false;
            }
            return true;
        }
        String el = atom.getSymbol();
        if (this.tetrazole[aidx] && el.equals("N")) {
            return true;
        }
        if (this.isOxide[aidx] && (el.equals("C") || el.equals("S") || el.equals("P"))) {
            for (int n = 0; n < this.atomAdj[aidx].length; ++n) {
                int a;
                if (this.bondOrderBioType(this.bondAdj[aidx][n]) != 1 || !this.mol.getAtom(a = this.atomAdj[aidx][n]).getSymbol().equals("O") || this.hcount[a] <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean determineHalide(int aidx) {
        String el = this.mol.getAtom(aidx).getSymbol();
        return el.equals("F") || el.equals("Cl") || el.equals("Br") || el.equals("I");
    }

    private int bondOrderBioType(int bidx) {
        IBond bond = this.mol.getBond(bidx);
        if (bond.getAtomCount() != 2) {
            return 0;
        }
        int a1 = this.mol.getAtomNumber(bond.getAtom(0));
        int a2 = this.mol.getAtomNumber(bond.getAtom(1));
        if (this.maskAro[a1] && this.maskAro[a2]) {
            return -1;
        }
        return this.bondOrder[bidx];
    }

    private int[] appendInteger(int[] a, int v) {
        if (a == null || a.length == 0) {
            return new int[]{v};
        }
        int[] b = new int[a.length + 1];
        for (int n = a.length - 1; n >= 0; --n) {
            b[n] = a[n];
        }
        b[a.length] = v;
        return b;
    }

    private int findBond(int a1, int a2) {
        for (int n = this.atomAdj[a1].length - 1; n >= 0; --n) {
            if (this.atomAdj[a1][n] != a2) continue;
            return this.bondAdj[a1][n];
        }
        return -1;
    }

    public static final class FP {
        public int hashCode;
        public int iteration;
        public int[] atoms;

        public FP(int hashCode, int iteration, int[] atoms) {
            this.hashCode = hashCode;
            this.iteration = iteration;
            this.atoms = atoms;
        }
    }
}

