/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IBond;
import uk.ac.ebi.reactionblast.tools.rxnfile.SuperAtoms;
import uk.ac.ebi.reactionblast.tools.rxnfile.SuperBonds;

public class Substructure {
    private static final Logger LOG = Logger.getLogger(Substructure.class.getName());
    private final String typeID;
    private int sgroupIdentifier;
    private final int groupIndex;
    private final List<SuperAtoms> superAtoms;
    private final List<SuperBonds> superBonds;
    private int count;
    private int superBondIndex;

    public Substructure(int groupIndex, String typeID) {
        this.typeID = typeID;
        this.groupIndex = groupIndex;
        this.superAtoms = new ArrayList<SuperAtoms>();
        this.superBonds = new ArrayList<SuperBonds>();
        this.count = 0;
        this.superBondIndex = 0;
    }

    public void add(SuperAtoms superAtom) {
        this.superAtoms.add(this.count++, superAtom);
    }

    public boolean remove(SuperAtoms superAtoms) {
        return this.superAtoms.remove(superAtoms);
    }

    public int getSuperAtomCount() {
        return this.superAtoms.size();
    }

    public int getSuperBondCount() {
        return this.superBonds.size();
    }

    public String getTypeID() {
        return this.typeID;
    }

    public int getIndex() {
        return this.groupIndex;
    }

    void addCrossingBond(int bondIndex, IBond bond) {
        this.superBonds.add(this.superBondIndex++, new SuperBonds(bondIndex, bond));
    }

    public Collection<SuperAtoms> atoms() {
        return Collections.unmodifiableCollection(this.superAtoms);
    }

    public Collection<SuperBonds> bonds() {
        return Collections.unmodifiableCollection(this.superBonds);
    }

    public SuperBonds getSuperBond(int i) {
        return this.superBonds.get(i);
    }

    public SuperAtoms getSuperAtom(int i) {
        return this.superAtoms.get(i);
    }

    boolean setCrossingVector(IBond superBond, double x, double y) {
        boolean contains = false;
        for (SuperBonds sb : this.superBonds) {
            if (!sb.getSuperBond().equals(superBond)) continue;
            sb.setX(x);
            sb.setY(y);
            contains = true;
        }
        return contains;
    }

    public int getSGroupIdentifier() {
        return this.sgroupIdentifier;
    }

    public void setSGroupIdentifier(int sgroupIdentifier) {
        this.sgroupIdentifier = sgroupIdentifier;
    }
}

