/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.rxnfile;

import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.isomorphism.matchers.CTFileQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.stereo.StereoElementFactory;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Writer;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLValence;

public class MDLV2000Reader
extends DefaultChemObjectReader {
    private static final HashMap<IBond, Integer> special_bond_map = new HashMap();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV2000Reader.class);
    private static final Pattern TRAILING_SPACE = Pattern.compile("\\s+$");
    private static final String RECORD_DELIMITER = "$$$$";
    private static final Set<String> PSUEDO_LABELS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("*")).add("A")).add("Q")).add("L")).add("LP")).add("R")).add("R#")).build();
    private static final Logger LOG = Logger.getLogger(MDLV2000Reader.class.getName());
    BufferedReader input = null;
    private BooleanIOSetting forceReadAs3DCoords;
    private BooleanIOSetting interpretHydrogenIsotopes;
    private BooleanIOSetting addStereoElements;

    private static IChemModel newModel(IAtomContainer container) {
        if (container == null) {
            throw new NullPointerException("cannot create chem model for a null container");
        }
        IChemObjectBuilder builder = container.getBuilder();
        IChemModel model = builder.newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet containers = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        containers.addAtomContainer(container);
        model.setMoleculeSet(containers);
        return model;
    }

    static int length(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i + 1;
    }

    private static boolean isPeriodicElement(String symbol) {
        Integer elem = PeriodicTable.getAtomicNumber(symbol);
        return elem != null && elem > 0;
    }

    static boolean isPseudoElement(String symbol) {
        return PSUEDO_LABELS.contains(symbol);
    }

    static double readMDLCoordinate(String line, int offset) throws CDKException {
        if (line.charAt(offset + 5) != '.') {
            throw new CDKException("invalid coordinate specification");
        }
        int start = offset;
        while (line.charAt(start) == ' ') {
            ++start;
        }
        int sign = MDLV2000Reader.sign(line.charAt(start));
        if (sign < 0) {
            ++start;
        }
        int integral = MDLV2000Reader.readUInt(line, start, offset + 5 - start);
        int fraction = MDLV2000Reader.readUInt(line, offset + 6, 4);
        return (double)((long)sign * ((long)integral * 10000L + (long)fraction)) / 10000.0;
    }

    private static int toCharge(char c) {
        switch (c) {
            case '1': {
                return 3;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 1;
            }
            case '4': {
                return 0;
            }
            case '5': {
                return -1;
            }
            case '6': {
                return -2;
            }
            case '7': {
                return -3;
            }
        }
        return 0;
    }

    private static int sign(char c) {
        return c == '-' ? -1 : 1;
    }

    private static int toInt(char c) {
        return c >= '0' && c <= '9' ? c - 48 : 0;
    }

    private static int readUInt(String line, int index, int digits) {
        int result = 0;
        while (digits-- > 0) {
            result = result * 10 + MDLV2000Reader.toInt(line.charAt(index++));
        }
        return result;
    }

    private static int readMolfileInt(String line, int index) {
        int sign = 1;
        int result = 0;
        char c = line.charAt(index);
        switch (c) {
            case ' ': {
                break;
            }
            case '-': {
                sign = -1;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = c - 48;
                break;
            }
            default: {
                return 0;
            }
        }
        c = line.charAt(index + 1);
        switch (c) {
            case ' ': {
                if (result <= 0) break;
                return sign * result;
            }
            case '-': {
                if (result > 0) {
                    return sign * result;
                }
                sign = -1;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = result * 10 + (c - 48);
                break;
            }
            default: {
                return sign * result;
            }
        }
        c = line.charAt(index + 2);
        switch (c) {
            case ' ': {
                if (result <= 0) break;
                return sign * result;
            }
            case '-': {
                if (result > 0) {
                    return sign * result;
                }
                sign = -1;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                result = result * 10 + (c - 48);
                break;
            }
            default: {
                return sign * result;
            }
        }
        return sign * result;
    }

    static void label(IAtomContainer container, int index, String label) {
        IPseudoAtom pseudoAtom;
        IAtom atom = container.getAtom(index);
        IPseudoAtom iPseudoAtom = pseudoAtom = atom instanceof IPseudoAtom ? (IPseudoAtom)atom : container.getBuilder().newInstance(IPseudoAtom.class, new Object[0]);
        if (atom == pseudoAtom) {
            pseudoAtom.setLabel(label);
        } else {
            pseudoAtom.setSymbol(label);
            pseudoAtom.setAtomicNumber(0);
            pseudoAtom.setPoint2d(atom.getPoint2d());
            pseudoAtom.setPoint3d(atom.getPoint3d());
            pseudoAtom.setMassNumber(atom.getMassNumber());
            pseudoAtom.setFormalCharge(atom.getFormalCharge());
            pseudoAtom.setValency(atom.getValency());
            pseudoAtom.setLabel(label);
            AtomContainerManipulator.replaceAtomByAtom(container, atom, pseudoAtom);
        }
    }

    static void readNonStructuralData(BufferedReader input, IAtomContainer container) throws IOException {
        String line;
        String newline = System.getProperty("line.separator");
        String header = null;
        boolean wrap = false;
        StringBuilder data = new StringBuilder(80);
        while (!MDLV2000Reader.endOfRecord(line = input.readLine())) {
            String newHeader = MDLV2000Reader.dataHeader(line);
            if (newHeader != null) {
                if (header != null) {
                    container.setProperty(header, data.toString());
                }
                header = newHeader;
                wrap = false;
                data.setLength(0);
                continue;
            }
            if (data.length() > 0 || !line.equals(" ")) {
                line = line.trim();
            }
            if (line.isEmpty()) continue;
            if (!wrap && data.length() > 0) {
                data.append(newline);
            }
            data.append(line);
            wrap = line.length() == 80;
        }
        if (header != null) {
            container.setProperty(header, data.toString());
        }
    }

    static String dataHeader(String line) {
        if (line.length() > 2 && line.charAt(0) != '>' && line.charAt(1) != ' ') {
            return null;
        }
        int i = line.indexOf(60, 2);
        if (i < 0) {
            return null;
        }
        int j = line.indexOf(62, i);
        if (j < 0) {
            return null;
        }
        return line.substring(i + 1, j);
    }

    private static boolean endOfRecord(String line) {
        return line == null || line.equals(RECORD_DELIMITER);
    }

    public MDLV2000Reader() {
        this(new StringReader(""));
    }

    public MDLV2000Reader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public MDLV2000Reader(InputStream in, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(in), mode);
    }

    public MDLV2000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV2000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLV2000Format.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        return superClass != null && this.accepts(superClass);
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readAtomContainer((IAtomContainer)object);
        }
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        throw new CDKException("Only supported are ChemFile and Molecule.");
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IAtomContainer m;
        IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
        if (setOfMolecules == null) {
            setOfMolecules = chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        }
        if ((m = this.readAtomContainer(chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]))) != null) {
            setOfMolecules.addAtomContainer(m);
        }
        chemModel.setMoleculeSet(setOfMolecules);
        return chemModel;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemObjectBuilder builder = chemFile.getBuilder();
        IChemSequence sequence = builder.newInstance(IChemSequence.class, new Object[0]);
        try {
            IAtomContainer m;
            while ((m = this.readAtomContainer(builder.newInstance(IAtomContainer.class, new Object[0]))) != null) {
                sequence.addChemModel(MDLV2000Reader.newModel(m));
            }
        }
        catch (CDKException e) {
            throw e;
        }
        catch (IllegalArgumentException exception) {
            String error = "Error while parsing SDF";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        try {
            this.input.close();
        }
        catch (IOException exc) {
            String error = "Error while closing file: " + exc.getMessage();
            logger.error(error);
            throw new CDKException(error, exc);
        }
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private IAtomContainer readAtomContainer(IAtomContainer molecule) throws CDKException {
        String property;
        IChemObject outputContainer = null;
        int linecount = 0;
        String title = null;
        String remark = null;
        String line = "";
        try {
            int offset;
            line = this.input.readLine();
            ++linecount;
            if (line == null) {
                return null;
            }
            if (line.startsWith(RECORD_DELIMITER)) {
                return molecule;
            }
            if (line.length() > 0) {
                title = line;
            }
            line = this.input.readLine();
            ++linecount;
            line = this.input.readLine();
            ++linecount;
            if (line.length() > 0) {
                remark = line;
            }
            line = this.input.readLine();
            ++linecount;
            if (line.length() == 0) {
                this.handleError("Unexpected empty line", linecount, 0, 0);
                do {
                    line = this.input.readLine();
                    ++linecount;
                    if (line != null) continue;
                    return null;
                } while (!line.startsWith(RECORD_DELIMITER));
                return molecule;
            }
            CTabVersion version2 = CTabVersion.ofHeader(line);
            if (version2 == CTabVersion.V3000) {
                this.handleError("This file must be read with the MDLV3000Reader.");
                throw new CDKException("This file must be read with the MDLV3000Reader.");
            }
            if (version2 == CTabVersion.UNSPECIFIED) {
                this.handleError("This file must be read with the MDLReader.");
            }
            int nAtoms = MDLV2000Reader.readMolfileInt(line, 0);
            int nBonds = MDLV2000Reader.readMolfileInt(line, 3);
            IAtom[] atoms = new IAtom[nAtoms];
            IBond[] bonds = new IBond[nBonds];
            int[] explicitValence = new int[nAtoms];
            boolean hasX = false;
            boolean hasY = false;
            boolean hasZ = false;
            for (int i = 0; i < nAtoms; ++i) {
                IAtom atom;
                line = this.input.readLine();
                atoms[i] = atom = this.readAtomFast(line, molecule.getBuilder(), ++linecount);
                Point3d p = atom.getPoint3d();
                hasX = hasX || p.x != 0.0;
                hasY = hasY || p.y != 0.0;
                hasZ = hasZ || p.z != 0.0;
            }
            if (!(hasX || hasY || hasZ)) {
                if (nAtoms == 1) {
                    atoms[0].setPoint2d(new Point2d(0.0, 0.0));
                } else {
                    for (IAtom atomToUpdate : atoms) {
                        atomToUpdate.setPoint3d(null);
                    }
                }
            } else if (!hasZ && !this.forceReadAs3DCoords.isSet()) {
                for (IAtom atomToUpdate : atoms) {
                    Point3d point3d = atomToUpdate.getPoint3d();
                    if (point3d == null) continue;
                    atomToUpdate.setPoint2d(new Point2d(point3d.x, point3d.y));
                    atomToUpdate.setPoint3d(null);
                }
            }
            boolean hasQueryBonds = false;
            for (int i = 0; i < nBonds; ++i) {
                IBond bond;
                line = this.input.readLine();
                bonds[i] = this.readBondFast(line, molecule.getBuilder(), atoms, explicitValence, ++linecount);
                boolean bl = hasQueryBonds = hasQueryBonds || bonds[i].getOrder() == IBond.Order.UNSET && !bonds[i].getFlag(32);
                if (!hasQueryBonds || !special_bond_map.containsKey(bonds[i])) continue;
                Integer bondType = special_bond_map.get(bonds[i]);
                if (bonds[i].getOrder() != IBond.Order.UNSET || bonds[i].getFlag(32) || bondType != 8) continue;
                logger.warn("! Fixing unsupported potential DIAT COORDINATE BOND TYPE !");
                hasQueryBonds = false;
                bonds[i] = bond = bonds[i].getBuilder().newInstance(IBond.class, bonds[i].getAtom(0), bonds[i].getAtom(1));
                bonds[i].setFlag(4096, true);
                bond.setOrder(IBond.Order.UNSET);
            }
            special_bond_map.clear();
            outputContainer = !hasQueryBonds ? molecule : new QueryAtomContainer(molecule.getBuilder());
            outputContainer.setProperty("cdk:Title", title);
            outputContainer.setProperty("cdk:Remark", remark);
            if (outputContainer.isEmpty()) {
                outputContainer.setAtoms(atoms);
                outputContainer.setBonds(bonds);
            } else {
                for (IAtom iAtom : atoms) {
                    outputContainer.addAtom(iAtom);
                }
                for (IChemObject iChemObject : bonds) {
                    outputContainer.addBond((IBond)iChemObject);
                }
            }
            this.readPropertiesFast(this.input, (IAtomContainer)outputContainer, nAtoms);
            MDLV2000Reader.readNonStructuralData(this.input, (IAtomContainer)outputContainer);
            if (this.interpretHydrogenIsotopes.isSet()) {
                this.fixHydrogenIsotopes(molecule, Isotopes.getInstance());
            }
            for (int i = offset = outputContainer.getAtomCount() - nAtoms; i < outputContainer.getAtomCount(); ++i) {
                int valence = explicitValence[i - offset];
                if (valence < 0) {
                    hasQueryBonds = true;
                    continue;
                }
                this.applyMDLValenceModel(outputContainer.getAtom(i), valence, outputContainer.getConnectedSingleElectronsCount(outputContainer.getAtom(i)));
            }
            if (!hasQueryBonds && this.addStereoElements.isSet() && hasX && hasY) {
                if (hasZ) {
                    outputContainer.setStereoElements(StereoElementFactory.using3DCoordinates((IAtomContainer)outputContainer).createAll());
                } else if (!this.forceReadAs3DCoords.isSet()) {
                    outputContainer.setStereoElements(StereoElementFactory.using2DCoordinates((IAtomContainer)outputContainer).createAll());
                }
            }
        }
        catch (CDKException exception) {
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            throw exception;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            String error = "Error while parsing line " + linecount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            this.handleError("Error while parsing line: " + line, linecount, 0, 0, exception);
        }
        String string = property = outputContainer == null ? "" : (String)outputContainer.getProperty("cdk:Title");
        if (outputContainer != null && property != null) {
            outputContainer.setID(property);
        }
        return outputContainer;
    }

    private void applyMDLValenceModel(IAtom atom, int explicitValence, int unpaired) {
        if (atom.getValency() != null) {
            if (atom.getValency() >= explicitValence) {
                atom.setImplicitHydrogenCount(atom.getValency() - explicitValence - unpaired);
            } else {
                atom.setImplicitHydrogenCount(0);
            }
        } else {
            int implicitValence;
            Integer charge;
            Integer element = atom.getAtomicNumber();
            if (element == null) {
                element = 0;
            }
            if ((charge = atom.getFormalCharge()) == null) {
                charge = 0;
            }
            if ((implicitValence = MDLValence.implicitValence(element, charge, explicitValence)) < explicitValence) {
                atom.setValency(explicitValence);
                atom.setImplicitHydrogenCount(0);
            } else {
                atom.setValency(implicitValence);
                atom.setImplicitHydrogenCount(implicitValence - explicitValence - unpaired);
            }
        }
    }

    private void fixHydrogenIsotopes(IAtomContainer molecule, IsotopeFactory isotopeFactory) {
        block8: for (IAtom atom : AtomContainerManipulator.getAtomArray(molecule)) {
            if (!(atom instanceof IPseudoAtom)) continue;
            IPseudoAtom pseudo = (IPseudoAtom)atom;
            switch (pseudo.getLabel()) {
                case "D": {
                    IAtom newAtom = molecule.getBuilder().newInstance(IAtom.class, atom);
                    newAtom.setSymbol("H");
                    newAtom.setAtomicNumber(1);
                    isotopeFactory.configure(newAtom, isotopeFactory.getIsotope("H", 2));
                    AtomContainerManipulator.replaceAtomByAtom(molecule, atom, newAtom);
                    continue block8;
                }
                case "T": {
                    IAtom newAtom = molecule.getBuilder().newInstance(IAtom.class, atom);
                    newAtom.setSymbol("H");
                    newAtom.setAtomicNumber(1);
                    isotopeFactory.configure(newAtom, isotopeFactory.getIsotope("H", 3));
                    AtomContainerManipulator.replaceAtomByAtom(molecule, atom, newAtom);
                    continue block8;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false"));
        this.interpretHydrogenIsotopes = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("InterpretHydrogenIsotopes", IOSetting.Importance.LOW, "Should D and T be interpreted as hydrogen isotopes?", "true"));
        this.addStereoElements = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("AddStereoElements", IOSetting.Importance.LOW, "Assign stereo configurations to stereocenters utilising 2D/3D coordinates.", "true"));
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    private String removeNonDigits(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char inputChar = input.charAt(i);
            if (!Character.isDigit(inputChar)) continue;
            sb.append(inputChar);
        }
        return sb.toString();
    }

    IAtom readAtomFast(String line, IChemObjectBuilder builder, int lineNum) throws CDKException, IOException {
        String symbol;
        double z;
        double y;
        double x;
        int massDiff = 0;
        int charge = 0;
        int parity = 0;
        int valence = 0;
        int mapping = 0;
        int length = MDLV2000Reader.length(line);
        if (length > 69) {
            length = 69;
        }
        switch (length) {
            case 63: 
            case 66: 
            case 69: {
                mapping = MDLV2000Reader.readMolfileInt(line, 60);
            }
            case 51: 
            case 54: 
            case 57: 
            case 60: {
                valence = MDLV2000Reader.readMolfileInt(line, 48);
            }
            case 42: 
            case 45: 
            case 48: {
                parity = MDLV2000Reader.toInt(line.charAt(41));
            }
            case 39: {
                charge = MDLV2000Reader.toCharge(line.charAt(38));
            }
            case 36: {
                massDiff = MDLV2000Reader.sign(line.charAt(34)) * MDLV2000Reader.toInt(line.charAt(35));
            }
            case 32: 
            case 33: 
            case 34: {
                x = MDLV2000Reader.readMDLCoordinate(line, 0);
                y = MDLV2000Reader.readMDLCoordinate(line, 10);
                z = MDLV2000Reader.readMDLCoordinate(line, 20);
                symbol = line.substring(31, 34).trim().intern();
                break;
            }
            default: {
                this.handleError("invalid line length", lineNum, 0, 0);
                throw new CDKException("invalid line length, " + length + ": " + line);
            }
        }
        IAtom atom = this.createAtom(symbol, builder, lineNum);
        atom.setPoint3d(new Point3d(x, y, z));
        atom.setFormalCharge(charge);
        atom.setStereoParity(parity);
        if (massDiff != 0 && atom.getAtomicNumber() > 0) {
            atom.setMassNumber(Isotopes.getInstance().getMajorIsotope(atom.getAtomicNumber()).getMassNumber() + massDiff);
        }
        if (valence > 0 && valence < 16) {
            atom.setValency(valence == 15 ? 0 : valence);
        }
        if (mapping != 0) {
            atom.setProperty("cdk:AtomAtomMapping", mapping);
        }
        return atom;
    }

    IBond readBondFast(String line, IChemObjectBuilder builder, IAtom[] atoms, int[] explicitValence, int lineNum) throws CDKException {
        int type;
        int v;
        int u;
        int length = MDLV2000Reader.length(line);
        if (length > 21) {
            length = 21;
        }
        int stereo = 0;
        switch (length) {
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                stereo = MDLV2000Reader.readUInt(line, 9, 3);
            }
            case 9: {
                u = MDLV2000Reader.readMolfileInt(line, 0) - 1;
                v = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                type = MDLV2000Reader.readMolfileInt(line, 6);
                break;
            }
            default: {
                throw new CDKException("invalid line length: " + length + " " + line);
            }
        }
        IBond bond = builder.newInstance(IBond.class, atoms[u], atoms[v]);
        switch (type) {
            case 1: {
                bond.setOrder(IBond.Order.SINGLE);
                bond.setStereo(this.toStereo(stereo, type));
                break;
            }
            case 2: {
                bond.setOrder(IBond.Order.DOUBLE);
                bond.setStereo(this.toStereo(stereo, type));
                break;
            }
            case 3: {
                bond.setOrder(IBond.Order.TRIPLE);
                break;
            }
            case 4: {
                bond.setOrder(IBond.Order.UNSET);
                bond.setFlag(32, true);
                bond.setFlag(4096, true);
                atoms[u].setFlag(32, true);
                atoms[v].setFlag(32, true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bond = CTFileQueryBond.ofType(bond, type);
                special_bond_map.put(bond, type);
                break;
            }
            default: {
                throw new CDKException("unrecognised bond type: " + type + ", " + line);
            }
        }
        if (type < 4) {
            int n = u;
            explicitValence[n] = explicitValence[n] + type;
            int n2 = v;
            explicitValence[n2] = explicitValence[n2] + type;
        } else {
            explicitValence[v] = Integer.MIN_VALUE;
            explicitValence[u] = Integer.MIN_VALUE;
        }
        return bond;
    }

    void readPropertiesFast(BufferedReader input, IAtomContainer container, int nAtoms) throws IOException, CDKException {
        String line;
        int offset = container.getAtomCount() - nAtoms;
        block10: while ((line = input.readLine()) != null) {
            int length = line.length();
            PropertyKey key = PropertyKey.of(line);
            switch (key) {
                case ATOM_ALIAS: {
                    int index = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                    String label = input.readLine();
                    if (label == null) {
                        return;
                    }
                    MDLV2000Reader.label(container, offset + index, label);
                    break;
                }
                case ATOM_VALUE: {
                    int index = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                    String comment = line.substring(7);
                    container.getAtom(offset + index).setProperty("cdk:Comment", comment);
                    break;
                }
                case GROUP_ABBREVIATION: {
                    int from = MDLV2000Reader.readMolfileInt(line, 3) - 1;
                    int to = MDLV2000Reader.readMolfileInt(line, 6) - 1;
                    String group = input.readLine();
                    if (group != null) break;
                    return;
                }
                case M_CHG: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int i = 0;
                    int st = 10;
                    while (i < count && st + 7 <= length) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int charge = MDLV2000Reader.readMolfileInt(line, st + 4);
                        container.getAtom(offset + index).setFormalCharge(charge);
                        ++i;
                        st += 8;
                    }
                    continue block10;
                }
                case M_ISO: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int i = 0;
                    int st = 10;
                    while (i < count && st + 7 <= length) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int mass = MDLV2000Reader.readMolfileInt(line, st + 4);
                        container.getAtom(offset + index).setMassNumber(mass);
                        ++i;
                        st += 8;
                    }
                    continue block10;
                }
                case M_RAD: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int i = 0;
                    int st = 10;
                    while (i < count && st + 7 <= length) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int value = MDLV2000Reader.readMolfileInt(line, st + 4);
                        MDLV2000Writer.SPIN_MULTIPLICITY multiplicity = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(value);
                        for (int e = 0; e < multiplicity.getSingleElectrons(); ++e) {
                            container.addSingleElectron(offset + index);
                        }
                        ++i;
                        st += 8;
                    }
                    continue block10;
                }
                case M_RGP: {
                    int index;
                    int count = MDLV2000Reader.readUInt(line, 6, 3);
                    int i = 0;
                    int st = 10;
                    while (i < count && st + 7 <= length) {
                        index = MDLV2000Reader.readMolfileInt(line, st) - 1;
                        int number = MDLV2000Reader.readMolfileInt(line, st + 4);
                        MDLV2000Reader.label(container, offset + index, "R" + number);
                        ++i;
                        st += 8;
                    }
                    continue block10;
                }
                case M_END: {
                    return;
                }
            }
        }
    }

    private IBond.Stereo toStereo(int stereo, int type) throws CDKException {
        switch (stereo) {
            case 0: {
                return type == 2 ? IBond.Stereo.E_Z_BY_COORDINATES : IBond.Stereo.NONE;
            }
            case 1: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 2) {
                    throw new CDKException("stereo flag was 'up' but bond order was 2");
                }
                return IBond.Stereo.UP;
            }
            case 3: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 1) {
                    throw new CDKException("stereo flag was 'cis/trans' but bond order was 1");
                }
                return IBond.Stereo.E_OR_Z;
            }
            case 4: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 2) {
                    throw new CDKException("stereo flag was 'up/down' but bond order was 2");
                }
                return IBond.Stereo.UP_OR_DOWN;
            }
            case 6: {
                if (this.mode == IChemObjectReader.Mode.STRICT && type == 2) {
                    throw new CDKException("stereo flag was 'down' but bond order was 2");
                }
                return IBond.Stereo.DOWN;
            }
        }
        if (this.mode == IChemObjectReader.Mode.STRICT) {
            throw new CDKException("unknown bond stereo type: " + stereo);
        }
        return IBond.Stereo.NONE;
    }

    private IAtom createAtom(String symbol, IChemObjectBuilder builder, int lineNum) throws CDKException {
        if (MDLV2000Reader.isPeriodicElement(symbol)) {
            return builder.newInstance(IAtom.class, symbol);
        }
        if (!MDLV2000Reader.isPseudoElement(symbol)) {
            this.handleError("invalid symbol: " + symbol, lineNum, 31, 34);
            if (this.mode == IChemObjectReader.Mode.STRICT) {
                throw new CDKException("invalid symbol: " + symbol);
            }
        }
        if (symbol.equals("R#")) {
            symbol = "R";
        }
        IAtom atom = builder.newInstance(IPseudoAtom.class, symbol);
        atom.setSymbol(symbol);
        atom.setAtomicNumber(0);
        return atom;
    }

    private IAtom readAtomSlow(String line, IChemObjectBuilder builder, int linecount) throws CDKException, IOException {
        IAtom atom;
        block56: {
            Matcher trailingSpaceMatcher = TRAILING_SPACE.matcher(line);
            if (trailingSpaceMatcher.find()) {
                this.handleError("Trailing space found", linecount, trailingSpaceMatcher.start(), trailingSpaceMatcher.end());
                line = trailingSpaceMatcher.replaceAll("");
            }
            double x = Double.parseDouble(line.substring(0, 10).trim());
            double y = Double.parseDouble(line.substring(10, 20).trim());
            double z = Double.parseDouble(line.substring(20, 30).trim());
            String element = line.substring(31, Math.min(line.length(), 34)).trim();
            if (line.length() < 34) {
                this.handleError("Element atom type does not follow V2000 format type should of length three and padded with space if required", linecount, 31, 34);
            }
            logger.debug("Atom type: ", element);
            Isotopes isotopeFactory = Isotopes.getInstance();
            if (isotopeFactory.isElement(element)) {
                atom = isotopeFactory.configure(builder.newInstance(IAtom.class, element));
            } else if ("A".equals(element)) {
                atom = builder.newInstance(IPseudoAtom.class, element);
            } else if ("Q".equals(element)) {
                atom = builder.newInstance(IPseudoAtom.class, element);
            } else if ("*".equals(element)) {
                atom = builder.newInstance(IPseudoAtom.class, element);
            } else if ("LP".equals(element)) {
                atom = builder.newInstance(IPseudoAtom.class, element);
            } else if ("L".equals(element)) {
                atom = builder.newInstance(IPseudoAtom.class, element);
            } else if (element.equals("R") || element.length() > 0 && element.charAt(0) == 'R') {
                logger.debug("Atom ", element, " is not an regular element. Creating a PseudoAtom.");
                String[] rGroup = element.split("^R");
                if (rGroup.length > 1) {
                    try {
                        element = "R" + Integer.valueOf(rGroup[rGroup.length - 1]);
                        atom = builder.newInstance(IPseudoAtom.class, element);
                    }
                    catch (Exception ex) {
                        atom = builder.newInstance(IPseudoAtom.class, "R");
                    }
                } else {
                    atom = builder.newInstance(IPseudoAtom.class, element);
                }
            } else {
                this.handleError("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.", linecount, 32, 35);
                atom = builder.newInstance(IPseudoAtom.class, element);
                atom.setSymbol(element);
            }
            atom.setPoint3d(new Point3d(x, y, z));
            if (line.length() >= 36) {
                String massDiffString = line.substring(34, 36).trim();
                logger.debug("Mass difference: ", massDiffString);
                if (!(atom instanceof IPseudoAtom)) {
                    try {
                        int massDiff = Integer.parseInt(massDiffString);
                        if (massDiff != 0) {
                            IIsotope major = Isotopes.getInstance().getMajorIsotope(element);
                            atom.setMassNumber(major.getMassNumber() + massDiff);
                        }
                    }
                    catch (IOException | NumberFormatException exception) {
                        this.handleError("Could not parse mass difference field.", linecount, 35, 37, exception);
                    }
                } else {
                    logger.error("Cannot set mass difference for a non-element!");
                }
            } else {
                this.handleError("Mass difference is missing", linecount, 34, 36);
            }
            Integer parity = line.length() > 41 ? Character.digit(line.charAt(41), 10) : 0;
            atom.setStereoParity(parity);
            if (line.length() >= 51) {
                String valenceString = this.removeNonDigits(line.substring(48, 51));
                logger.debug("Valence: ", valenceString);
                if (!(atom instanceof IPseudoAtom)) {
                    try {
                        int valence = Integer.parseInt(valenceString);
                        if (valence == 0) break block56;
                        if (valence == 15) {
                            atom.setValency(0);
                            break block56;
                        }
                        atom.setValency(valence);
                    }
                    catch (NumberFormatException exception) {
                        this.handleError("Could not parse valence information field", linecount, 49, 52, exception);
                    }
                } else {
                    logger.error("Cannot set valence information for a non-element!");
                }
            }
        }
        if (line.length() >= 39) {
            String chargeCodeString = line.substring(36, 39).trim();
            logger.debug("Atom charge code: ", chargeCodeString);
            int chargeCode = Integer.parseInt(chargeCodeString);
            if (chargeCode != 0) {
                if (chargeCode == 1) {
                    atom.setFormalCharge(3);
                } else if (chargeCode == 2) {
                    atom.setFormalCharge(2);
                } else if (chargeCode == 3) {
                    atom.setFormalCharge(1);
                } else if (chargeCode != 4) {
                    if (chargeCode == 5) {
                        atom.setFormalCharge(-1);
                    } else if (chargeCode == 6) {
                        atom.setFormalCharge(-2);
                    } else if (chargeCode == 7) {
                        atom.setFormalCharge(-3);
                    }
                }
            }
        } else {
            this.handleError("Atom charge is missing", linecount, 36, 39);
        }
        try {
            String reactionAtomIDString = line.substring(60, 63).trim();
            logger.debug("Parsing mapping id: ", reactionAtomIDString);
            try {
                int reactionAtomID = Integer.parseInt(reactionAtomIDString);
                if (reactionAtomID != 0) {
                    atom.setProperty("cdk:AtomAtomMapping", reactionAtomID);
                }
            }
            catch (NumberFormatException exception) {
                logger.error("Mapping number ", reactionAtomIDString, " is not an integer.");
                logger.debug(exception);
            }
        }
        catch (Exception exception) {
            logger.warn("A few fields are missing. Older MDL MOL file?");
        }
        if (line.length() >= 78) {
            double shift = Double.parseDouble(line.substring(69, 80).trim());
            atom.setProperty("first shift", shift);
        }
        if (line.length() >= 87) {
            double shift = Double.parseDouble(line.substring(79, 87).trim());
            atom.setProperty("second shift", shift);
        }
        return atom;
    }

    private IBond readBondSlow(String line, IChemObjectBuilder builder, IAtom[] atoms, int[] explicitValence, int linecount) throws CDKException {
        IBond newBond;
        int atom1 = Integer.parseInt(line.substring(0, 3).trim());
        int atom2 = Integer.parseInt(line.substring(3, 6).trim());
        int order = Integer.parseInt(line.substring(6, 9).trim());
        IBond.Stereo stereo = null;
        if (line.length() >= 12) {
            int mdlStereo;
            int n = mdlStereo = line.length() > 12 ? Integer.parseInt(line.substring(9, 12).trim()) : Integer.parseInt(line.substring(9).trim());
            if (mdlStereo == 1) {
                stereo = IBond.Stereo.UP;
            } else if (mdlStereo == 6) {
                stereo = IBond.Stereo.DOWN;
            } else if (mdlStereo == 0) {
                stereo = order == 2 ? IBond.Stereo.E_Z_BY_COORDINATES : IBond.Stereo.NONE;
            } else if (mdlStereo == 3 && order == 2) {
                stereo = IBond.Stereo.E_OR_Z;
            } else if (mdlStereo == 4) {
                stereo = IBond.Stereo.UP_OR_DOWN;
            }
        } else {
            this.handleError("Missing expected stereo field at line: ", linecount, 10, 12);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bond: " + atom1 + " - " + atom2 + "; order " + order);
        }
        IAtom a1 = atoms[atom1 - 1];
        IAtom a2 = atoms[atom2 - 1];
        if (order >= 1 && order <= 3) {
            IBond.Order cdkOrder = IBond.Order.SINGLE;
            if (order == 2) {
                cdkOrder = IBond.Order.DOUBLE;
            }
            if (order == 3) {
                cdkOrder = IBond.Order.TRIPLE;
            }
            newBond = stereo != null ? builder.newInstance(IBond.class, new Object[]{a1, a2, cdkOrder, stereo}) : builder.newInstance(IBond.class, new Object[]{a1, a2, cdkOrder});
            int n = atom1 - 1;
            explicitValence[n] = explicitValence[n] + cdkOrder.numeric();
            int n2 = atom2 - 1;
            explicitValence[n2] = explicitValence[n2] + cdkOrder.numeric();
        } else if (order == 4) {
            newBond = stereo != null ? builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.UNSET, stereo}) : builder.newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.UNSET});
            newBond.setFlag(4096, true);
            newBond.setFlag(32, true);
            a1.setFlag(32, true);
            a2.setFlag(32, true);
            explicitValence[atom2 - 1] = Integer.MIN_VALUE;
            explicitValence[atom1 - 1] = Integer.MIN_VALUE;
        } else {
            newBond = new CTFileQueryBond(builder);
            IAtom[] bondAtoms = new IAtom[]{a1, a2};
            newBond.setAtoms(bondAtoms);
            newBond.setOrder(IBond.Order.UNSET);
            CTFileQueryBond.Type queryBondType = null;
            switch (order) {
                case 5: {
                    queryBondType = CTFileQueryBond.Type.SINGLE_OR_DOUBLE;
                    break;
                }
                case 6: {
                    queryBondType = CTFileQueryBond.Type.SINGLE_OR_AROMATIC;
                    break;
                }
                case 7: {
                    queryBondType = CTFileQueryBond.Type.DOUBLE_OR_AROMATIC;
                    break;
                }
                case 8: {
                    queryBondType = CTFileQueryBond.Type.ANY;
                }
            }
            newBond.setType(queryBondType);
            newBond.setStereo(stereo);
            explicitValence[atom2 - 1] = Integer.MIN_VALUE;
            explicitValence[atom1 - 1] = Integer.MIN_VALUE;
        }
        return newBond;
    }

    private void readPropertiesSlow(BufferedReader input, IAtomContainer container, int nAtoms, int linecount) throws IOException, CDKException {
        logger.info("Reading property block");
        while (true) {
            String line = input.readLine();
            ++linecount;
            if (line == null) {
                this.handleError("The expected property block is missing!", linecount, 0, 0);
            }
            if (line != null && line.startsWith("M  END")) break;
            boolean lineRead = false;
            if (line != null && line.startsWith("M  CHG")) {
                int infoCount = Integer.parseInt(line.substring(6, 9).trim());
                StringTokenizer st = new StringTokenizer(line.substring(9));
                for (int i = 1; i <= infoCount; ++i) {
                    String token = st.nextToken();
                    int atomNumber = Integer.parseInt(token.trim());
                    token = st.nextToken();
                    int charge = Integer.parseInt(token.trim());
                    container.getAtom(atomNumber - 1).setFormalCharge(charge);
                }
            } else if (line.matches("A\\s{1,4}\\d+")) {
                int aliasAtomNumber = Integer.parseInt(line.replaceFirst("A\\s{1,4}", ""));
                String alias = input.readLine();
                ++linecount;
                IAtom aliasAtom = container.getAtom(aliasAtomNumber - 1);
                if (aliasAtom instanceof IPseudoAtom) {
                    ((IPseudoAtom)aliasAtom).setLabel(alias);
                    continue;
                }
                IAtom newPseudoAtom = container.getBuilder().newInstance(IPseudoAtom.class, alias);
                if (aliasAtom.getPoint2d() != null) {
                    newPseudoAtom.setPoint2d(aliasAtom.getPoint2d());
                }
                if (aliasAtom.getPoint3d() != null) {
                    newPseudoAtom.setPoint3d(aliasAtom.getPoint3d());
                }
                AtomContainerManipulator.replaceAtomByAtom(container, aliasAtom, newPseudoAtom);
            } else if (line.startsWith("M  ISO")) {
                try {
                    String countString = line.substring(6, 10).trim();
                    int infoCount = Integer.parseInt(countString);
                    StringTokenizer st = new StringTokenizer(line.substring(10));
                    for (int i = 1; i <= infoCount; ++i) {
                        int atomNumber = Integer.parseInt(st.nextToken().trim());
                        int absMass = Integer.parseInt(st.nextToken().trim());
                        if (absMass == 0) continue;
                        IAtom isotope = container.getAtom(atomNumber - 1);
                        isotope.setMassNumber(absMass);
                    }
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error(error);
                    this.handleError("NumberFormatException in isotope information.", linecount, 7, 11, exception);
                }
            } else if (line.startsWith("M  RAD")) {
                try {
                    String countString = line.substring(6, 9).trim();
                    int infoCount = Integer.parseInt(countString);
                    StringTokenizer st = new StringTokenizer(line.substring(9));
                    for (int i = 1; i <= infoCount; ++i) {
                        int atomNumber = Integer.parseInt(st.nextToken().trim());
                        int spinMultiplicity = Integer.parseInt(st.nextToken().trim());
                        MDLV2000Writer.SPIN_MULTIPLICITY spin = MDLV2000Writer.SPIN_MULTIPLICITY.NONE;
                        if (spinMultiplicity <= 0) continue;
                        IAtom radical = container.getAtom(atomNumber - 1);
                        switch (spinMultiplicity) {
                            case 1: {
                                spin = MDLV2000Writer.SPIN_MULTIPLICITY.DOUBLET;
                                break;
                            }
                            case 2: {
                                spin = MDLV2000Writer.SPIN_MULTIPLICITY.SINGLET;
                                break;
                            }
                            case 3: {
                                spin = MDLV2000Writer.SPIN_MULTIPLICITY.TRIPLET;
                                break;
                            }
                            default: {
                                logger.debug("Invalid spin multiplicity found: " + spinMultiplicity);
                            }
                        }
                        for (int j = 0; j < spin.getSingleElectrons(); ++j) {
                            container.addSingleElectron(container.getBuilder().newInstance(ISingleElectron.class, radical));
                        }
                    }
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.getMessage() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error(error);
                    this.handleError("NumberFormatException in radical information", linecount, 7, 10, exception);
                }
            } else if (line.startsWith("G  ")) {
                try {
                    String atomNumberString = line.substring(3, 6).trim();
                    int atomNumber = Integer.parseInt(atomNumberString);
                    String atomName = input.readLine();
                    IAtom prevAtom = container.getAtom(atomNumber - 1);
                    IPseudoAtom pseudoAtom = container.getBuilder().newInstance(IPseudoAtom.class, atomName);
                    if (prevAtom.getPoint2d() != null) {
                        pseudoAtom.setPoint2d(prevAtom.getPoint2d());
                    }
                    if (prevAtom.getPoint3d() != null) {
                        pseudoAtom.setPoint3d(prevAtom.getPoint3d());
                    }
                    AtomContainerManipulator.replaceAtomByAtom(container, prevAtom, pseudoAtom);
                }
                catch (NumberFormatException exception) {
                    String error = "Error (" + exception.toString() + ") while parsing line " + linecount + ": " + line + " in property block.";
                    logger.error(error);
                    this.handleError("NumberFormatException in group information", linecount, 4, 7, exception);
                }
            } else if (line.startsWith("M  RGP")) {
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                st.nextToken();
                st.nextToken();
                while (st.hasMoreTokens()) {
                    Integer position = new Integer(st.nextToken());
                    int rNumber = new Integer(st.nextToken());
                    int index = container.getAtomCount() - nAtoms + position - 1;
                    IPseudoAtom pseudoAtom = (IPseudoAtom)container.getAtom(index);
                    if (pseudoAtom == null) continue;
                    pseudoAtom.setLabel("R" + rNumber);
                }
            }
            if (line.startsWith("V  ")) {
                Integer atomNumber = new Integer(line.substring(3, 6).trim());
                IAtom atomWithComment = container.getAtom(atomNumber - 1);
                atomWithComment.setProperty("cdk:Comment", line.substring(7));
            }
            if (lineRead) continue;
            logger.warn("Skipping line in property block: ", line);
        }
    }

    static enum CTabVersion {
        V2000,
        V3000,
        UNSPECIFIED;


        static CTabVersion ofHeader(String header) {
            if (header.length() < 39) {
                return UNSPECIFIED;
            }
            char c = header.charAt(34);
            if (c != 'v' && c != 'V') {
                return UNSPECIFIED;
            }
            if (header.charAt(35) == '2') {
                return V2000;
            }
            if (header.charAt(35) == '3') {
                return V3000;
            }
            return UNSPECIFIED;
        }
    }

    static enum PropertyKey {
        ATOM_ALIAS,
        ATOM_VALUE,
        GROUP_ABBREVIATION,
        SKIP,
        M_CHG,
        M_RAD,
        M_ISO,
        M_RBC,
        M_SUB,
        M_UNS,
        M_LIN,
        M_ALS,
        M_APO,
        M_AAL,
        M_RGP,
        M_LOG,
        M_STY,
        M_SST,
        M_SLB,
        M_SCN,
        M_SDS,
        M_SAL,
        M_SBL,
        M_SPA,
        M_SMT,
        M_CRS,
        M_SDI,
        M_SBV,
        M_SDT,
        M_SDD,
        M_SCD,
        M_SED,
        M_SPL,
        M_SNC,
        M_$3D,
        M_END,
        UNKNOWN;

        private static final Map<String, PropertyKey> mSuffix;

        static PropertyKey of(String line) {
            if (line.length() < 5) {
                return UNKNOWN;
            }
            switch (line.charAt(0)) {
                case 'A': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return ATOM_ALIAS;
                    }
                    return UNKNOWN;
                }
                case 'G': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return GROUP_ABBREVIATION;
                    }
                    return UNKNOWN;
                }
                case 'S': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return SKIP;
                    }
                    return UNKNOWN;
                }
                case 'V': {
                    if (line.charAt(1) == ' ' && line.charAt(2) == ' ') {
                        return ATOM_VALUE;
                    }
                    return UNKNOWN;
                }
                case 'M': {
                    if (line.charAt(1) != ' ' || line.charAt(2) != ' ') {
                        return UNKNOWN;
                    }
                    PropertyKey property = mSuffix.get(line.substring(3, 6));
                    if (property != null) {
                        return property;
                    }
                    return UNKNOWN;
                }
            }
            return UNKNOWN;
        }

        static {
            mSuffix = new HashMap<String, PropertyKey>(60);
            for (PropertyKey p : PropertyKey.values()) {
                if (p.name().charAt(0) != 'M') continue;
                mSuffix.put(p.name().substring(2, 5), p);
            }
        }
    }
}

