/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class MoleculeCanonicalizationTransformation
implements ITransformation<IAtomContainer> {
    private static final Logger LOG = Logger.getLogger(MoleculeCanonicalizationTransformation.class.getName());
    private final ICanonicalMoleculeLabeller canonicalMoleculeLabeller;

    public MoleculeCanonicalizationTransformation(ICanonicalMoleculeLabeller labeller) {
        this.canonicalMoleculeLabeller = labeller;
    }

    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.MOLECULE;
    }

    @Override
    public IAtomContainer transform(IAtomContainer atomContainer) {
        return this.canonicalMoleculeLabeller.getCanonicalMolecule(atomContainer);
    }
}

