/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools.bulk;

import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.interfaces.ITransformation;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;

public class BondChangeCalculationTransformation
implements ITransformation<IReaction> {
    private static final Logger LOG = Logger.getLogger(BondChangeCalculationTransformation.class.getName());

    @Override
    public ITransformation.TargetType getTargetType() {
        return ITransformation.TargetType.REACTION;
    }

    @Override
    public IReaction transform(IReaction reaction) {
        try {
            boolean generate2D = false;
            boolean generate3D = false;
            BondChangeCalculator bcc = new BondChangeCalculator(reaction, generate2D, generate3D);
            return bcc.getReactionWithCompressUnChangedHydrogens();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

