/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.periodictable.PeriodicTable;
import uk.ac.ebi.reactionblast.mechanism.helper.BondChange;

public class ValencyCalculator {
    private static Map<String, Integer> valencElectronMap = null;
    private static boolean isInitialized = false;
    private static final Logger LOG = Logger.getLogger(ValencyCalculator.class.getName());

    private static void initialize() {
        if (isInitialized) {
            return;
        }
        valencElectronMap = Collections.synchronizedSortedMap(new TreeMap());
        for (int i = 1; i < PeriodicTable.getElementCount(); ++i) {
            String symbol = PeriodicTable.getSymbol(i);
            if (PeriodicTable.getGroup(symbol) != null && (PeriodicTable.getGroup(symbol) < 3 || PeriodicTable.getGroup(symbol) > 12)) {
                switch (PeriodicTable.getGroup(symbol)) {
                    case 1: {
                        valencElectronMap.put(symbol, 1);
                        break;
                    }
                    case 2: {
                        valencElectronMap.put(symbol, 2);
                        break;
                    }
                    case 13: {
                        valencElectronMap.put(symbol, 3);
                        break;
                    }
                    case 14: {
                        valencElectronMap.put(symbol, 4);
                        break;
                    }
                    case 15: {
                        valencElectronMap.put(symbol, 5);
                        break;
                    }
                    case 16: {
                        valencElectronMap.put(symbol, 6);
                        break;
                    }
                    case 17: {
                        valencElectronMap.put(symbol, 7);
                        break;
                    }
                    case 18: {
                        valencElectronMap.put(symbol, 8);
                        break;
                    }
                    default: {
                        valencElectronMap.put(symbol, 0);
                        break;
                    }
                }
                continue;
            }
            valencElectronMap.put(symbol, 99);
        }
        valencElectronMap.put("Sc", 3);
        valencElectronMap.put("Ti", 4);
        valencElectronMap.put("V", 5);
        valencElectronMap.put("Cr", 6);
        valencElectronMap.put("Mn", 4);
        valencElectronMap.put("Ni", 2);
        valencElectronMap.put("Cu", 2);
        valencElectronMap.put("Zn", 2);
        valencElectronMap.put("Fe", 3);
        valencElectronMap.put("Co", 3);
        valencElectronMap.put("*", 1);
        valencElectronMap.put("R", 1);
        valencElectronMap.put("A", 1);
        valencElectronMap.put("X", 8);
        valencElectronMap.put("PsH", 1);
        isInitialized = true;
    }

    public static Integer getValenceElectron(IAtom atom) throws CDKException {
        Integer atomValence;
        ValencyCalculator.initialize();
        String symbol = atom.getSymbol();
        if (valencElectronMap.containsKey(symbol)) {
            atomValence = valencElectronMap.get(symbol);
        } else {
            Logger.getLogger(ValencyCalculator.class.getName()).log(Level.WARNING, "Element {0} not found. Valence assigned 99.", symbol);
            atomValence = 99;
        }
        return atomValence;
    }

    public static Integer getFreeValenceElectrons(IAtomContainer m, IAtom atom, boolean skipHydrogen) throws CDKException {
        ValencyCalculator.initialize();
        Integer totalConnectedBondOrder = 0;
        List<IAtom> connectedAtoms = m.getConnectedAtomsList(atom);
        int counterH = 0;
        for (IAtom connAtom : connectedAtoms) {
            if (skipHydrogen && connAtom.getSymbol().equalsIgnoreCase("H")) {
                ++counterH;
            }
            IBond bond = m.getBond(atom, connAtom);
            totalConnectedBondOrder = totalConnectedBondOrder + BondChange.convertBondOrder(bond);
        }
        Integer charge = atom.getFormalCharge() == CDKConstants.UNSET ? 0 : atom.getFormalCharge();
        return skipHydrogen ? ValencyCalculator.getValenceElectron(atom) - totalConnectedBondOrder + counterH - charge : ValencyCalculator.getValenceElectron(atom) - totalConnectedBondOrder - charge;
    }

    public static String[] getElements() {
        ValencyCalculator.initialize();
        String[] st = new String[valencElectronMap.size()];
        int i = 0;
        for (String s : valencElectronMap.keySet()) {
            st[i++] = s;
        }
        return st;
    }

    public static Map<String, Integer> getElementMap() {
        ValencyCalculator.initialize();
        return Collections.unmodifiableMap(valencElectronMap);
    }

    public static int getSize() {
        ValencyCalculator.initialize();
        return valencElectronMap.size();
    }

    public static Iterable<String> getKeySet() {
        ValencyCalculator.initialize();
        return valencElectronMap.keySet();
    }

    public static int getValue(String key) {
        ValencyCalculator.initialize();
        return valencElectronMap.get(key);
    }

    private ValencyCalculator() {
    }
}

