/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2d;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.layout.SingleMoleculeLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.ZoomToFitLayout;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockReactionCanoniser;
import uk.ac.ebi.reactionblast.mapping.helper.MappingHandler;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLRXNV2000Reader;

public class TestUtility {
    public static final String KEGG_RXN_DIR = "rxn/kegg/";
    public static final String RHEA_RXN_DIR = "rxn/rhea/";
    public static final String BRENDA_RXN_DIR = "rxn/brenda/";
    public static final String BUG_RXN_DIR = "rxn/bug/";
    public static final String OTHER_RXN = "rxn/other/";
    public static final String METRXN_RXN = "rxn/metrxn/";
    public static final String INFORCHEM_RXN = "rxn/infochem/";
    public static final String MACIE_RXN = "rxn/macie/";
    private static final Logger LOG = Logger.getLogger(TestUtility.class.getName());

    protected static void setLonePairs(IReaction reaction) {
        LonePairElectronChecker checker = new LonePairElectronChecker();
        TestUtility.setLonePairs(reaction.getReactants(), checker);
        TestUtility.setLonePairs(reaction.getProducts(), checker);
    }

    protected static void setLonePairs(IAtomContainerSet AtomContainerSet2, LonePairElectronChecker checker) {
        for (IAtomContainer atomContainer : AtomContainerSet2.atomContainers()) {
            try {
                checker.saturate(atomContainer);
            }
            catch (CDKException c) {
                c.printStackTrace();
            }
        }
    }

    protected static void detectAromaticity(IReaction reaction) {
        TestUtility.detectAromaticity(reaction.getReactants());
        TestUtility.detectAromaticity(reaction.getProducts());
    }

    protected static void detectAromaticity(IAtomContainerSet molSet) {
        for (IAtomContainer ac : molSet.atomContainers()) {
            try {
                ExtAtomContainerManipulator.aromatizeCDK(ac);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
    }

    protected static void setMappingIDs(IReaction reaction) {
        int i = 0;
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            Object mappingID = a0.getProperty("cdk:AtomAtomMapping");
            if (mappingID != null) {
                a0.setID(String.valueOf(mappingID));
                a1.setID(String.valueOf(mappingID));
            } else {
                a0.setID(String.valueOf(i));
                a1.setID(String.valueOf(i));
            }
            ++i;
        }
    }

    protected static void renumberMappingIDs(IReaction reaction) {
        int i = 1;
        for (IMapping mapping : reaction.mappings()) {
            IAtom a0 = (IAtom)mapping.getChemObject(0);
            IAtom a1 = (IAtom)mapping.getChemObject(1);
            a0.setID(String.valueOf(i));
            a1.setID(String.valueOf(i));
            mapping.setID(String.valueOf(i));
            ++i;
        }
    }

    protected static void addImplicitHydrogens(IReaction reaction) {
        TestUtility.addImplicitHydrogens(reaction.getReactants());
        TestUtility.addImplicitHydrogens(reaction.getProducts());
    }

    protected static void addImplicitHydrogens(IAtomContainerSet molSet) {
        for (IAtomContainer atomContainer : molSet.atomContainers()) {
            TestUtility.addImplicitHydrogens(atomContainer);
        }
    }

    protected static void addImplicitHydrogens(IAtomContainer atomContainer) {
        try {
            CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance()).addImplicitHydrogens(atomContainer);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
    }

    protected static void typeAtoms(IAtomContainer atomContainer) {
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
    }

    protected static IReaction canonise(IReaction reaction) {
        BlockReactionCanoniser labeller = new BlockReactionCanoniser();
        return labeller.getCanonicalReaction(reaction);
    }

    protected static IAtomContainer layout(IAtomContainer AtomContainer2) {
        try {
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule(AtomContainer2, true);
            sdg.generateCoordinates();
            return sdg.getMolecule();
        }
        catch (CDKException e) {
            return AtomContainer2;
        }
    }

    protected static BufferedImage makeBlankImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        return image;
    }

    protected static void draw(DirectMoleculeDrawer molDrawer, IAtomContainer AtomContainer2, String dirPath, String name) throws IOException {
        int width = 700;
        int height = 700;
        SingleMoleculeLayout layout = new SingleMoleculeLayout(molDrawer.getParams());
        layout.layout(AtomContainer2, new Vector2d(width / 2, height / 2));
        ZoomToFitLayout layout2 = new ZoomToFitLayout(molDrawer);
        BufferedImage image = TestUtility.makeBlankImage(width, height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        layout2.layout(AtomContainer2, new Dimension(width, height), g);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            dir.mkdir();
        }
        ImageIO.write((RenderedImage)image, "PNG", new File(dir, name + ".png"));
    }

    protected static IReaction readReactionFile(String name, String dir, boolean reMap, boolean removeHydrogens) throws Exception {
        String filepath = dir + name + ".rxn";
        IReaction reaction = null;
        try (MDLRXNV2000Reader reader = new MDLRXNV2000Reader(new FileReader(filepath));){
            reaction = reader.read(new Reaction());
            reaction.setID(name);
        }
        catch (Exception ex) {
            Logger.getLogger(TestUtility.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (removeHydrogens && reaction != null) {
            Reaction hydrogenFreeReaction = new Reaction();
            AtomContainerSet hydrogenFreeReactants = new AtomContainerSet();
            for (IAtomContainer atomContainer : reaction.getReactants().atomContainers()) {
                TestUtility.setNullHCountToZero(atomContainer);
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                IAtomContainer acMinusH = ExtAtomContainerManipulator.convertExplicitToImplicitHydrogens(atomContainer);
                acMinusH.setID((String)atomContainer.getProperty("cdk:Title"));
                hydrogenFreeReactants.addAtomContainer(acMinusH);
            }
            hydrogenFreeReaction.setReactants(hydrogenFreeReactants);
            AtomContainerSet hydrogenFreeProducts = new AtomContainerSet();
            for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
                TestUtility.setNullHCountToZero(atomContainer);
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(atomContainer);
                IAtomContainer acMinusH = ExtAtomContainerManipulator.convertExplicitToImplicitHydrogens(atomContainer);
                acMinusH.setID((String)atomContainer.getProperty("cdk:Title"));
                hydrogenFreeProducts.addAtomContainer(acMinusH);
            }
            hydrogenFreeReaction.setProducts(hydrogenFreeProducts);
            for (IMapping mapping : reaction.mappings()) {
                if (((IElement)mapping.getChemObject(0)).getSymbol().equals("H") || ((IElement)mapping.getChemObject(1)).getSymbol().equals("H")) continue;
                hydrogenFreeReaction.addMapping(mapping);
            }
            reaction = hydrogenFreeReaction;
        }
        if (reMap) {
            MappingHandler.cleanMapping(reaction);
        } else {
            TestUtility.renumberMappingIDs(reaction);
        }
        return reaction;
    }

    static void setNullHCountToZero(IAtomContainer mol) {
        for (IAtom a : mol.atoms()) {
            if (a.getImplicitHydrogenCount() != null) continue;
            a.setImplicitHydrogenCount(0);
        }
    }

    protected List<IReaction> mapReactions(IReactionSet reactionSet, boolean remap) throws FileNotFoundException, Exception {
        ArrayList<IReaction> mappedReactionList = new ArrayList<IReaction>();
        for (IReaction cdkReaction : reactionSet.reactions()) {
            IReaction mappedReaction = this.mapReaction(cdkReaction, remap);
            mappedReactionList.add(mappedReaction);
        }
        return mappedReactionList;
    }

    protected IReaction mapReaction(IReaction cdkReaction, boolean remap) throws FileNotFoundException, Exception {
        String reactionName = cdkReaction.getID();
        IReaction cleanReaction = this.cleanReaction(cdkReaction, reactionName);
        ReactionMechanismTool rmt = new ReactionMechanismTool(cleanReaction, remap, true, false, new StandardizeReaction());
        IReaction mappedReaction = rmt.getSelectedSolution().getReaction();
        TestUtility.renumberMappingIDs(mappedReaction);
        return mappedReaction;
    }

    protected IReaction cleanReaction(IReaction reaction, String reactionName) throws Exception {
        reaction.setID(reactionName);
        return reaction;
    }
}

